/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.common.util;

import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.crypto.jni.PniccJNI;
import com.ubintis.crypto.util.Hex;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.List;

public class CheckSumUtil {
    public static String getFileCheckSum(String filePath) throws Exception {
        String checkSum = "";
        byte[] bPlain = CheckSumUtil.readBinaryFile(filePath);
        if (bPlain != null && bPlain.length > 0) {
            PniccJNI pniccJni = new PniccJNI();
            byte[] bHash = pniccJni.GenHASH((byte)4, bPlain);
            if (bHash != null && bHash.length > 0) {
                checkSum = Hex.encode((byte[])bHash);
            } else {
                throw new Exception("HASH data vlaue is null");
            }
        }
        return checkSum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFilesCheckSum(List<String> filePathList) throws Exception {
        String checkSum = "";
        StringBuffer checksumBuffer = new StringBuffer();
        if (filePathList == null) return checkSum;
        for (String filePath : filePathList) {
            String temp = CheckSumUtil.getFileCheckSum(filePath);
            if (temp == null) continue;
            checksumBuffer.append(CheckSumUtil.getFileCheckSum(filePath));
        }
        byte[] bPlain = StrUtil.convertByteArray(checksumBuffer.toString(), "UTF-8");
        if (bPlain == null) throw new Exception("String to byte[] convert error");
        if (bPlain.length <= 0) throw new Exception("String to byte[] convert error");
        PniccJNI pniccJni = new PniccJNI();
        byte[] bHash = pniccJni.GenHASH((byte)4, bPlain);
        if (bHash == null) throw new Exception("HASH data vlaue is null");
        if (bHash.length <= 0) throw new Exception("HASH data vlaue is null");
        return Hex.encode((byte[])bHash);
    }

    private static byte[] readBinaryFile(String file_path) throws IOException {
        byte[] bReturn = null;
        ByteArrayOutputStream ous = null;
        FilterInputStream ios = null;
        try {
            File file = new File(file_path);
            if (file != null && file.exists()) {
                byte[] buffer = new byte[4096];
                ous = new ByteArrayOutputStream();
                ios = new DataInputStream(new FileInputStream(file));
                int read = 0;
                while ((read = ((DataInputStream)ios).read(buffer)) != -1) {
                    ous.write(buffer, 0, read);
                }
                bReturn = ous.toByteArray();
            }
        }
        finally {
            if (ous != null) {
                ous.close();
            }
            if (ios != null) {
                ios.close();
            }
        }
        return bReturn;
    }
}

