/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.crypto;

import com.ubintis.crypto.jni.PniccJNI;

public class RSA {
    private String prikey = null;
    private String pubkey = null;
    private PniccJNI pnicc = new PniccJNI();

    public RSA(int modSize) {
        String sResult = this.pnicc.RSA_GenKey(modSize);
        if (sResult == null || sResult.length() <= 0) {
            return;
        }
        String[] rsakeypair = sResult.split("<<SEP>>");
        this.prikey = new String(rsakeypair[0]);
        this.pubkey = new String(rsakeypair[1]);
    }

    public RSA() {
    }

    public boolean GenKey(int modSize) {
        String sResult = this.pnicc.RSA_GenKey(modSize);
        if (sResult == null || sResult.length() <= 0) {
            return false;
        }
        String[] rsakeypair = sResult.split("<<SEP>>");
        this.prikey = new String(rsakeypair[0]);
        this.pubkey = new String(rsakeypair[1]);
        return true;
    }

    public String get_Prikey() {
        return this.prikey;
    }

    public String get_Pubkey() {
        return this.pubkey;
    }

    public void set_Prikey(String PriKey) {
        this.prikey = PriKey;
    }

    public void set_Pubkey(String PubKey) {
        this.pubkey = PubKey;
    }

    public boolean CheckKeyPair(String prikey, String pubkey) {
        return this.pnicc.RSA_CheckKeyPair(prikey, pubkey);
    }

    public byte[] OAEP_Encrypt(byte[] plain, String Pubkey) {
        return this.pnicc.RSA_Encrypt(plain, Pubkey, (byte)4);
    }

    public byte[] OAEP_Decrypt(byte[] cipher, String Prikey) {
        return this.pnicc.RSA_Decrypt(cipher, Prikey, (byte)4);
    }

    public String SSA_Sign(byte[] message, String Prikey) {
        return this.pnicc.RSA_SSA_Sign(message, Prikey, (byte)4);
    }

    public boolean SSA_Verify(byte[] message, String Pubkey, String sign) {
        return this.pnicc.RSA_SSA_Verify(message, Pubkey, (byte)4, sign);
    }
}

