/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.crypto;

import com.ubintis.crypto.jni.PniccJNI;

public class ECC {
    private int ectype = 0;
    private String prikey = null;
    private String pubkey = null;
    private PniccJNI pnicc = new PniccJNI();

    public ECC(int ecType, boolean optGen) {
        if (optGen) {
            String sResult = this.pnicc.ECC_GenKey(ecType);
            if (sResult == null || sResult.length() <= 0) {
                return;
            }
            String[] eckeypair = sResult.split("<<SEP>>");
            this.prikey = new String(eckeypair[0]);
            this.pubkey = new String(eckeypair[1]);
        }
        this.ectype = ecType;
    }

    public ECC(int ecType) {
        this.ectype = ecType;
    }

    public ECC() {
    }

    public boolean GenKey(int ecType) {
        String sResult = this.pnicc.ECC_GenKey(ecType);
        if (sResult == null || sResult.length() <= 0) {
            return false;
        }
        String[] eckeypair = sResult.split("<<SEP>>");
        this.prikey = new String(eckeypair[0]);
        this.pubkey = new String(eckeypair[1]);
        this.ectype = ecType;
        return true;
    }

    public int get_ecType() {
        return this.ectype;
    }

    public void set_ecType(int ecType) {
        this.ectype = ecType;
    }

    public String get_Prikey() {
        return this.prikey;
    }

    public String get_Pubkey() {
        return this.pubkey;
    }

    public void set_Prikey(String PriKey) {
        this.prikey = PriKey;
    }

    public void set_Pubkey(String PubKey) {
        this.pubkey = PubKey;
    }

    public boolean CheckKeyPair(String prikey, String pubkey) {
        return this.pnicc.ECC_CheckKeyPair(this.ectype, prikey, pubkey);
    }

    public String ECDSA_Sign(byte[] message, String Prikey) {
        return this.pnicc.ECDSA_Sign(message, this.ectype, Prikey, (byte)4);
    }

    public boolean ECDSA_Verify(byte[] message, String Pubkey, String sign) {
        return this.pnicc.ECDSA_Verify(message, this.ectype, Pubkey, (byte)4, sign);
    }

    public byte[] ECDH_CalculateKey(String prikeyA, String pubkeyB) {
        return this.pnicc.ECDH_CalculateKey(this.ectype, prikeyA, pubkeyB);
    }
}

