/*
 * Decompiled with CFR 0.152.
 */
package com.sci.v2.pcc.secu.seed.util;

public class ByteUtils {
    private static String[] _hexPseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    public static Byte DEFAULT_BYTE = new Byte(0);

    public static byte toByte(String value, byte defaultValue) {
        try {
            return Byte.parseByte(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Byte toByteObject(String value, Byte defaultValue) {
        try {
            return new Byte(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int unsignedByte(byte b) {
        return b & 0xFF;
    }

    public static int toInt(byte[] src, int srcPos) {
        int dword = 0;
        int i = 0;
        while (i < 4) {
            dword = (dword << 8) + (src[i + srcPos] & 0xFF);
            ++i;
        }
        return dword;
    }

    public static int toInt(byte[] src) {
        return ByteUtils.toInt(src, 0);
    }

    public static long toLong(byte[] src, int srcPos) {
        long qword = 0L;
        int i = 0;
        while (i < 8) {
            qword = (qword << 8) + (long)(src[i + srcPos] & 0xFF);
            ++i;
        }
        return qword;
    }

    public static long toLong(byte[] src) {
        return ByteUtils.toLong(src, 0);
    }

    public static void toBytes(int value, byte[] dest, int destPos) {
        int i = 0;
        while (i < 4) {
            dest[i + destPos] = (byte)(value >> (7 - i) * 8);
            ++i;
        }
    }

    public static byte[] toBytes(int value) {
        byte[] dest = new byte[4];
        ByteUtils.toBytes(value, dest, 0);
        return dest;
    }

    public static void toBytes(long value, byte[] dest, int destPos) {
        int i = 0;
        while (i < 8) {
            dest[i + destPos] = (byte)(value >> (7 - i) * 8);
            ++i;
        }
    }

    public static byte[] toBytes(long value) {
        byte[] dest = new byte[8];
        ByteUtils.toBytes(value, dest, 0);
        return dest;
    }

    public static byte[] toBytes(String digits, int radix) throws IllegalArgumentException, NumberFormatException {
        if (digits == null) {
            return null;
        }
        if (radix != 16 && radix != 10 && radix != 8) {
            throw new IllegalArgumentException("For input radix: \"" + radix + "\"");
        }
        int divLen = radix == 16 ? 2 : 3;
        int length = digits.length();
        if (length % divLen == 1) {
            throw new IllegalArgumentException("For input string: \"" + digits + "\"");
        }
        byte[] bytes = new byte[length /= divLen];
        int i = 0;
        while (i < length) {
            int index = i * divLen;
            bytes[i] = (byte)Short.parseShort(digits.substring(index, index + divLen), radix);
            ++i;
        }
        return bytes;
    }

    public static byte[] toBytesFromHexString(String digits) throws IllegalArgumentException, NumberFormatException {
        if (digits == null) {
            return null;
        }
        int length = digits.length();
        if (digits.length() % 2 != 0) {
            throw new IllegalArgumentException("For input string(Check Number Size: \"" + digits + "\"");
        }
        if (length % 2 == 1) {
            throw new IllegalArgumentException("For input string: \"" + digits + "\"");
        }
        byte[] bytes = new byte[length /= 2];
        int i = 0;
        while (i < length) {
            int index = i * 2;
            bytes[i] = (byte)Short.parseShort(digits.substring(index, index + 2), 16);
            ++i;
        }
        return bytes;
    }

    public static String toHexString(byte b) {
        StringBuffer result = new StringBuffer(3);
        result.append(Integer.toString((b & 0xF0) >> 4, 16));
        result.append(Integer.toString(b & 0xF, 16));
        return result.toString();
    }

    public static String toHexString(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = offset;
        while (i < offset + length) {
            result.append(Integer.toString((bytes[i] & 0xF0) >> 4, 16));
            result.append(Integer.toString(bytes[i] & 0xF, 16));
            ++i;
        }
        return result.toString();
    }

    public static boolean equals(byte[] array1, byte[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String string2hexString(String str) {
        StringBuffer result = new StringBuffer("");
        int x = 0;
        while (x < str.length()) {
            if (x == str.length() - 1) {
                result.append(String.valueOf(Integer.toHexString(str.charAt(x))));
            } else {
                result.append(String.valueOf(Integer.toHexString(str.charAt(x))));
            }
            ++x;
        }
        return result.toString();
    }

    public static byte[] convertHexStringToByteArray(String hexString) {
        byte[] b = new byte[hexString.length() / 2];
        String subStr = null;
        int nIndex = 0;
        while (nIndex < hexString.length()) {
            subStr = hexString.substring(nIndex, nIndex + 2);
            char c = (char)Integer.parseInt(subStr, 16);
            b[nIndex / 2] = (byte)c;
            nIndex += 2;
        }
        return b;
    }

    public static String convertByteArrayToHexString(byte[] sourceBytes) {
        byte ch = 0;
        int nIndex = 0;
        if (sourceBytes == null || sourceBytes.length <= 0) {
            return "";
        }
        StringBuffer sbOut = new StringBuffer(sourceBytes.length * 2);
        while (nIndex < sourceBytes.length) {
            ch = (byte)(sourceBytes[nIndex] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            sbOut.append(_hexPseudo[ch]);
            ch = (byte)(sourceBytes[nIndex] & 0xF);
            sbOut.append(_hexPseudo[ch]);
            ++nIndex;
        }
        return sbOut.toString();
    }
}

