/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.pivot;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.pivot.TbPivotMeta;
import com.tmax.tibero.pivot.TbPivotValHdrItem;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class TbPivotValReader {
    private static final int FETCH_SIZE = 65536;
    Blob blobData;
    byte[] byteData;
    int itemCnt;
    int offsetIdx;
    boolean hasByteData;
    int blobDataLen;
    int prevOffset = 0;
    int blobDataLocalEndPos;
    int localOffset = 0;
    Vector hdr;
    HashMap newIdxMap;

    private byte[] getNextRpcolData() throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.offsetIdx >= this.itemCnt) {
            throw new Exception("offset index out of bound (itemCnt: " + this.itemCnt + ", offsetIdx: " + this.offsetIdx);
        }
        int n5 = ((TbPivotValHdrItem)this.hdr.elementAt(this.offsetIdx)).getOffset();
        if (!this.hasByteData) {
            this.localOffset += n5 - this.prevOffset;
        }
        if (this.localOffset <= 0 && !this.hasByteData) {
            int n6;
            int n7;
            byte[] byArray = this.blobData.getBytes(n5 + 1, 1);
            int n8 = 0xFF & byArray[0];
            if (0 <= n8 && n8 <= 250) {
                n7 = n8;
                n6 = 1;
            } else if (n8 == 254) {
                byte[] byArray2 = this.blobData.getBytes(n5 + 2, 2);
                int n9 = 0xFF & byArray2[0];
                int n10 = 0xFF & byArray2[1];
                n7 = 0xFF & n9 << 8;
                n7 &= 0xFF & n10;
                n6 = 3;
            } else {
                throw new Exception("invalid rpcol first length byte: " + n8);
            }
            if (n7 == 0) {
                ++this.offsetIdx;
                return null;
            }
            if (n7 < 0) {
                throw new Exception("invalid rpcol length: " + n7);
            }
            byte[] byArray3 = this.blobData.getBytes(n5 + n6 + 1, n7);
            this.prevOffset = n5;
            ++this.offsetIdx;
            return byArray3;
        }
        if (n5 >= this.blobDataLocalEndPos) {
            this.getNextBlobDataChunk(n5);
        }
        if (0 <= (n4 = !this.hasByteData ? 0xFF & this.byteData[this.localOffset] : 0xFF & this.byteData[n5]) && n4 <= 250) {
            n3 = n4;
            n2 = 1;
        } else if (n4 == 254) {
            int n11;
            if (n5 + 2 >= this.blobDataLocalEndPos) {
                this.getNextBlobDataChunk(n5);
            }
            if (!this.hasByteData) {
                n = 0xFF & this.byteData[this.localOffset + 1];
                n11 = 0xFF & this.byteData[this.localOffset + 2];
            } else {
                n = 0xFF & this.byteData[n5 + 1];
                n11 = 0xFF & this.byteData[n5 + 2];
            }
            n3 = 0xFF & n << 8;
            n3 &= 0xFF & n11;
            n2 = 3;
        } else {
            throw new Exception("invalid rpcol first length byte: " + n4);
        }
        if (n3 == 0) {
            ++this.offsetIdx;
            return null;
        }
        if (n3 < 0) {
            throw new Exception("invalid rpcol length: " + n3);
        }
        byte[] byArray = new byte[n3];
        while (n5 + n2 + n3 - 1 > this.blobDataLocalEndPos) {
            this.getNextBlobDataChunk(n5);
        }
        if (!this.hasByteData) {
            for (n = 0; n < n3; ++n) {
                byArray[n] = this.byteData[this.localOffset + n2 + n];
            }
        } else {
            for (n = 0; n < n3; ++n) {
                byArray[n] = this.byteData[n5 + n2 + n];
            }
        }
        this.prevOffset = n5;
        ++this.offsetIdx;
        return byArray;
    }

    private void getNextBlobDataChunk(int n) throws Exception {
        if (this.blobDataLen > n + 65536 - 1) {
            this.byteData = this.blobData.getBytes(n, n + 65536 - 1);
            this.blobDataLocalEndPos = n + 65536 - 1;
        } else {
            this.byteData = this.blobData.getBytes(n, this.blobDataLen);
            this.blobDataLocalEndPos = this.blobDataLen;
        }
        this.localOffset = 1;
    }

    private void getAllBlobDataChunk() throws Exception {
        this.byteData = this.blobData.getBytes(1L, this.blobDataLen);
        this.blobDataLocalEndPos = this.blobDataLen;
        this.hasByteData = true;
    }

    private byte[] getNextRpcolForNumber() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        if (byArray.length > 250) {
            throw new Exception("invalid rpcol length for number: " + byArray.length);
        }
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i + 1] = byArray[i];
        }
        return byArray2;
    }

    private int getNextIntForHdr(InputStream inputStream) throws Exception {
        int n = 0;
        int n2 = 24;
        for (int i = 0; i < 4; ++i) {
            int n3 = inputStream.read();
            n += n3 << n2;
            n2 -= 8;
        }
        return n;
    }

    private int getNextIntFrom4ByteArr(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 24;
        while (n3 < 4) {
            int n5 = 0xFF & this.byteData[n + n3];
            n2 += n5 << n4;
            ++n3;
            n4 -= 8;
        }
        return n2;
    }

    private int getNextIntFrom2ByteArr(int n) {
        int n2 = ((0xFF & this.byteData[n]) << 8) + (0xFF & this.byteData[n + 1]);
        return n2;
    }

    private int getNewIdx(int n) {
        return (Integer)this.newIdxMap.get(new Integer(n));
    }

    public TbPivotValReader(Blob blob, int n, TbPivotMeta tbPivotMeta) throws Exception {
        this.blobData = blob;
        this.offsetIdx = 0;
        this.byteData = ((TbBlob)blob).getLobData();
        this.hdr = new Vector();
        this.newIdxMap = tbPivotMeta.getNewIdxMap(n);
        if (this.byteData == null) {
            InputStream inputStream = blob.getBinaryStream();
            this.itemCnt = this.getNextIntForHdr(inputStream);
            for (int i = 0; i < this.itemCnt; ++i) {
                int n2 = this.getNewIdx(this.getNextIntForHdr(inputStream));
                int n3 = this.getNextIntForHdr(inputStream);
                this.hdr.add(new TbPivotValHdrItem(n2, n3));
            }
            inputStream.close();
            this.blobDataLen = (int)blob.length();
            if (this.blobDataLen < 65536) {
                this.getAllBlobDataChunk();
                this.hasByteData = true;
            } else {
                this.hasByteData = false;
            }
        } else {
            int n4 = 0;
            this.itemCnt = this.getNextIntFrom4ByteArr(n4);
            n4 += 4;
            for (int i = 0; i < this.itemCnt; ++i) {
                int n5 = this.getNewIdx(this.getNextIntFrom4ByteArr(n4));
                int n6 = this.getNextIntFrom2ByteArr(n4 + 4);
                this.hdr.add(new TbPivotValHdrItem(n5, n6));
                n4 += 6;
            }
            this.blobDataLocalEndPos = (int)blob.length();
            this.hasByteData = true;
        }
        Collections.sort(this.hdr);
    }

    public int getColNameIdx(int n) throws Exception {
        return ((TbPivotValHdrItem)this.hdr.elementAt(n)).getNameIdx();
    }

    public int getCnt() {
        return this.itemCnt;
    }

    public Long getNextLong() throws Exception {
        byte[] byArray = this.getNextRpcolForNumber();
        if (byArray == null) {
            return null;
        }
        return new Long(TbNumber.toLong(byArray, 0, byArray.length));
    }

    public Integer getNextInt() throws Exception {
        byte[] byArray = this.getNextRpcolForNumber();
        if (byArray == null) {
            return null;
        }
        return new Integer(TbNumber.toInteger(byArray, 0, byArray.length));
    }

    public Double getNextDouble() throws Exception {
        byte[] byArray = this.getNextRpcolForNumber();
        if (byArray == null) {
            return null;
        }
        return new Double(TbNumber.toDouble(byArray, 0, byArray.length));
    }

    public BigDecimal getNextBigDecimal() throws Exception {
        byte[] byArray = this.getNextRpcolForNumber();
        if (byArray == null) {
            return null;
        }
        return TbNumber.toBigDecimal(byArray, 0, byArray.length);
    }

    public String getNextString() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public Date getNextDate() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 8) {
            throw new Exception("invalid rpcol length for date: " + byArray.length);
        }
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = 0xFF & byArray[2];
        int n4 = 0xFF & byArray[3];
        int n5 = 0xFF & byArray[4];
        int n6 = 0xFF & byArray[5];
        int n7 = 0xFF & byArray[6];
        int n8 = (n - 100) * 100 + (n2 - 100);
        int n9 = n3 - 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(n8, n9, n4, n5, n6, n7);
        return new Date(calendar.getTime().getTime());
    }

    public Timestamp getNextTimestamp() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 12) {
            throw new Exception("invalid rpcol length for timestamp: " + byArray.length);
        }
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = 0xFF & byArray[2];
        int n4 = 0xFF & byArray[3];
        int n5 = 0xFF & byArray[4];
        int n6 = 0xFF & byArray[5];
        int n7 = 0xFF & byArray[6];
        int n8 = (n - 100) * 100 + (n2 - 100);
        int n9 = n3 - 1;
        int n10 = TbCommon.bytes2Int(byArray, 8, 4);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n8, n9, n4, n5, n6, n7);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(n10);
        return timestamp;
    }

    public Time getNextTime() throws Exception {
        byte[] byArray = this.getNextRpcolData();
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 8) {
            throw new Exception("invalid rpcol length for time: " + byArray.length);
        }
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = 0xFF & byArray[2];
        int n4 = TbCommon.bytes2Int(byArray, 4, 4);
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        timestamp.setNanos(n4);
        return new Time(timestamp.getTime());
    }
}

