/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import java.sql.SQLException;

public class BindItem {
    private int paramMode = 0;
    private int sqlType = 0;
    private int length;
    private TbColumnDesc[] colMeta;
    private TbTypeDescriptor typeDesc;
    private String typeName;

    public void clone(BindItem bindItem) {
        bindItem.paramMode = this.paramMode;
        bindItem.sqlType = this.sqlType;
        bindItem.length = this.length;
        bindItem.typeName = this.typeName;
        bindItem.typeDesc = this.typeDesc;
    }

    public TbColumnDesc[] getColMeta() {
        return this.colMeta;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public int getLength() {
        return this.length;
    }

    public int getParamMode() {
        return this.paramMode;
    }

    public TbTypeDescriptor getTypeDescriptor() {
        return this.typeDesc;
    }

    public boolean isDFRParameter() {
        return this.paramMode == 8;
    }

    public boolean isINOUTParameter() {
        return this.paramMode == 4;
    }

    public boolean isINParameter() {
        return this.paramMode == 1 || this.paramMode == 4;
    }

    public boolean isOUTParameter() {
        return this.paramMode == 2 || this.paramMode == 4;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void reset() {
        if (this.colMeta != null) {
            for (int i = 0; i < this.colMeta.length; ++i) {
                this.colMeta[i] = null;
            }
            this.colMeta = null;
        }
        if (this.typeDesc != null) {
            this.typeDesc = null;
        }
    }

    public void reuse() {
        this.paramMode = 0;
        this.sqlType = 0;
        this.typeName = null;
        if (this.colMeta != null) {
            for (int i = 0; i < this.colMeta.length; ++i) {
                this.colMeta[i] = null;
            }
            this.colMeta = null;
        }
        if (this.typeDesc != null) {
            this.typeDesc = null;
        }
    }

    public void set(int n, int n2) {
        this.setParamMode(n);
        this.sqlType = n2;
    }

    public void set(int n, int n2, int n3) throws SQLException {
        this.setParamMode(n);
        this.sqlType = n2;
        this.length = n3;
    }

    public void set(int n, int n2, TbColumnDesc[] tbColumnDescArray, TbTypeDescriptor tbTypeDescriptor) throws SQLException {
        this.paramMode = 2;
        this.sqlType = n;
        this.length = n2;
        this.colMeta = tbColumnDescArray;
        this.typeDesc = tbTypeDescriptor;
    }

    public void set(int n, int n2, TbColumnDesc[] tbColumnDescArray, TbTypeDescriptor tbTypeDescriptor, String string) throws SQLException {
        this.paramMode = 2;
        this.sqlType = n;
        this.length = n2;
        this.colMeta = tbColumnDescArray;
        this.typeDesc = tbTypeDescriptor;
        this.typeName = string;
    }

    private void setParamMode(int n) {
        this.paramMode = this.paramMode == 1 && n == 2 || this.paramMode == 2 && n == 1 ? 4 : n;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void requestUdtMeta(int n, TbConnection tbConnection) throws SQLException {
        String string = tbConnection.info.getUser();
        String[] stringArray = this.typeName.split("[.]{1}");
        if (stringArray.length != 1) {
            if (stringArray.length == 2) {
                string = stringArray[0];
                this.typeName = stringArray[1];
            } else {
                throw TbError.newSQLException(-90649);
            }
        }
        switch (n) {
            case 2002: {
                this.typeDesc = TbStructDescriptor.lookupUdtMeta(string, this.typeName, tbConnection);
                break;
            }
            case -2003: 
            case 2003: {
                this.typeDesc = TbArrayDescriptor.lookupUdtMeta(string, this.typeName, tbConnection);
            }
        }
    }

    public void setTypeDescriptor(TbTypeDescriptor tbTypeDescriptor) {
        this.typeDesc = tbTypeDescriptor;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(96);
        stringBuilder.append(super.toString()).append("[mode=").append(this.paramMode).append("/sqlType=").append(this.sqlType).append("/length=").append(this.length).append("/colMeta=").append(this.colMeta).append("/typeDescriptor=").append(this.typeDesc).append("/typeName=").append(this.typeName).append(']');
        return stringBuilder.toString();
    }
}

