/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.event;

import com.tmax.tibero.event.EventManager;
import com.tmax.tibero.event.Notification;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.NodeInfo;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EventSubscriber {
    private AtomicInteger state = new AtomicInteger(0);
    private static final int STATE_NONE = 0;
    private static final int STATE_NOT_REGISTERED = 1;
    private static final int STATE_REGISTERED = 2;
    private static final int STATE_CLOSED = 3;
    private final BlockingQueue<Notification> notificationQueue;
    private static AtomicInteger genId = new AtomicInteger(1);
    protected int id = genId.getAndIncrement();

    public EventSubscriber(Connection connection, int n) throws Exception {
        this(connection, new int[]{n});
    }

    public EventSubscriber(Connection connection, int[] nArray) throws Exception {
        this.notificationQueue = new LinkedBlockingDeque<Notification>();
        this.register(connection, nArray);
    }

    public void close() {
        if (this.state.compareAndSet(2, 3)) {
            this.unregister();
        }
    }

    public void register(Connection connection, int[] nArray) throws Exception {
        if (this.state.compareAndSet(0, 1)) {
            String string = "";
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90400, iOException.getMessage());
            }
            if (!EventManager.getIsRunning()) {
                try {
                    EventManager.boot();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String object = ManagementFactory.getRuntimeMXBean().getName();
                String string2 = "SYS.SYS_NOTICE_Q:SYS_SUB";
                String string3 = "register";
                String n = "DECLARE\n    reginfo    dbms_aq.aq$_reg_info;\n    reg_list   dbms_aq.aq$_reg_info_list;\nBEGIN\n    reginfo.name := '" + string2 + "';\n    reginfo.namespace := DBMS_AQ.NAMESPACE_AQ;\n    reginfo.callback := 'jdbc://" + string + ":" + object + "';\n    reginfo.context := HEXTORAW('FF');\n    reg_list  := dbms_aq.aq$_reg_info_list(reginfo);\n    dbms_aq." + string3 + " (reg_list, 1);\nEND;\n";
                Statement statement = connection.createStatement();
                statement.execute(n);
                statement.close();
            }
            for (int n : nArray) {
                this.registerEventPort(connection, n);
            }
            EventManager.registerSubscriber(this);
            this.state.set(2);
        }
    }

    public void reRegisterEventPort(Connection connection, int n) throws Exception {
        if (this.state.get() == 2) {
            EventManager.removePort(n);
            this.registerEventPort(connection, n);
        }
    }

    private void registerEventPort(Connection connection, int n) throws Exception {
        if (connection.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (!EventManager.hasEventPort(n)) {
            String string = "";
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90400, iOException.getMessage());
            }
            String string2 = ((NodeInfo)((TbConnection)connection).info.getNodeList().get(0)).getAddress();
            try {
                SocketChannel socketChannel = null;
                socketChannel = SocketChannel.open();
                socketChannel.connect(new InetSocketAddress(string2, n));
                ByteBuffer byteBuffer = ByteBuffer.allocate(4098);
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(4098);
                socketChannel.read(byteBuffer);
                byteBuffer.flip();
                if (TbCommon.bytes2Int(byteBuffer.array(), 0, 4) == 75) {
                    byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22};
                    byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                    DataTypeConverter dataTypeConverter = new DataTypeConverter(null);
                    String string3 = ManagementFactory.getRuntimeMXBean().getName();
                    String string4 = "jdbc://" + string + ":" + string3;
                    byte[] byArray3 = dataTypeConverter.getDBEncodedBytes(string4);
                    int n2 = byArray3.length;
                    int n3 = TbCommon.getPadLength(n2);
                    TbCommon.int2Bytes(394, byArray, 0, 4);
                    TbCommon.int2Bytes(2, byArray, 16, 4);
                    TbCommon.int2Bytes(17, byArray, 20, 4);
                    TbCommon.int2Bytes(n2, byArray, 32, 4);
                    TbCommon.int2Bytes(28 + n2 + n3, byArray, 4, 4);
                    byteBuffer2.put(byArray);
                    byteBuffer2.put(byArray3);
                    for (int i = 0; i < n3; ++i) {
                        byteBuffer2.put(new byte[]{0});
                    }
                    byteBuffer2.put(byArray2);
                    byteBuffer2.flip();
                    while (byteBuffer2.hasRemaining()) {
                        socketChannel.write(byteBuffer2);
                    }
                    byteBuffer2.clear();
                    byteBuffer.clear();
                    socketChannel.read(byteBuffer);
                    byteBuffer.flip();
                    if (TbCommon.bytes2Int(byteBuffer.array(), 0, 4) != 75) {
                        throw new SQLException("Invalid Message Type: " + TbCommon.bytes2Int(byteBuffer.array(), 0, 4));
                    }
                } else {
                    throw new SQLException("Invalid Message Type: " + TbCommon.bytes2Int(byteBuffer.array(), 0, 4));
                }
                socketChannel.configureBlocking(false);
                EventManager.registerSocket(n, socketChannel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SQLException(exception.getMessage());
            }
        }
    }

    private void unregister() {
        EventManager.unregisterSubscriber(this);
    }

    public Notification take() throws InterruptedException {
        return this.notificationQueue.take();
    }

    public Notification poll(long l) throws InterruptedException {
        return l == 0L ? (Notification)this.notificationQueue.poll() : this.notificationQueue.poll(l, TimeUnit.MILLISECONDS);
    }

    protected void put(Notification notification) throws InterruptedException {
        this.notificationQueue.put(notification);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

