/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.event;

import com.tmax.tibero.event.Event;
import com.tmax.tibero.event.EventFactory;
import com.tmax.tibero.event.EventHandler;
import com.tmax.tibero.event.EventManager;
import com.tmax.tibero.event.EventSubscriber;
import com.tmax.tibero.event.Notification;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class ChannelEventManager
implements Runnable {
    private static final int BUF_CAPACITY = 4096;
    private Selector selector = null;
    private ByteBuffer recvByteBuffer = null;
    private ByteBuffer sendByteBuffer = null;

    public void register(SocketChannel socketChannel) throws ClosedChannelException {
        socketChannel.register(this.selector, 1);
    }

    private void init() throws IOException {
        this.recvByteBuffer = ByteBuffer.allocate(4096);
        this.sendByteBuffer = ByteBuffer.allocate(4096);
        this.selector = Selector.open();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws IOException {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        EventManager.down();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            while (!Thread.currentThread().isInterrupted()) {
                Thread.sleep(100L);
                this.selector.select(1000L);
                Set<SelectionKey> set = this.selector.selectedKeys();
                Iterator<SelectionKey> iterator = set.iterator();
                while (iterator.hasNext()) {
                    SocketChannel socketChannel;
                    int n;
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    if (!selectionKey.isReadable() || (n = (socketChannel = (SocketChannel)selectionKey.channel()).read(this.recvByteBuffer)) < 0) continue;
                    this.recvByteBuffer.flip();
                    if (!this.recvByteBuffer.hasRemaining()) continue;
                    if (TbCommon.bytes2Int(this.recvByteBuffer.array(), 0, 4) == 395) {
                        DataTypeConverter dataTypeConverter = new DataTypeConverter(null);
                        byte[] byArray = this.recvByteBuffer.array();
                        int n2 = TbCommon.bytes2Int(byArray, 16, 4);
                        int n3 = TbCommon.bytes2Int(byArray, 20, 4);
                        int n4 = TbCommon.bytes2Int(byArray, 24, 4);
                        int n5 = TbCommon.bytes2Int(byArray, 28, 4);
                        int n6 = TbCommon.bytes2Int(byArray, 32, 4);
                        int n7 = TbCommon.bytes2Int(byArray, 36, 4);
                        String string = dataTypeConverter.getDBDecodedString(byArray, 40, n7);
                        byte[] byArray2 = new byte[]{0, 0, 0, 75, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                        socketChannel.write(byteBuffer);
                        this.recvByteBuffer.clear();
                        try {
                            for (EventSubscriber eventSubscriber : EventManager.getSubscribers()) {
                                eventSubscriber.put(new Notification(n2, n3, n4, n5, n6, string));
                            }
                            Integer[] integerArray2 = EventManager.getSystemEventRegIDs();
                            Event event = EventFactory.createSystemEvent(n2, n3, n4, n5, n6, string);
                            this.handleEvent(event, integerArray2);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    this.recvByteBuffer.clear();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (this.selector != null) {
                    this.selector.close();
                }
                if (this.recvByteBuffer != null) {
                    this.recvByteBuffer = null;
                }
                if (this.sendByteBuffer != null) {
                    this.sendByteBuffer = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void handleEvent(Event event, Integer[] integerArray) {
        if (event == null) {
            return;
        }
        EventHandler eventHandler = EventManager.getEventHandlerMap(event.getEventType());
        if (eventHandler != null) {
            try {
                eventHandler.onEvent(event, integerArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

