/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.common.util;

import com.ubintis.agt5.framework.log.PniLogger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtil {
    private static final PniLogger LOGGER = PniLogger.getLogger();

    public static String getServerIp() {
        String serverIp = "";
        List<String> serverIpList = NetworkUtil.getServerIpList();
        int i = 0;
        for (String temp : serverIpList) {
            serverIp = String.valueOf(serverIp) + temp;
            if (i < serverIpList.size() - 1) {
                serverIp = String.valueOf(serverIp) + ",";
            }
            ++i;
        }
        return serverIp;
    }

    public static List<String> getServerIpList() {
        ArrayList<String> serverIpList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                List<InterfaceAddress> interfaceAddresses = networkInterfaces.nextElement().getInterfaceAddresses();
                for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                    InetAddress address = interfaceAddress.getAddress();
                    if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    serverIpList.add(address.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error(e.getMessage());
        }
        return serverIpList;
    }
}

