/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.crypto.jni;

import com.ubintis.crypto.ECC;
import com.ubintis.crypto.PRNG;
import com.ubintis.crypto.RSA;
import com.ubintis.crypto.jni.PniccJNI;
import com.ubintis.crypto.util.Hex;
import java.util.Arrays;

public class PniccJNITest {
    static byte[] g_btArrayMKey = null;
    String rsaPriKey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
    String rsaPubKey2048 = "010001^B083ED46F3E39E5B8965AD21060DAA42AA69D0EF06CE3C6F49A22D221E0B58C93559D15AF340B3EC2F08F71496440A62E51E6D92034CD4F902D2DE611730ED7A061B1BD7C4371AEF34F43A3B26B31CB26BD8DA50A7C830F841D85B9B6A6D6130C6AF14BD40D47894C2A5A5FF408C7F7498C9D7D05A2859663969C751E6A72AF1D6D025C7E1E0EC043EFFB000A79B5B417B70661E8E1BD6D4CF43749F2880342989CB9AA6E6DA5B331462686099E188074057B90BF83BDA8F4619DA8E30F6C03513A6A86B43C1C951CA7168126DDA9182698B094C7DF3611B7F112D54C0168527DF7B175C59510AF75DE2BC80DB0A7AE1A837D12F0CBCC7629E5264EAF9BD6929";
    String ecPrikey_p224 = "36B5F601C5BD32CE2FB931B86FE6A2A0DD66B0F6DD4C8D58E54D3124";
    String ecPubkey_p224 = "533E9CBD3147F11161600966E02B3FFB801C70E7375DA13C6ED20E0EE350548CC0190A7E519E02A2B71030113811696C1C5D3FCE625A3A51";
    String ecPrikey_p256 = "B4FB1D16C42CB93306B44F0E76BB8906973B08C7078D97FD15ED5BCD2A279398";
    String ecPubkey_p256 = "88EE0FC71C943374807E108479F4354A6A114AD90CE30B468F6ABAA37E5C0E44E4930F501B628BF063A301F0C6639D7CAFB4288C2E19C179EB23E888B5DD4B11";

    public int TEST_GenPBKDF2MasterKey(String strPasswd, byte saltType) {
        PniccJNI pnicc = new PniccJNI();
        String str_mkeyvector = "AE049705198EC3DC14EADBAA7A21EA74A83B47127CC9F6A1B1032EDD2B98ADE7E1E07F5BDEDB973BD44140DC05E615A3C0732B98D7F649C4D7355B510BD4E763043BDA56";
        System.out.println("\n------------------------------------------");
        System.out.println("GenPBKDF2MasterKey : 68byte Keygen");
        System.out.println("------------------------------------------");
        g_btArrayMKey = pnicc.GenPBKDF2MasterKey(strPasswd, saltType);
        System.out.println("password : " + strPasswd + " / " + saltType);
        if (g_btArrayMKey == null) {
            System.out.println("GenPBKDF2MasterKey return null");
            return 1;
        }
        String str_mkey = Hex.encode(g_btArrayMKey);
        System.out.println("PBKDF2Key(hex) : ");
        System.out.println(str_mkey);
        if (!str_mkey.equals(str_mkeyvector)) {
            System.out.println("\nGenPBKDF2MasterKey is ..FAILED !!");
            return 1;
        }
        System.out.println("\nGenPBKDF2MasterKey is ..OK !!");
        return 0;
    }

    public int TEST_GenPBKDF2MasterKey_OLD(String strPasswd, int saltType) {
        PniccJNI pnicc = new PniccJNI();
        String str_mkeyvector = "A46966090CA043A1C86DD3EFC9B21967CAB02E89A343CF38F2791CD55523555A67086E430B4F213D515731D8FA3AA058A5B70DA21F188F2FF1259037BECE5822BE0BF3DC";
        System.out.println("\n------------------------------------------");
        System.out.println("GenPBKDF2MasterKey(OLD-\uad6c\ubc84\uc804\ud638\ud658) : 68byte Keygen");
        System.out.println("------------------------------------------");
        byte[] btArrayMKey = pnicc.GenPBKDF2MasterKeyOld(strPasswd, saltType);
        System.out.println("password : " + strPasswd + " / " + saltType);
        if (btArrayMKey == null) {
            System.out.println("GenPBKDF2MasterKeyOld return null");
            return 1;
        }
        String str_mkey = Hex.encode(btArrayMKey);
        System.out.println("PBKDF2Key(hex) : ");
        System.out.println(str_mkey);
        if (!str_mkey.equals(str_mkeyvector)) {
            System.out.println("\nGenPBKDF2MasterKey(OLD) is ..FAILED !!");
            return 1;
        }
        System.out.println("\nGenPBKDF2MasterKey(OLD) is ..OK !!");
        return 0;
    }

    public int TEST_GenPBKDF2MasterKeyEx(String strPasswd, byte saltType, byte hashType) {
        PniccJNI pnicc = new PniccJNI();
        String[] szHashName = new String[]{"HAS160", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
        System.out.println("\n------------------------------------------");
        System.out.println("GenPBKDF2MasterKeyEx(" + szHashName[hashType - 1] + ") : 68byte Keygen ");
        System.out.println("------------------------------------------");
        byte[] btArrayMKey = pnicc.GenPBKDF2MasterKeyEx(strPasswd.getBytes(), saltType, hashType);
        System.out.println("password : " + strPasswd + " / " + saltType);
        if (btArrayMKey == null) {
            System.out.println("GenPBKDF2MasterKeyEx return null");
            return 1;
        }
        String str_mkey = Hex.encode(btArrayMKey);
        System.out.println("PBKDF2Key(hex) : ");
        System.out.println(str_mkey);
        System.out.println("\nGenPBKDF2MasterKeyEx is ..OK !!");
        return 0;
    }

    public int TEST_EncNDec_raw(byte AlgType, byte opMode, byte padding) {
        String strPlain = "PniccJNI \ud14c\uc2a4\ud2b8 \ud504\ub85c\uadf8\ub7a8 \ud3c9\ubb38\uc785\ub2c8\ub2e4.";
        byte[] key = new byte[32];
        byte[] iv = new byte[16];
        String[] szAlgName = new String[]{"ARIA128", "ARIA192", "ARIA256", "SEED", "LEA128", "LEA192", "LEA256", "HIGHT"};
        String[] szOpMode = new String[]{"ECB", "CBC", "CTR", "CCM"};
        String[] szPadding = new String[]{"NONE", "PKCS7", "X923"};
        PniccJNI pnicc = new PniccJNI();
        System.out.println("\n-------------------------------------------------");
        System.out.println("Block Cipher Encypt/Decrypt Test - " + szAlgName[AlgType - 1] + "-" + szOpMode[opMode - 1] + "-" + szPadding[padding]);
        System.out.println("-------------------------------------------------");
        System.arraycopy(g_btArrayMKey, 0, key, 0, 32);
        System.arraycopy(g_btArrayMKey, 32, iv, 0, 16);
        byte[] encrypted = pnicc.BCipher_Encrypt_raw(AlgType, opMode, padding, strPlain.getBytes(), key, iv);
        if (encrypted == null || encrypted.length <= 0) {
            System.out.println("BCipher_Encrypt return null or Empty");
            return 1;
        }
        System.out.println("encrypt text : \n" + Hex.encode(encrypted));
        byte[] btArrayDecrypted = pnicc.BCipher_Decrypt_raw(AlgType, opMode, padding, encrypted, key, iv);
        if (btArrayDecrypted == null) {
            System.out.println("BCipher_Decrypt return null");
            return 1;
        }
        String strDecrypted = new String(btArrayDecrypted);
        if (!strPlain.equals(strDecrypted)) {
            System.out.println("\nBCipher_Encrypt/Decrypt (" + szAlgName[AlgType - 1] + ") is ..FAILED !!");
            return 1;
        }
        System.out.println("\nBCipher_Encrypt/Decrypt (" + szAlgName[AlgType - 1] + ")  is ..OK !!");
        return 0;
    }

    public int TEST_PBKDF2_HMAC(byte hashType, String passwd, long iter, int koLen) {
        PniccJNI pnicc = new PniccJNI();
        String[] szHashName = new String[]{"HAS160", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
        System.out.println("\n------------------------------------------");
        System.out.println("PBKDF2-HMAC Test(" + szHashName[hashType - 1] + ") ");
        System.out.println("------------------------------------------");
        byte[] salt = Hex.decode("AC3029C8EFA145CDC2EF95F29BB1D4A3");
        if (salt == null) {
            System.out.println("Generate_HASHDRBG return null");
            return 1;
        }
        byte[] ko = pnicc.PBKDF2_HMAC(hashType, passwd, salt, iter, koLen);
        if (ko == null) {
            System.out.println("PBKDF2_HMAC return null");
            return 1;
        }
        System.out.println("passwd : " + passwd);
        System.out.println("salt : " + Hex.encode(salt));
        System.out.println("iteration : " + iter);
        System.out.println("koLen : " + koLen);
        System.out.println("ko : " + Hex.encode(ko));
        return 0;
    }

    public int TEST_KBKDF_HMAC(byte hashType, byte[] label, byte[] context, int rlen, int koLen) {
        PniccJNI pnicc = new PniccJNI();
        String[] szHashName = new String[]{"HAS160", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
        System.out.println("\n------------------------------------------");
        System.out.println("KBKDF-HMAC Test(" + szHashName[hashType - 1] + ") ");
        System.out.println("------------------------------------------");
        PRNG prng = new PRNG();
        byte[] ki = prng.Generate_HASHDRBG(32);
        if (ki == null) {
            System.out.println("Generate_HASHDRBG return null");
            return 1;
        }
        byte[] ko = pnicc.KBKDF_HMAC(hashType, ki, label, context, rlen, koLen);
        if (ko == null) {
            System.out.println("KBKDF_HMAC return null");
            return 1;
        }
        System.out.println("ki : " + Hex.encode(ki));
        System.out.println("label : " + Hex.encode(label));
        System.out.println("context : " + Hex.encode(context));
        System.out.println("rLen : " + rlen);
        System.out.println("koLen : " + koLen);
        System.out.println("ko : " + Hex.encode(ko));
        return 0;
    }

    public int TEST_EncNDec(byte AlgType) {
        String strPlain = "PniccJNI \ud14c\uc2a4\ud2b8 \ud504\ub85c\uadf8\ub7a8 \ud3c9\ubb38\uc785\ub2c8\ub2e4.";
        byte[] key = new byte[32];
        byte[] iv = new byte[16];
        String[] szAlgName = new String[]{"ARIA128", "ARIA192", "ARIA256", "SEED", "LEA128", "LEA192", "LEA256", "HIGHT"};
        PniccJNI pnicc = new PniccJNI();
        System.out.println("\n-------------------------------------------------");
        System.out.println("Block Cipher Encypt/Decrypt Test - " + szAlgName[AlgType - 1]);
        System.out.println("-------------------------------------------------");
        System.arraycopy(g_btArrayMKey, 0, key, 0, 32);
        System.arraycopy(g_btArrayMKey, 32, iv, 0, 16);
        String strEncrypted = pnicc.BCipher_Encrypt(AlgType, strPlain.getBytes(), key, iv);
        if (strEncrypted == null || strEncrypted.equals("")) {
            System.out.println("BCipher_Encrypt return null or Empty");
            return 1;
        }
        System.out.println("encrypt text : \n" + strEncrypted);
        byte[] btArrayDecrypted = pnicc.BCipher_Decrypt(AlgType, strEncrypted, key, iv);
        if (btArrayDecrypted == null) {
            System.out.println("BCipher_Decrypt return null");
            return 1;
        }
        String strDecrypted = new String(btArrayDecrypted);
        if (!strPlain.equals(strDecrypted)) {
            System.out.println("\nBCipher_Encrypt/Decrypt (" + szAlgName[AlgType - 1] + ") is ..FAILED !!");
            return 1;
        }
        System.out.println("\nBCipher_Encrypt/Decrypt (" + szAlgName[AlgType - 1] + ")  is ..OK !!");
        return 0;
    }

    public int TEST_EncNDec_Mac(byte AlgType, byte hashType) {
        String strPlain = "PniccJNI \ud14c\uc2a4\ud2b8 \ud504\ub85c\uadf8\ub7a8 \ud3c9\ubb38\uc785\ub2c8\ub2e4.";
        byte[] key = new byte[32];
        byte[] iv = new byte[16];
        byte[] mkey = new byte[20];
        String[] szAlgName = new String[]{"ARIA128", "ARIA192", "ARIA256", "SEED", "LEA128", "LEA192", "LEA256", "HIGHT"};
        String[] szHashName = new String[]{"HAS160", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
        PniccJNI pnicc = new PniccJNI();
        System.out.println("\n-------------------------------------------------");
        System.out.println("Block Cipher Encypt/Decrypt (mac) Test - " + szAlgName[AlgType - 1] + ", " + szHashName[hashType - 1]);
        System.out.println("-------------------------------------------------");
        System.arraycopy(g_btArrayMKey, 0, key, 0, 32);
        System.arraycopy(g_btArrayMKey, 32, iv, 0, 16);
        System.arraycopy(g_btArrayMKey, 48, mkey, 0, 20);
        String strEncrypted = pnicc.BCipher_Encrypt_mac(AlgType, hashType, strPlain.getBytes(), key, iv, mkey);
        if (strEncrypted == null || strEncrypted.equals("")) {
            System.out.println("BCipher_Encrypt return null or Empty");
            return 1;
        }
        System.out.println("encrypt text : \n" + strEncrypted);
        byte[] btArrayDecrypted = pnicc.BCipher_Decrypt_mac(AlgType, hashType, strEncrypted, key, iv, mkey);
        if (btArrayDecrypted == null) {
            System.out.println("BCipher_Decrypt return null");
            return 1;
        }
        String strDecrypted = new String(btArrayDecrypted);
        if (!strPlain.equals(strDecrypted)) {
            System.out.println("\nBCipher_Encrypt/Decrypt (" + szAlgName[AlgType - 1] + ") is ..FAILED !!");
            return 1;
        }
        System.out.println("\nBCipher_Encrypt/Decrypt (" + szAlgName[AlgType - 1] + ")  is ..OK !!");
        return 0;
    }

    public int TEST_EncNDec_ccm(byte AlgType, byte option) {
        String strPlain = "PniccJNI \ud14c\uc2a4\ud2b8 \ud504\ub85c\uadf8\ub7a8 \ud3c9\ubb38\uc785\ub2c8\ub2e4.";
        byte[] key = new byte[32];
        byte[] nonce = new byte[13];
        byte[] auth = new byte[16];
        int tagLen = 14;
        String[] szAlgName = new String[]{"ARIA128", "ARIA192", "ARIA256", "SEED", "LEA128", "LEA192", "LEA256", "HIGHT"};
        PniccJNI pnicc = new PniccJNI();
        System.out.println("\n-------------------------------------------------");
        System.out.println("Block Cipher Encypt/Decrypt (CCM) Test - " + szAlgName[AlgType - 1]);
        System.out.println("-------------------------------------------------");
        System.arraycopy(g_btArrayMKey, 0, key, 0, 32);
        System.arraycopy(g_btArrayMKey, 32, nonce, 0, 13);
        System.arraycopy(g_btArrayMKey, 48, auth, 0, 16);
        String strEncrypted = pnicc.BCipher_Encrypt_ccm(AlgType, option, strPlain.getBytes(), key, nonce, auth, tagLen);
        if (strEncrypted == null || strEncrypted.equals("")) {
            System.out.println("BCipher_Encrypt return null or Empty");
            return 1;
        }
        System.out.println("encrypt text : \n" + strEncrypted);
        byte[] btArrayDecrypted = pnicc.BCipher_Decrypt_ccm(AlgType, option, strEncrypted, key, nonce, auth, tagLen);
        if (btArrayDecrypted == null) {
            System.out.println("BCipher_Decrypt return null");
            return 1;
        }
        String strDecrypted = new String(btArrayDecrypted);
        if (!strPlain.equals(strDecrypted)) {
            System.out.println("\nBCipher_Encrypt/Decrypt (" + szAlgName[AlgType - 1] + ") is ..FAILED !!");
            return 1;
        }
        System.out.println("\nBCipher_Encrypt/Decrypt (" + szAlgName[AlgType - 1] + ")  is ..OK !!");
        return 0;
    }

    public int TEST_EncNDec2(byte AlgType) {
        String strPlain = "PniccJNI \ud14c\uc2a4\ud2b8 \ud504\ub85c\uadf8\ub7a8 \ud3c9\ubb38\uc785\ub2c8\ub2e4.";
        byte[] key = new byte[32];
        byte[] iv = new byte[16];
        String[] szAlgName = new String[]{"ARIA128", "ARIA192", "ARIA256", "SEED", "LEA128", "LEA192", "LEA256", "HIGHT"};
        PniccJNI pnicc = new PniccJNI();
        System.out.println("\n-------------------------------------------------");
        System.out.println("Block Cipher Encypt2/Decrypt2 Test - " + szAlgName[AlgType - 1]);
        System.out.println("-------------------------------------------------");
        System.arraycopy(g_btArrayMKey, 0, key, 0, 32);
        System.arraycopy(g_btArrayMKey, 32, iv, 0, 16);
        String strEncrypted = pnicc.BCipher_Encrypt2(AlgType, strPlain.getBytes(), key, iv);
        if (strEncrypted == null || strEncrypted.equals("")) {
            System.out.println("BCipher_Encrypt2 return null or Empty");
            return 1;
        }
        System.out.println("encrypt text : \n" + strEncrypted);
        byte[] btArrayDecrypted = pnicc.BCipher_Decrypt2(AlgType, strEncrypted, key, iv);
        if (btArrayDecrypted == null) {
            System.out.println("BCipher_Decrypt2 return null");
            return 1;
        }
        String strDecrypted = new String(btArrayDecrypted);
        if (!strPlain.equals(strDecrypted)) {
            System.out.println("\nBCipher_Encrypt2/Decrypt2 (" + szAlgName[AlgType - 1] + ") is ..FAILED !!");
            return 1;
        }
        System.out.println("\nBCipher_Encrypt2/Decrypt2 (" + szAlgName[AlgType - 1] + ")  is ..OK !!");
        return 0;
    }

    public int TEST_EncNDec2_Mac(byte AlgType, byte hashType) {
        String strPlain = "PniccJNI \ud14c\uc2a4\ud2b8 \ud504\ub85c\uadf8\ub7a8 \ud3c9\ubb38\uc785\ub2c8\ub2e4.";
        byte[] key = new byte[32];
        byte[] iv = new byte[16];
        byte[] mkey = new byte[20];
        String[] szAlgName = new String[]{"ARIA128", "ARIA192", "ARIA256", "SEED", "LEA128", "LEA192", "LEA256", "HIGHT"};
        String[] szHashName = new String[]{"HAS160", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
        PniccJNI pnicc = new PniccJNI();
        System.out.println("\n-------------------------------------------------");
        System.out.println("Block Cipher Encypt2/Decrypt2 (mac) Test - " + szAlgName[AlgType - 1] + ", " + szHashName[hashType - 1]);
        System.out.println("-------------------------------------------------");
        System.arraycopy(g_btArrayMKey, 0, key, 0, 32);
        System.arraycopy(g_btArrayMKey, 32, iv, 0, 16);
        System.arraycopy(g_btArrayMKey, 48, mkey, 0, 20);
        String strEncrypted = pnicc.BCipher_Encrypt2_mac(AlgType, hashType, strPlain.getBytes(), key, iv, mkey);
        if (strEncrypted == null || strEncrypted.equals("")) {
            System.out.println("BCipher_Encrypt2 return null or Empty");
            return 1;
        }
        System.out.println("encrypt text : \n" + strEncrypted);
        byte[] btArrayDecrypted = pnicc.BCipher_Decrypt2_mac(AlgType, hashType, strEncrypted, key, iv, mkey);
        if (btArrayDecrypted == null) {
            System.out.println("BCipher_Decrypt2 return null");
            return 1;
        }
        String strDecrypted = new String(btArrayDecrypted);
        if (!strPlain.equals(strDecrypted)) {
            System.out.println("\nBCipher_Encrypt2/Decrypt2 (" + szAlgName[AlgType - 1] + ") is ..FAILED !!");
            return 1;
        }
        System.out.println("\nBCipher_Encrypt2/Decrypt2 (" + szAlgName[AlgType - 1] + ")  is ..OK !!");
        return 0;
    }

    public int TEST_HASH(byte hashType) {
        String strPlain = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        String[] szvector = new String[]{"CB5D7EFBCA2F02E0FB7167CABB123AF5795764E5", "761C457BF73B14D27E9E9265C46F4B4DDA11F940", "BFF72B4FCB7D75E5632900AC5F90D219E05E97A7BDE72E740DB393D9", "DB4BFCBD4DA0CD85A60C3C37D3FBD8805C77F15FC6B1FDFE614EE0A7C8FDB4C0", "1761336E3F7CBFE51DEB137F026F89E01A448E3B1FAFA64039C1464EE8732F11A5341A6F41E0C202294736ED64DB1A84", "1E07BE23C26A86EA37EA810C8EC7809352515A970E9253C26F536CFC7A9996C45C8370583E0A78FA4A90041D71A4CEAB7423F19C71B9D5A3E01249F0BEBD5894", "A67C289B8250A6F437A20137985D605589A8C163D45261B15419556E", "A79D6A9DA47F04A3B9A9323EC9991F2105D4C78A7BC7BEEB103855A7A11DFB9F", "D5B972302F5080D0830E0DE7B6B2CF383665A008F4C4F386A61112652C742D20CB45AA51BD4F542FC733E2719E999291", "D1DB17B4745B255E5EB159F66593CC9C143850979FC7A3951796ABA80165AAB536B46174CE19E3F707F0E5C6487F5F03084BC0EC9461691EF20113E42AD28163", "25167D2904386632C417C951F50EE2D270CFC56B4157EE84545406D7", "453AF0509701275A03EDCC0673E41EA076895D1DDA9E32C6506FCEE4FBFCF5EC", "52F55BB610AB59B88DA0D86C6D740055F7774FCC4C45B5A40F2BD2E0", "4655EA512594E5AD3E1988D4953579A6E595C0F53DF915ED57D944EDF3D93441", "46395F8AAFE34345183DB08B6F7716C3E1B73041D2EC17143B972E1E2755C620A8FE4CDB76432A0DCC23599C8F6E931D", "78F8735CF515DA5DBDA306FED585B6442E2C56BB3827B0AAACF1EB0CE9EB4E2B7DC227687F342C57662767DC6315B3303C4EDEF90E12E07E39B965C760BE71ED"};
        String[] szAlgName = new String[]{"HAS160", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512", "LSH256-224", "LSH256-256", "LSH512-224", "LSH512-256", "LSH512-384", "LSH512-512"};
        PniccJNI pnicc = new PniccJNI();
        System.out.println("\n----------------------------------------------");
        System.out.println("HASH(" + szAlgName[hashType - 1] + ") : Message Digest \uc0dd\uc131");
        System.out.println("----------------------------------------------");
        System.out.println("plain text : " + strPlain);
        byte[] btArrayMD = pnicc.GenHASH(hashType, strPlain.getBytes());
        if (btArrayMD == null) {
            System.out.println("GenHASH(" + szAlgName[hashType - 1] + ") return null");
            return 1;
        }
        String strmd = Hex.encode(btArrayMD);
        System.out.println(" hash(hex) : " + strmd);
        if (!strmd.equals(szvector[hashType - 1])) {
            System.out.println("\nGenHASH (" + szAlgName[hashType - 1] + ")  is ..FAILED !!");
            return 1;
        }
        System.out.println("\nGenHASH (" + szAlgName[hashType - 1] + ")  is ..OK !!");
        return 0;
    }

    public int TEST_HMAC(byte hType, int keylen) {
        String[] szAlgName = new String[]{"HAS160", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
        byte[] data = new byte[64];
        byte[] key = new byte[keylen];
        PniccJNI pnicc = new PniccJNI();
        int i = 0;
        while (i < keylen) {
            key[i] = (byte)(170 + i);
            i = (byte)(i + 1);
        }
        i = 0;
        while (i < 64) {
            data[i] = (byte)(221 + i);
            i = (byte)(i + 1);
        }
        System.out.println("\n----------------------------------------------");
        System.out.println("HMAC(" + szAlgName[hType - 1] + ") TEST");
        System.out.println("----------------------------------------------");
        byte[] btArrayMD = pnicc.GenHMAC(hType, data, key);
        if (btArrayMD == null || btArrayMD.length == 0) {
            System.out.println("GenHMAC(" + szAlgName[hType - 1] + ") return null");
            return 1;
        }
        System.out.println("hmac value(" + btArrayMD.length + "byte) : " + Hex.encode(btArrayMD));
        boolean bVerify = pnicc.VerifyHMAC(hType, data, key, btArrayMD);
        if (!bVerify) {
            System.out.println("\nVerifyHMAC(" + szAlgName[hType - 1] + ") .... Failed..!!");
            return 1;
        }
        System.out.println("\nVerifyHMAC(" + szAlgName[hType - 1] + ") .... OK..!!");
        return 0;
    }

    public int TEST_HMAC2(byte hType, int keylen) {
        String[] szAlgName = new String[]{"HAS160", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512"};
        byte[] data = new byte[64];
        byte[] key = new byte[keylen];
        PniccJNI pnicc = new PniccJNI();
        int i = 0;
        while (i < keylen) {
            key[i] = (byte)(170 + i);
            i = (byte)(i + 1);
        }
        i = 0;
        while (i < 64) {
            data[i] = (byte)(221 + i);
            i = (byte)(i + 1);
        }
        System.out.println("\n----------------------------------------------");
        System.out.println("HMAC2(" + szAlgName[hType - 1] + ") TEST");
        System.out.println("----------------------------------------------");
        byte[] btArrayMD = pnicc.GenHMAC2(hType, data, key);
        if (btArrayMD == null || btArrayMD.length == 0) {
            System.out.println("GenHMAC2(" + szAlgName[hType - 1] + ") return null");
            return 1;
        }
        System.out.println("hmac value(" + btArrayMD.length + "byte) : " + Hex.encode(btArrayMD));
        boolean bVerify = pnicc.VerifyHMAC2(hType, data, key, btArrayMD);
        if (!bVerify) {
            System.out.println("\nVerifyHMAC2(" + szAlgName[hType - 1] + ") .... Failed..!!");
            return 1;
        }
        System.out.println("\nVerifyHMAC(" + szAlgName[hType - 1] + ") .... OK..!!");
        return 0;
    }

    public int TEST_CMAC(byte hType, int keylen) {
        String[] szAlgName = new String[]{"ARIA128", "ARIA192", "ARIA256", "SEED", "LEA128", "LEA192", "LEA256", "HIGHT"};
        byte[] data = new byte[64];
        byte[] key = new byte[keylen];
        PniccJNI pnicc = new PniccJNI();
        int i = 0;
        while (i < keylen) {
            key[i] = (byte)(170 + i);
            i = (byte)(i + 1);
        }
        i = 0;
        while (i < 64) {
            data[i] = (byte)(221 + i);
            i = (byte)(i + 1);
        }
        System.out.println("\n----------------------------------------------");
        System.out.println("CMAC(" + szAlgName[hType - 1] + ") TEST");
        System.out.println("----------------------------------------------");
        byte[] btArrayMac = pnicc.GenCMAC(hType, data, key);
        if (btArrayMac == null || btArrayMac.length == 0) {
            System.out.println("GenCMAC(" + szAlgName[hType - 1] + ") return null");
            return 1;
        }
        System.out.println("cmac value(" + btArrayMac.length + "byte) : " + Hex.encode(btArrayMac));
        boolean bVerify = pnicc.VerifyCMAC(hType, data, key, btArrayMac);
        if (!bVerify) {
            System.out.println("\nVerifyCMAC(" + szAlgName[hType - 1] + ") .... Failed..!!");
            return 1;
        }
        System.out.println("\nVerifyCMAC(" + szAlgName[hType - 1] + ") .... OK..!!");
        return 0;
    }

    public int TEST_PRNG(int nType, int nLen) {
        String[] szAlgName = new String[]{"DSAPRNGSHA1", "KCDSAPRNGSHA1", "HASH_DRBG"};
        System.out.println("\n----------------------------------------------");
        System.out.println("PRNG(" + szAlgName[nType] + ") TEST");
        System.out.println("----------------------------------------------");
        PRNG prng = new PRNG();
        byte[] btRand = null;
        if (nType == 0) {
            System.out.println("PRNG(" + szAlgName[nType] + ") is not Support ");
            return 1;
        }
        if (nType == 1) {
            System.out.println("PRNG(" + szAlgName[nType] + ") is not Support ");
            return 1;
        }
        if (nType == 2) {
            btRand = prng.Generate_HASHDRBG(nLen);
        }
        if (btRand == null || btRand.length != nLen) {
            System.out.println("PRNG(" + szAlgName[nType] + ") return null");
            return 1;
        }
        System.out.println("PRNG value(" + btRand.length + "byte) : " + Hex.encode(btRand));
        return 0;
    }

    public int TEST_ECC_GenKeyPair(int ecType) {
        String[] szAlgName = new String[]{"P-224", "P-256"};
        System.out.println("\n----------------------------------------------");
        System.out.println("ECC Keypair Generate(" + szAlgName[ecType - 1] + ") TEST");
        System.out.println("----------------------------------------------");
        ECC ecc = new ECC(ecType, true);
        String strPrikey = ecc.get_Prikey();
        String strPubkey = ecc.get_Pubkey();
        if (strPrikey == null || strPrikey.length() != 56 && strPrikey.length() != 64) {
            System.out.println("ECC PrivateKey Error ..!! ");
            return 1;
        }
        System.out.println("ECC PrivateKey : " + strPrikey.length() + " byte ");
        System.out.println("ECC PrivateKey : " + strPrikey);
        if (strPubkey == null || strPubkey.length() <= 0) {
            System.out.println("ECC PublicKey Error ..!!");
            return 1;
        }
        System.out.println("ECC PublicKey : " + strPubkey.length() + " byte ");
        System.out.println("ECC PublicKey : " + strPubkey);
        if (!ecc.CheckKeyPair(strPrikey, strPubkey)) {
            System.out.println("ECC CheckKeyPair Error ..!!");
            return 1;
        }
        System.out.println("ECC CheckKeyPair Success ..!!");
        if (ecType == 1) {
            this.ecPrikey_p224 = strPrikey;
            this.ecPubkey_p224 = strPubkey;
        } else if (ecType == 2) {
            this.ecPrikey_p256 = strPrikey;
            this.ecPubkey_p256 = strPubkey;
        }
        return 0;
    }

    public int TEST_ECDSA(int ecType) {
        String[] szAlgName = new String[]{"P-224", "P-256"};
        int mLen = 86;
        PRNG prng = new PRNG();
        byte[] message = prng.Generate_HASHDRBG(mLen);
        System.out.println("\n----------------------------------------------");
        System.out.println("ECDSA(" + szAlgName[ecType - 1] + ") TEST");
        System.out.println("----------------------------------------------");
        String strPrikey = null;
        String strPubkey = null;
        ECC ecc = new ECC(ecType);
        if (ecType == 1) {
            strPrikey = this.ecPrikey_p224;
            strPubkey = this.ecPubkey_p224;
        } else if (ecType == 2) {
            strPrikey = this.ecPrikey_p256;
            strPubkey = this.ecPubkey_p256;
        }
        String sign = ecc.ECDSA_Sign(message, strPrikey);
        if (sign == null || sign.length() <= 0) {
            System.out.println("ECDSA Sign Error ..!!");
            return 1;
        }
        System.out.println("ECDSA Sign(" + sign.length() + "byte) : " + sign);
        boolean bRet = ecc.ECDSA_Verify(message, strPubkey, sign);
        if (!bRet) {
            System.out.println("ECDSA Verify Error ..!!");
            return 1;
        }
        System.out.println("ECDSA(" + szAlgName[ecType - 1] + ") .. OK..!!");
        return 0;
    }

    public int TEST_ECDH(int ecType) {
        String[] szAlgName = new String[]{"P-224", "P-256"};
        System.out.println("\n----------------------------------------------");
        System.out.println("ECDH(" + szAlgName[ecType - 1] + ") TEST");
        System.out.println("----------------------------------------------");
        String strPrikey = null;
        String strPubkey = null;
        ECC eccA = new ECC(ecType);
        if (ecType == 1) {
            strPrikey = this.ecPrikey_p224;
            strPubkey = this.ecPubkey_p224;
        } else if (ecType == 2) {
            strPrikey = this.ecPrikey_p256;
            strPubkey = this.ecPubkey_p256;
        }
        ECC eccB = new ECC(ecType, true);
        String strPrikey_B = eccB.get_Prikey();
        String strPubkey_B = eccB.get_Pubkey();
        byte[] KABa = eccA.ECDH_CalculateKey(strPrikey, strPubkey_B);
        if (KABa == null || KABa.length <= 0) {
            System.out.println("ECDH A'KAB shared key Error ..!!");
            System.out.println("ECDH B'Prikey : " + strPrikey_B);
            System.out.println("ECDH B'Pubkey : " + strPubkey_B);
            return 1;
        }
        System.out.println("ECDH A'KAB shared key (" + KABa.length + "byte) : " + Hex.encode(KABa));
        byte[] KABb = eccA.ECDH_CalculateKey(strPrikey_B, strPubkey);
        if (KABb != null && KABb.length > 0) {
            if (!Arrays.equals(KABa, KABb)) {
                System.out.println("ECDH A'KAB and B'KAB is different ..!!");
                System.out.println("ECDH B'KAB shared key (" + KABb.length + "byte) : " + Hex.encode(KABb));
                return 1;
            }
        } else {
            System.out.println("ECDH B'KAB shared key Error ..!!");
            return 1;
        }
        System.out.println("ECDH(" + szAlgName[ecType - 1] + ") .. OK..!!");
        return 0;
    }

    public int TEST_RSA_GenKeyPair(int modSize) {
        System.out.println("\n----------------------------------------------");
        System.out.println("RSA Keypair Generate(" + modSize + ") TEST");
        System.out.println("----------------------------------------------");
        RSA rsa = new RSA(modSize);
        String strPrikey = rsa.get_Prikey();
        String strPubkey = rsa.get_Pubkey();
        if (strPrikey == null || strPrikey.length() <= 0) {
            System.out.println("RSA PrivateKey Error ..!!");
            return 1;
        }
        System.out.println("RSA PrivateKey : " + strPrikey.length() + " byte ");
        System.out.println("RSA PrivateKey : " + strPrikey);
        if (strPubkey == null || strPubkey.length() <= 0) {
            System.out.println("RSA PublicKey Error ..!!");
            return 1;
        }
        System.out.println("RSA PublicKey : " + strPubkey.length() + " byte ");
        System.out.println("RSA Pubkey : " + strPubkey);
        if (!rsa.CheckKeyPair(strPrikey, strPubkey)) {
            System.out.println("RSA CheckKeyPair Error ..!!");
            return 1;
        }
        System.out.println("RSA CheckKeyPair Success ..!!");
        if (modSize == 1024) {
            System.out.println("RSA modeSize 1024 is not supported !!");
            return 1;
        }
        if (modSize == 2048) {
            this.rsaPriKey2048 = strPrikey;
            this.rsaPubKey2048 = strPubkey;
        }
        return 0;
    }

    public int TEST_RSAES_OAEP(int modSize) {
        int mLen = 86;
        byte[] message = new byte[mLen];
        int i = 0;
        while (i < mLen) {
            message[i] = (byte)(30 + (byte)i);
            ++i;
        }
        System.out.println("\n----------------------------------------------");
        System.out.println("RSAES_OAEP(" + modSize + ") TEST");
        System.out.println("----------------------------------------------");
        String strPrikey = null;
        String strPubkey = null;
        RSA rsa = new RSA();
        if (modSize == 1024) {
            System.out.println("RSA modeSize 1024 is not supported !!");
            return 1;
        }
        if (modSize == 2048) {
            strPrikey = this.rsaPriKey2048;
            strPubkey = this.rsaPubKey2048;
        }
        System.out.println("PlainTest(" + message.length + "byte) : " + Hex.encode(message));
        byte[] encrypt = rsa.OAEP_Encrypt(message, strPubkey);
        if (encrypt == null || encrypt.length <= 0) {
            System.out.println("RSA OAEP_Encrypt Error ..!!");
            return 1;
        }
        System.out.println("Encrypted(" + encrypt.length + "byte) : " + Hex.encode(encrypt));
        byte[] decrypt = rsa.OAEP_Decrypt(encrypt, strPrikey);
        if (decrypt == null || decrypt.length <= 0) {
            System.out.println("RSA OAEP_Decrypt Error ..!!");
            return 1;
        }
        System.out.println("Decrypted(" + decrypt.length + "byte) : " + Hex.encode(decrypt));
        boolean isSame = true;
        if (message.length == decrypt.length) {
            i = 0;
            while (i < message.length) {
                if (message[i] != decrypt[i]) {
                    isSame = false;
                }
                ++i;
            }
        } else {
            isSame = false;
        }
        if (!isSame) {
            System.out.println("RSAES_OAEP Error ..!!");
            return 1;
        }
        System.out.println("RSAES_OAEP(" + modSize + ") .. OK..!!");
        return 0;
    }

    public int TEST_RSA_SSA(int modSize) {
        String sign;
        int mLen = 86;
        byte[] message = new byte[mLen];
        int i = 0;
        while (i < mLen) {
            message[i] = (byte)(30 + (byte)i);
            ++i;
        }
        System.out.println("\n----------------------------------------------");
        System.out.println("RSA_SSA_PSS(" + modSize + ") TEST");
        System.out.println("----------------------------------------------");
        String strPrikey = null;
        String strPubkey = null;
        RSA rsa = new RSA();
        if (modSize == 1024) {
            System.out.println("RSA modeSize 1024 is not supported !!");
            return 1;
        }
        if (modSize == 2048) {
            strPrikey = this.rsaPriKey2048;
            strPubkey = this.rsaPubKey2048;
        }
        if ((sign = rsa.SSA_Sign(message, strPrikey)) == null || sign.length() <= 0) {
            System.out.println("RSA SSA Sign Error ..!!");
            return 1;
        }
        System.out.println("RSA SSA Sign(" + sign.length() + "byte) : " + sign);
        boolean bRet = rsa.SSA_Verify(message, strPubkey, sign);
        if (!bRet) {
            System.out.println("RSA_SSA Verify Error ..!!");
            return 1;
        }
        System.out.println("RSA_SSA(" + modSize + ") .. OK..!!");
        return 0;
    }

    public static void main(String[] args) {
        PniccJNI pnicc = new PniccJNI();
        int nRet = 0;
        int nResult = 0;
        String strVer = pnicc.GetVersion();
        String strCMVPVer = pnicc.GetCMVPVersion();
        System.out.println("=================================================================");
        System.out.println("\tPniccJNI Version " + strVer);
        System.out.println("\t" + strCMVPVer);
        System.out.println("=================================================================");
        nRet = pnicc.InitializeAPI();
        if (nRet != 1) {
            System.out.println("PniccJNI InitializeAPI Failed - " + nRet);
            return;
        }
        System.out.println("PniccJNI InitializeAPI SUCCESS\n");
        PniccJNITest test = new PniccJNITest();
        nResult += test.TEST_GenPBKDF2MasterKey("asdf1234", (byte)1);
        nResult += test.TEST_PBKDF2_HMAC((byte)4, "asdf12345", 1024L, 80);
        nResult += test.TEST_KBKDF_HMAC((byte)4, "Pass-Ni Crypto V2.0".getBytes(), "KBKDF-HMAC".getBytes(), 32, 80);
        nResult += test.TEST_EncNDec((byte)1);
        nResult += test.TEST_EncNDec((byte)4);
        nResult += test.TEST_EncNDec2((byte)3);
        nResult += test.TEST_EncNDec2((byte)4);
        nResult += test.TEST_EncNDec_ccm((byte)3, (byte)0);
        nResult += test.TEST_EncNDec_ccm((byte)7, (byte)1);
        nResult += test.TEST_EncNDec_raw((byte)4, (byte)2, (byte)2);
        nResult += test.TEST_EncNDec_raw((byte)1, (byte)2, (byte)1);
        nResult += test.TEST_EncNDec_raw((byte)2, (byte)2, (byte)2);
        nResult += test.TEST_EncNDec_raw((byte)3, (byte)3, (byte)0);
        nResult += test.TEST_EncNDec_raw((byte)5, (byte)2, (byte)1);
        nResult += test.TEST_EncNDec_raw((byte)6, (byte)2, (byte)2);
        nResult += test.TEST_EncNDec_raw((byte)7, (byte)3, (byte)0);
        nResult += test.TEST_HASH((byte)3);
        nResult += test.TEST_HASH((byte)4);
        nResult += test.TEST_HASH((byte)5);
        nResult += test.TEST_HASH((byte)6);
        nResult += test.TEST_HASH((byte)8);
        nResult += test.TEST_HASH((byte)12);
        nResult += test.TEST_HMAC((byte)4, 20);
        nResult += test.TEST_HMAC2((byte)3, 28);
        nResult += test.TEST_HMAC2((byte)4, 32);
        nResult += test.TEST_HMAC2((byte)5, 48);
        nResult += test.TEST_HMAC2((byte)6, 64);
        nResult += test.TEST_CMAC((byte)1, 16);
        nResult += test.TEST_CMAC((byte)2, 24);
        nResult += test.TEST_CMAC((byte)3, 32);
        nResult += test.TEST_CMAC((byte)4, 16);
        nResult += test.TEST_CMAC((byte)5, 16);
        nResult += test.TEST_CMAC((byte)6, 24);
        nResult += test.TEST_CMAC((byte)7, 32);
        nResult += test.TEST_PRNG(2, 40);
        nResult += test.TEST_RSAES_OAEP(2048);
        nResult += test.TEST_RSA_SSA(2048);
        nResult += test.TEST_ECC_GenKeyPair(1);
        nResult += test.TEST_ECC_GenKeyPair(2);
        nResult += test.TEST_ECDSA(1);
        nResult += test.TEST_ECDSA(2);
        nResult += test.TEST_ECDH(1);
        System.out.println("\n===============================================================");
        System.out.println("\tPniccJNI TEST END");
        if ((nResult += test.TEST_ECDH(2)) == 0) {
            System.out.println("\tAll TEST Success");
        } else {
            System.out.println("\t" + nResult + "'s TEST Error ");
        }
        System.out.println("===============================================================");
        pnicc.FinalizeAPI();
    }

    public int SelfTest() {
        PniccJNI pnicc = new PniccJNI();
        int nRet = 0;
        System.out.println("---------------------------------------------------------------");
        System.out.println("SELF Test");
        System.out.println("---------------------------------------------------------------");
        nRet = pnicc.SELFTEST_DoPowerUpSelfTest();
        if (nRet != 1) {
            System.out.println("SELFTEST_DoPowerUpSelfTest FAILED");
            return 1;
        }
        System.out.println("SELFTEST_DoPowerUpSelfTest SUCCESS");
        nRet = pnicc.SELFTEST_VerifyAlogorithm();
        if (nRet != 1) {
            System.out.println("SELFTEST_VerifyAlogorithm FAILED");
            return 1;
        }
        System.out.println("SELFTEST_VerifyAlogorithm SUCCESS");
        return 0;
    }
}

