/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTime;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.util.TbDTFormat;
import com.tmax.tibero.jdbc.util.TbDTFormatElement;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;

public class TbDTFormatter {
    private TbDTFormatter() {
    }

    public static String format(TbDTFormat tbDTFormat, TbDate tbDate, int n) {
        if (tbDate == null) {
            return null;
        }
        if (tbDTFormat == null || tbDTFormat.getElements() == null) {
            return tbDate.toString();
        }
        return TbDTFormatter.formatInternal(tbDTFormat, tbDate.getYear(), tbDate.getMonth(), tbDate.getDayOfMonth(), tbDate.getHourOfDay(), tbDate.getMinutes(), tbDate.getSeconds(), 0, 0);
    }

    public static String format(TbDTFormat tbDTFormat, TbTimestamp tbTimestamp, int n) {
        if (tbTimestamp == null) {
            return null;
        }
        if (tbDTFormat == null || tbDTFormat.getElements() == null) {
            return tbTimestamp.toString();
        }
        return TbDTFormatter.formatInternal(tbDTFormat, tbTimestamp.getYear(), tbTimestamp.getMonth(), tbTimestamp.getDayOfMonth(), tbTimestamp.getHourOfDay(), tbTimestamp.getMinutes(), tbTimestamp.getSeconds(), tbTimestamp.getNanos(), n);
    }

    public static String format(TbDTFormat tbDTFormat, TbTime tbTime, int n) {
        if (tbTime == null) {
            return null;
        }
        if (tbDTFormat == null || tbDTFormat.getElements() == null) {
            return tbTime.toString();
        }
        return TbDTFormatter.formatInternal(tbDTFormat, 0, 0, 0, tbTime.getHourOfDay(), tbTime.getMinutes(), tbTime.getSeconds(), tbTime.getNanos(), n);
    }

    public static String format(TbDTFormat tbDTFormat, Date date) {
        if (date == null) {
            return null;
        }
        if (tbDTFormat == null || tbDTFormat.getElements() == null) {
            return date.toString();
        }
        return null;
    }

    public static String format(TbDTFormat tbDTFormat, Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        if (tbDTFormat == null || tbDTFormat.getElements() == null) {
            return timestamp.toString();
        }
        return null;
    }

    private static String formatInternal(TbDTFormat tbDTFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Iterator<TbDTFormatElement> iterator = tbDTFormat.getElements().iterator();
        StringBuilder stringBuilder = new StringBuilder(tbDTFormat.getElements().size() * 3);
        boolean bl = !tbDTFormat.getTrimEnabled();
        Calendar calendar = null;
        Locale locale = Locale.getDefault();
        if (tbDTFormat.hasField(0) || tbDTFormat.hasField(7) || tbDTFormat.isFieldWithAdditionalOption(4) || tbDTFormat.isFieldWithAdditionalOption(6)) {
            calendar = Calendar.getInstance(new Locale("GMT+0"));
            calendar.clear();
            calendar.set(n, n2 - 1, n3, n4, n5, n6);
            calendar.getTime();
        }
        block24: while (iterator.hasNext()) {
            TbDTFormatElement tbDTFormatElement = iterator.next();
            switch (tbDTFormatElement.getType()) {
                case 24: {
                    stringBuilder.append(calendar.getDisplayName(0, 2, locale));
                    continue block24;
                }
                case 25: {
                    int n9 = Math.abs(n) / 100;
                    if (n9 % 100 > 0) {
                        ++n9;
                    }
                    stringBuilder.append(n9);
                    continue block24;
                }
                case 46: {
                    int n10 = Math.abs(n) / 100;
                    if (n10 % 100 > 0) {
                        n10 = n10 > 0 ? ++n10 : --n10;
                    }
                    stringBuilder.append(n10);
                    continue block24;
                }
                case 42: 
                case 55: 
                case 56: 
                case 57: {
                    TbDTFormatter.appendNumber(stringBuilder, n, tbDTFormatElement.getEtcValue(), bl, false);
                    continue block24;
                }
                case 47: 
                case 48: {
                    TbDTFormatter.appendNumber(stringBuilder, n, 4, bl, true);
                    continue block24;
                }
                case 41: {
                    stringBuilder.append((n2 + 2) / 3);
                    continue block24;
                }
                case 38: 
                case 39: {
                    TbDTFormatter.appendNumber(stringBuilder, n2, 2, bl, false);
                    continue block24;
                }
                case 40: {
                    stringBuilder.append(calendar.getDisplayName(2, 2, locale));
                    continue block24;
                }
                case 37: {
                    stringBuilder.append(calendar.getDisplayName(2, 1, locale));
                    continue block24;
                }
                case 26: {
                    TbDTFormatter.appendNumber(stringBuilder, n3, 2, bl, false);
                    continue block24;
                }
                case 27: {
                    stringBuilder.append(calendar.get(6));
                    continue block24;
                }
                case 29: {
                    stringBuilder.append(calendar.get(7));
                    continue block24;
                }
                case 30: {
                    stringBuilder.append(calendar.getDisplayName(7, 2, locale));
                    continue block24;
                }
                case 28: {
                    stringBuilder.append(calendar.getDisplayName(2, 1, locale));
                    continue block24;
                }
                case 23: {
                    stringBuilder.append(calendar.getDisplayName(9, 2, locale));
                    continue block24;
                }
                case 34: {
                    TbDTFormatter.appendNumber(stringBuilder, n4 > 12 ? n4 - 12 : n4, 2, bl, false);
                    continue block24;
                }
                case 35: {
                    TbDTFormatter.appendNumber(stringBuilder, n4, 2, bl, false);
                    continue block24;
                }
                case 36: {
                    TbDTFormatter.appendNumber(stringBuilder, n5, 2, bl, false);
                    continue block24;
                }
                case 45: {
                    TbDTFormatter.appendNumber(stringBuilder, n6, 2, bl, false);
                    continue block24;
                }
                case 44: {
                    TbDTFormatter.appendNumber(stringBuilder, n4 * 3600 + n5 * 60 + n6, 5, bl, false);
                    continue block24;
                }
                case 33: {
                    TbDTFormatter.appendNumber(stringBuilder, n7, 9, true, false);
                    int n11 = tbDTFormatElement.getEtcValue();
                    if (n11 == 0) {
                        n11 = n8;
                    }
                    stringBuilder.setLength(stringBuilder.length() - (9 - n11));
                    continue block24;
                }
                case 43: {
                    stringBuilder.append(new DecimalFormatSymbols(locale).getDecimalSeparator());
                    continue block24;
                }
            }
            stringBuilder.append(tbDTFormatElement.getText());
        }
        return stringBuilder.toString();
    }

    private static void appendNumber(StringBuilder stringBuilder, int n, int n2, boolean bl, boolean bl2) {
        if (n < 0 && bl2) {
            stringBuilder.append(n);
        } else {
            String string = Integer.toString(Math.abs(n));
            int n3 = string.length();
            char[] cArray = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
            if (n2 > n3) {
                stringBuilder.insert(stringBuilder.length(), cArray, 0, n2 - n3);
            }
            if (n2 < n3) {
                stringBuilder.append(string.substring(n3 - n2));
            } else {
                stringBuilder.append(string);
            }
        }
    }
}

