/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbBindParamDesc;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class TbParameterMetaData
implements ParameterMetaData {
    private int paramCnt = 0;
    private TbBindParamDesc[] paramMeta = null;
    private boolean mapDateToTimestamp = false;

    TbParameterMetaData(int n, TbBindParamDesc[] tbBindParamDescArray, boolean bl) {
        this.paramCnt = n;
        this.paramMeta = tbBindParamDescArray;
        this.mapDateToTimestamp = bl;
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        this.checkParameterIndex(n);
        return DataType.getDataTypeClassName(this.getParamDataType(n));
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.paramCnt;
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.checkParameterIndex(n);
        int n2 = this.getParamDataType(n);
        int n3 = this.getParamPrecision(n);
        int n4 = n2 == 16 ? -1 : DataType.getSqlType(n2, n3, this.mapDateToTimestamp);
        return n4;
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.checkParameterIndex(n);
        int n2 = this.getParamDataType(n);
        return DataType.getDBTypeName(n2, this.getParamPrecision(n));
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkParameterIndex(n);
        int n2 = this.getParamPrecision(n);
        int n3 = this.getParamDataType(n);
        switch (n3) {
            case 2: 
            case 3: {
                return this.getParamMaxLength(n);
            }
            case 12: 
            case 13: {
                return -1;
            }
            case 10: 
            case 11: {
                return Integer.MAX_VALUE;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        return n2 < 0 ? 0 : n2;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkParameterIndex(n);
        int n2 = 0;
        int n3 = this.getParamDataType(n);
        switch (n3) {
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        n2 = this.getParamScale(n);
        return n2 < 0 ? 0 : n2;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    private void checkParameterIndex(int n) throws SQLException {
        if (this.paramMeta == null) {
            throw TbError.newSQLException(-90201);
        }
        if (n <= 0 || n > this.paramCnt) {
            throw TbError.newSQLException(-90609, "(0 <= index[" + n + "] < paramCount[" + this.paramCnt + "])");
        }
    }

    private int getParamDataType(int n) throws SQLException {
        this.checkParameterIndex(n);
        return this.paramMeta[n - 1].type;
    }

    private int getParamPrecision(int n) throws SQLException {
        this.checkParameterIndex(n);
        String string = this.paramMeta[n - 1].placeHolderName;
        String[] stringArray = string.split("@");
        return Integer.parseInt(stringArray[0]);
    }

    private int getParamScale(int n) throws SQLException {
        this.checkParameterIndex(n);
        String string = this.paramMeta[n - 1].placeHolderName;
        String[] stringArray = string.split("@");
        return Integer.parseInt(stringArray[1]);
    }

    private int getParamMaxLength(int n) throws SQLException {
        this.checkParameterIndex(n);
        String string = this.paramMeta[n - 1].placeHolderName;
        String[] stringArray = string.split("@");
        return Integer.parseInt(stringArray[2]);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }
}

