/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import java.sql.SQLException;

public class MS1252CharToByteConverter {
    private static final short[] UNICODE_TO_MS1252_IDX_PAGE1 = new short[]{0, 0, 140, 156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 154, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 0, 0, 0, 0, 142, 158, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 0, 0, 0, 0, 0};
    private static final char[] UNICODE_TO_MS1252_IDX_PAGE2 = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0088', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0098', '\u0000', '\u0000', '\u0000'};
    private static final char[] UNICODE_TO_MS1252_IDX_PAGE20 = new char[]{'\u0000', '\u0000', '\u0000', '\u0096', '\u0097', '\u0000', '\u0000', '\u0000', '\u0091', '\u0092', '\u0082', '\u0000', '\u0093', '\u0094', '\u0084', '\u0000', '\u0086', '\u0087', '\u0095', '\u0000', '\u0000', '\u0000', '\u0085', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0089', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u008b', '\u009b', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public boolean canConvert(char c) {
        return c < '\u0080' || c >= '\u00c0' && c < '\u00ff' || c >= '\u0100' && c < '\u01bf' || c >= '\u1ea0' && c < '\u1eff';
    }

    protected int convSingleByte(char c, byte[] byArray) {
        if (c < '\u0080') {
            byArray[0] = (byte)(c & 0x7F);
            return 1;
        }
        return 0;
    }

    public int convCharArr(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5 = n3;
        for (int i = n; i < n2 && n5 < n4; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                byArray[n5++] = (byte)c;
                continue;
            }
            int n6 = c >= '\u00a0' && c < '\u0100' ? (int)c : ((short)c >= 336 && c < '\u0198' ? (int)((char)UNICODE_TO_MS1252_IDX_PAGE1[c - 336]) : (c >= '\u02c0' && c < '\u02e0' ? UNICODE_TO_MS1252_IDX_PAGE2[c - 704] : (c >= '\u2010' && c < '\u2040' ? UNICODE_TO_MS1252_IDX_PAGE20[c - 8208] : (c == '\u20ac' ? 128 : (c == '\u2122' ? 153 : 63)))));
            if (n6 == 0) {
                n6 = 63;
            }
            byArray[n5++] = (byte)n6;
        }
        return n5 - n3;
    }

    public int convString(String string, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.convCharArr(string.toCharArray(), n, n2, byArray, n3, n4);
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

