/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.data.charset.UTF8Encoder;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbStreamDataWriter {
    private static final int DPL_EXTRA_SIZE = 65536;
    protected StreamBuffer buf;
    private DataTypeConverter converter;

    public TbStreamDataWriter(StreamBuffer streamBuffer) {
        this(streamBuffer, null);
    }

    public TbStreamDataWriter(StreamBuffer streamBuffer, DataTypeConverter dataTypeConverter) {
        this.initialize(streamBuffer);
        this.converter = dataTypeConverter;
    }

    public void clearDPLBuffer() {
        this.buf.setCurDataSize(24);
    }

    public int getBufferedDataSize() {
        return this.buf != null ? this.buf.getCurDataSize() : 0;
    }

    public int getRemainedBufferSize() {
        int n = this.buf.getRemained() - 65536;
        return n < 0 ? 0 : n;
    }

    public StreamBuffer getStreamBuf() {
        return this.buf;
    }

    public void initialize(StreamBuffer streamBuffer) {
        streamBuffer.init();
        this.buf = streamBuffer;
    }

    public void makeBufferAvailable(int n) {
        this.buf.makeBufferAvailable(n);
    }

    public void moveOffset(int n) {
        this.buf.moveOffset(n);
    }

    public int putPadding(int n) {
        this.buf.putData(n, (byte)0);
        return n;
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            this.buf = null;
        }
        this.converter = null;
    }

    public int reWriteInt(int n, int n2, int n3) throws SQLException {
        TbCommon.int2Bytes(n2, this.buf.getRawBytes(), n, n3);
        return n3;
    }

    public int reWriteLong(int n, long l, int n2) throws SQLException {
        TbCommon.long2Bytes(l, this.buf.getRawBytes(), n, n2);
        return n2;
    }

    public void setCurDataSize(int n) {
        this.buf.setCurDataSize(n);
    }

    public void writeByte(byte by) {
        this.buf.copySingleByte(by);
    }

    public int writeBytes(byte[] byArray) throws SQLException {
        return this.writeBytes(byArray, 0, byArray.length);
    }

    public int writeBytes(byte[] byArray, int n, int n2) {
        this.buf.copyMultiBytes(n2, n, byArray);
        return n2;
    }

    public int writeInt(int n, int n2) throws SQLException {
        this.buf.makeBufferAvailable(n2);
        TbCommon.int2Bytes(n, this.buf.getRawBytes(), this.buf.getCurDataSize(), n2);
        this.buf.moveOffset(n2);
        return n2;
    }

    public int writeLenAndDBEncodedPadString(String string) throws SQLException {
        byte[] byArray = this.converter.getDBEncodedBytes(string);
        int n = byArray.length;
        this.writeInt(n, 4);
        this.buf.copyMultiBytes(n, 0, byArray);
        return n + this.writePadding(n) + 4;
    }

    public int writeLenAndSqlWithNPrefixed(String string) throws SQLException {
        int n = this.buf.getCurDataSize();
        int n2 = 0;
        this.buf.moveOffset(4);
        UTF8Encoder uTF8Encoder = new UTF8Encoder();
        int n3 = string.length();
        int n4 = -1;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            if (string.charAt(i) != '\'') continue;
            if (n4 == -1) {
                n4 = i;
                continue;
            }
            if (i + 1 < n3 && string.charAt(i + 1) == '\'') {
                ++i;
                continue;
            }
            if (string.charAt(n4 - 1) == 'N' || string.charAt(n4 - 1) == 'n') {
                n2 += this.writeBytes(this.converter.getDBEncodedBytes(string.substring(n5, n4 + 1)));
                n2 += this.writeBytes(uTF8Encoder.stringToBytes(string.substring(n4 + 1, i)));
                n5 = i;
            }
            n4 = -1;
        }
        this.reWriteInt(n, n2 += this.writeBytes(this.converter.getDBEncodedBytes(string.substring(n5, n3))), 4);
        return n2 + this.writePadding(n2) + 4;
    }

    public int writeLong(long l, int n) throws SQLException {
        this.buf.makeBufferAvailable(n);
        TbCommon.long2Bytes(l, this.buf.getRawBytes(), this.buf.getCurDataSize(), n);
        this.buf.moveOffset(n);
        return n;
    }

    public int writePadBytes(byte[] byArray, int n, int n2) {
        this.writeBytes(byArray, n, n2);
        return n2 + this.writePadding(n2);
    }

    public int writePadding(int n) {
        int n2 = TbCommon.getPadLength(n);
        this.putPadding(n2);
        return n2;
    }

    public int writePaddingDPL(int n) {
        int n2 = (4 - n % 4) % 4;
        this.putPadding(n2);
        return n2;
    }

    public int writeRpcolData(byte[] byArray, int n) {
        int n2;
        if (n <= 250) {
            this.writeByte((byte)n);
            n2 = 1;
        } else {
            this.writeByte((byte)-2);
            this.writeByte((byte)(0xFF & n >> 8));
            this.writeByte((byte)(0xFF & n));
            n2 = 3;
        }
        if (n > 0) {
            this.writeBytes(byArray, 0, n);
            return n2 + n + this.writePadding(n2 + n);
        }
        this.writeByte((byte)0);
        return n2 + 1 + this.writePadding(n2 + 1);
    }

    public int writeRpcolData(byte[] byArray, int n, boolean bl) {
        int n2;
        if (n <= 250) {
            this.writeByte((byte)n);
            n2 = 1;
        } else {
            this.writeByte((byte)-2);
            this.writeByte((byte)(0xFF & n >> 8));
            this.writeByte((byte)(0xFF & n));
            n2 = 3;
        }
        if (bl) {
            if (n > 0) {
                this.writeBytes(byArray, 0, n);
                return n2 + n + this.writePadding(n2 + n);
            }
            this.writeByte((byte)0);
            return n2 + 1 + this.writePadding(n2 + 1);
        }
        if (n > 0) {
            this.writeBytes(byArray, 0, n);
            return n2 + n;
        }
        this.writeByte((byte)0);
        return n2 + 1;
    }
}

