/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class TbSQLOutput
implements SQLOutput {
    private TbStructDescriptor descriptor;
    private Object[] attributes;
    private int index;
    private TbConnection conn;

    public TbSQLOutput(TbStructDescriptor tbStructDescriptor, TbConnection tbConnection) {
        this.descriptor = tbStructDescriptor;
        this.attributes = new Object[tbStructDescriptor.getNumOfFields()];
        this.conn = tbConnection;
        this.index = 0;
    }

    public TbStruct getStruct() throws SQLException {
        return new TbStruct(this.descriptor, this.conn, this.attributes);
    }

    @Override
    public void writeString(String string) throws SQLException {
        this.attributes[this.index++] = string;
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        this.attributes[this.index++] = new Boolean(bl);
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.attributes[this.index++] = new Integer(by);
    }

    @Override
    public void writeShort(short s) throws SQLException {
        this.attributes[this.index++] = new Integer(s);
    }

    @Override
    public void writeInt(int n) throws SQLException {
        this.attributes[this.index++] = new Integer(n);
    }

    @Override
    public void writeLong(long l) throws SQLException {
        this.attributes[this.index++] = new Long(l);
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        this.attributes[this.index++] = new Float(f);
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.attributes[this.index++] = new Double(d);
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.attributes[this.index++] = bigDecimal;
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        this.attributes[this.index++] = byArray;
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.attributes[this.index++] = date;
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.attributes[this.index++] = time;
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.attributes[this.index++] = timestamp;
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        this.attributes[this.index++] = reader;
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        this.attributes[this.index++] = inputStream;
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        this.attributes[this.index++] = inputStream;
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        TbStruct tbStruct = null;
        if (sQLData != null) {
            TbStructDescriptor tbStructDescriptor = TbStructDescriptor.createDescriptor(sQLData.getSQLTypeName(), (Connection)this.conn);
            SQLOutput sQLOutput = tbStructDescriptor.toSQLOutput();
            sQLData.writeSQL(sQLOutput);
            tbStruct = ((TbSQLOutput)sQLOutput).getStruct();
        }
        this.writeStruct(tbStruct);
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        this.attributes[this.index++] = ref;
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        this.attributes[this.index++] = blob;
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        this.attributes[this.index++] = clob;
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        this.attributes[this.index++] = struct;
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        this.attributes[this.index++] = array;
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeNString(String string) throws SQLException {
        this.attributes[this.index++] = string;
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        this.attributes[this.index++] = nClob;
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        this.attributes[this.index++] = rowId;
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void writeObject(Object object, SQLType sQLType) throws SQLException {
        this.attributes[this.index++] = object;
    }
}

