/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.cs.key.type;

import com.ubintis.agt5.common.exception.AgentException;
import java.util.Arrays;

public class SecretKey {
    private byte[] key;
    private byte[] iv;
    private byte[] macKey;
    private byte[] salt;

    public SecretKey(byte[] bArrayKey, byte[] bArraySalt) {
        if (bArrayKey != null && bArraySalt != null) {
            this.key = new byte[32];
            this.iv = new byte[16];
            this.macKey = new byte[32];
            this.salt = new byte[32];
            System.arraycopy(bArrayKey, 0, this.key, 0, 32);
            System.arraycopy(bArrayKey, 32, this.iv, 0, 16);
            if (bArrayKey.length == 64) {
                System.arraycopy(bArrayKey, 32, this.macKey, 0, 32);
            } else if (bArrayKey.length == 80) {
                System.arraycopy(bArrayKey, 48, this.macKey, 0, 32);
            } else {
                throw new AgentException("SecretKey bArrayKey is size incorrect : size[" + bArrayKey.length + "]");
            }
            if (bArraySalt.length != 32) {
                throw new AgentException("SecretKey bArraySalt is size incorrect : size[" + bArraySalt.length + "]");
            }
            System.arraycopy(bArraySalt, 0, this.salt, 0, 32);
            int i = 0;
            while (i < this.key.length) {
                int n = i;
                this.key[n] = (byte)(this.key[n] ^ this.salt[i]);
                ++i;
            }
            i = 0;
            while (i < this.iv.length) {
                int n = i;
                this.iv[n] = (byte)(this.iv[n] ^ this.salt[i]);
                ++i;
            }
            i = 0;
            while (i < this.macKey.length) {
                int n = i;
                this.macKey[n] = (byte)(this.macKey[n] ^ this.salt[i]);
                ++i;
            }
        } else {
            throw new AgentException("SecretKey parameter value is null");
        }
    }

    public byte[] getKey() {
        byte[] temp = new byte[32];
        int i = 0;
        while (i < this.key.length) {
            temp[i] = (byte)(this.key[i] ^ this.salt[i]);
            ++i;
        }
        return temp;
    }

    public byte[] getIv() {
        byte[] temp = new byte[16];
        int i = 0;
        while (i < this.iv.length) {
            temp[i] = (byte)(this.iv[i] ^ this.salt[i]);
            ++i;
        }
        return temp;
    }

    public byte[] getMacKey() {
        byte[] temp = new byte[32];
        int i = 0;
        while (i < this.macKey.length) {
            temp[i] = (byte)(this.macKey[i] ^ this.salt[i]);
            ++i;
        }
        return temp;
    }

    public void zeroize() {
        int repeat = 0;
        while (repeat < 3) {
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.iv, (byte)0);
            Arrays.fill(this.macKey, (byte)0);
            Arrays.fill(this.salt, (byte)0);
            ++repeat;
        }
    }
}

