/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.common.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final String MMddHHmmssSSS = "MMddHHmmssSSS";
    public static final String MMddHHmmss = "MMddHHmmss";
    public static final String ddHHmmssSSS = "ddHHmmssSSS";
    public static final String yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final String yyyyMMddhh24mmss = "yyyyMMddhh24mmss";

    public static Date check(String s) {
        Date date = null;
        try {
            date = DateUtil.check(s, "yyyyMMdd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date check(String s, String format) throws ParseException {
        if (s == null) {
            throw new ParseException("date string to check is null", 0);
        }
        if (format == null) {
            throw new ParseException("format string to check date is null", 0);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = null;
        try {
            date = formatter.parse(s);
        }
        catch (ParseException e) {
            throw new ParseException(" wrong date:\"" + s + "\" with format \"" + format + "\"", 0);
        }
        return date;
    }

    public static boolean isValid(String s) throws Exception {
        return DateUtil.isValid(s, "yyyyMMdd");
    }

    public static boolean isValid(String s, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = null;
        try {
            date = formatter.parse(s);
        }
        catch (ParseException e) {
            return false;
        }
        return formatter.format(date).equals(s);
    }

    public static String getDateString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static int getDay() {
        return DateUtil.getNumberByPattern("dd");
    }

    public static int getMonth() {
        return DateUtil.getNumberByPattern("MM");
    }

    public static int getNumberByPattern(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.KOREA);
        String dateString = formatter.format(new Date());
        return Integer.parseInt(dateString);
    }

    public static String getFormatString(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.KOREA);
        String dateString = formatter.format(new Date());
        return dateString;
    }

    public static String getFormatString(Date d, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.KOREA);
        String dateString = formatter.format(d);
        return dateString;
    }

    public static String getShortDateString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static String getShortTimeString() {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static String getTimeStampString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss:SSS", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static String getShortDateTimeString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static int daysBetween(String from, String to) throws ParseException {
        return DateUtil.daysBetween(from, to, "yyyyMMdd");
    }

    public static int daysBetween(String from, String to, String format) throws ParseException {
        Date d1 = DateUtil.check(from, format);
        Date d2 = DateUtil.check(to, format);
        long duration = d2.getTime() - d1.getTime();
        return (int)(duration / 86400000L);
    }

    public static int ageBetween(String from, String to) throws ParseException {
        return DateUtil.ageBetween(from, to, "yyyyMMdd");
    }

    public static int ageBetween(String from, String to, String format) throws ParseException {
        return DateUtil.daysBetween(from, to, format) / 365;
    }

    public static String addDays(String s, int day) throws ParseException {
        return DateUtil.addDays(s, day, "yyyyMMdd");
    }

    public static String addDays(String s, int day, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateUtil.check(s, format);
        date.setTime(date.getTime() + (long)day * 1000L * 60L * 60L * 24L);
        return formatter.format(date);
    }

    public static String addMonths(String s, int month) throws Exception {
        return DateUtil.addMonths(s, month, "yyyyMMdd");
    }

    /*
     * Unable to fully structure code
     */
    public static String addMonths(String s, int addMonth, String format) throws Exception {
        block4: {
            formatter = new SimpleDateFormat(format, Locale.KOREA);
            date = DateUtil.check(s, format);
            yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
            monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
            dayFormat = new SimpleDateFormat("dd", Locale.KOREA);
            year = Integer.parseInt(yearFormat.format(date));
            month = Integer.parseInt(monthFormat.format(date));
            day = Integer.parseInt(dayFormat.format(date));
            month += addMonth;
            if (addMonth <= 0) ** GOTO lbl18
            while (month > 12) {
                month -= 12;
                ++year;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                month += 12;
                --year;
lbl18:
                // 2 sources

                ** while (month <= 0)
            }
        }
        fourDf = new DecimalFormat("0000");
        twoDf = new DecimalFormat("00");
        tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
        targetDate = null;
        try {
            targetDate = DateUtil.check(tempDate, "yyyyMMdd");
        }
        catch (ParseException pe) {
            day = DateUtil.lastDay(year, month);
            tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
            targetDate = DateUtil.check(tempDate, "yyyyMMdd");
        }
        return formatter.format(targetDate);
    }

    public static String addYears(String s, int year) throws ParseException {
        return DateUtil.addYears(s, year, "yyyyMMdd");
    }

    public static String addYears(String s, int year, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateUtil.check(s, format);
        date.setTime(date.getTime() + (long)year * 1000L * 60L * 60L * 24L * 366L);
        return formatter.format(date);
    }

    public static int monthsBetween(String from, String to) throws ParseException {
        return DateUtil.monthsBetween(from, to, "yyyyMMdd");
    }

    public static int monthsBetween(String from, String to, String format) throws ParseException {
        Date toDate;
        Date fromDate = DateUtil.check(from, format);
        if (fromDate.compareTo(toDate = DateUtil.check(to, format)) == 0) {
            return 0;
        }
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
        SimpleDateFormat dayFormat = new SimpleDateFormat("dd", Locale.KOREA);
        int fromYear = Integer.parseInt(yearFormat.format(fromDate));
        int toYear = Integer.parseInt(yearFormat.format(toDate));
        int fromMonth = Integer.parseInt(monthFormat.format(fromDate));
        int toMonth = Integer.parseInt(monthFormat.format(toDate));
        int fromDay = Integer.parseInt(dayFormat.format(fromDate));
        int toDay = Integer.parseInt(dayFormat.format(toDate));
        int result = 0;
        result += (toYear - fromYear) * 12;
        result += toMonth - fromMonth;
        if (toDay - fromDay > 0) {
            result += toDate.compareTo(fromDate);
        }
        return result;
    }

    public static String lastDayOfMonth(String src) throws ParseException {
        return DateUtil.lastDayOfMonth(src, "yyyyMMdd");
    }

    public static String lastDayOfMonth(String src, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateUtil.check(src, format);
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
        int year = Integer.parseInt(yearFormat.format(date));
        int month = Integer.parseInt(monthFormat.format(date));
        int day = DateUtil.lastDay(year, month);
        DecimalFormat fourDf = new DecimalFormat("0000");
        DecimalFormat twoDf = new DecimalFormat("00");
        String tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
        date = DateUtil.check(tempDate, format);
        return formatter.format(date);
    }

    private static int lastDay(int year, int month) throws ParseException {
        int day = 0;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                day = 31;
                break;
            }
            case 2: {
                if (year % 4 == 0) {
                    if (year % 100 == 0 && year % 400 != 0) {
                        day = 28;
                        break;
                    }
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            default: {
                day = 30;
            }
        }
        return day;
    }

    public static String getTime(String form) {
        return DateUtil.getFormDate(new Date(), form, Locale.KOREAN);
    }

    public static String getTime() {
        return DateUtil.getFormDate(new Date(), "[yyyy.MM.dd. HH:mm:ss]", Locale.KOREAN);
    }

    public static String getYear() {
        return DateUtil.getFormDate(new Date(), "yyyy", Locale.KOREAN);
    }

    public static String getFormDate(Date date, String form, Locale locale) {
        String ret = "";
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(form, locale);
            ret = formatter.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static int getNewerDate(Date[] dates) {
        int newerInx = 0;
        int p = 1;
        while (p < dates.length) {
            if (dates[newerInx].getTime() - dates[p].getTime() < 0L) {
                newerInx = p;
            }
            ++p;
        }
        return newerInx;
    }

    public static int getOlderDate(Date[] dates) {
        int olderInx = 0;
        int p = 1;
        while (p < dates.length) {
            if (dates[p].getTime() - dates[olderInx].getTime() < 0L) {
                olderInx = p;
            }
            ++p;
        }
        return olderInx;
    }

    public static String getTimeString(long l) {
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String s = Integer.toString(calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5));
        String s1 = Integer.toString(calendar.get(11) * 10000 + calendar.get(12) * 100 + calendar.get(13));
        while (s1.length() < 6) {
            s1 = String.valueOf('0') + s1;
        }
        return String.valueOf(s) + s1;
    }

    public static String getTimeString() {
        return DateUtil.getTimeString(new Date().getTime());
    }

    public static String addDateToCurTime(int i) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, i);
        return DateUtil.getTimeString(calendar.getTimeInMillis());
    }

    public static int daySubtraction(Date stand) {
        Calendar now = Calendar.getInstance();
        long diff = (now.getTime().getTime() - stand.getTime()) / 86400000L;
        return (int)diff;
    }

    public static int timeSubtraction(Date stand) {
        Calendar now = Calendar.getInstance();
        long diff = (now.getTime().getTime() - stand.getTime()) / 1000L;
        return (int)diff;
    }

    public static String getTransDate(String orgDate, int lastLen) {
        String retDate = orgDate;
        try {
            if (lastLen == 8) {
                retDate = String.valueOf(orgDate.substring(0, 4)) + "/" + orgDate.substring(4, 6) + "/" + orgDate.substring(6, 8);
            } else if (lastLen == 14) {
                retDate = String.valueOf(orgDate.substring(0, 4)) + "/" + orgDate.substring(4, 6) + "/" + orgDate.substring(6, 8) + " " + orgDate.substring(8, 10) + ":" + orgDate.substring(10, 12) + ":" + orgDate.substring(12, 14);
            }
        }
        catch (Exception e) {
            retDate = orgDate;
        }
        return retDate;
    }

    public static String chDateFormat(String s, String format, String gubunja) {
        String dateTmp = s.replaceAll(gubunja, "");
        int year = Integer.parseInt(dateTmp.substring(0, 4));
        int month = Integer.parseInt(dateTmp.substring(4, 6));
        int day = Integer.parseInt(dateTmp.substring(6, 8));
        Calendar compareDate = Calendar.getInstance();
        compareDate.set(year, month - 1, day);
        System.out.println(dateTmp);
        if (dateTmp.length() != 8) {
            return s;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        return formatter.format(compareDate.getTime());
    }

    public static Date getUTCDateTime() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return f.parse(f.format(new Date()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getSystemDateTime() {
        return new Date(System.currentTimeMillis());
    }
}

