/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.TIS620CharToByteConverter;
import java.sql.SQLException;

public class TIS620Encoder
implements CharsetEncoder {
    private static TIS620CharToByteConverter conv = new TIS620CharToByteConverter();

    @Override
    public int charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return conv.convert(cArray, n, n + n2, byArray, n3, n3 + n4);
    }

    @Override
    public int charsToFixedBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return 0;
    }

    @Override
    public int getEndingBytePos(byte[] byArray, int n) {
        return n;
    }

    @Override
    public int getLeadingBytePos(byte[] byArray, int n) {
        return n;
    }

    @Override
    public int getMaxBytesPerChar() {
        return conv.getMaxBytesPerChar();
    }

    @Override
    public boolean isEndingByte(byte[] byArray, int n) {
        return true;
    }

    @Override
    public boolean isLeadingByte(byte[] byArray, int n) {
        return true;
    }

    @Override
    public byte[] stringToBytes(String string) throws SQLException {
        byte[] byArray = new byte[string.length() * this.getMaxBytesPerChar()];
        int n = conv.convert(string.toCharArray(), 0, string.length(), byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    @Override
    public int stringToBytes(byte[] byArray, int n, String string) throws SQLException {
        return conv.convert(string.toCharArray(), 0, string.length(), byArray, n, byArray.length);
    }
}

