/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.Big5CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.Big5ExtCharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.Big5_2003CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.HKSCS1999CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.HKSCS2001CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.MS950ExtCharToByteConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class MS950CharToByteConverter {
    private HKSCS2001CharToByteConverter hkscs2001Converter;
    private Big5CharToByteConverter big5Converter;
    private Big5ExtCharToByteConverter big5ExtConverter;
    private MS950ExtCharToByteConverter ms950ExtConverter;
    private Big5_2003CharToByteConverter big52003Converter;
    private HKSCS1999CharToByteConverter hkscsConverter;
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public MS950CharToByteConverter() {
        this.hkscs2001Converter = new HKSCS2001CharToByteConverter();
        this.big5Converter = new Big5CharToByteConverter();
        this.big5ExtConverter = new Big5ExtCharToByteConverter();
        this.ms950ExtConverter = new MS950ExtCharToByteConverter();
        this.big52003Converter = new Big5_2003CharToByteConverter();
        this.hkscsConverter = new HKSCS1999CharToByteConverter();
    }

    public int convCharArr(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5 = n3;
        byte[] byArray2 = new byte[2];
        for (int i = n; i < n2 && n5 < n4; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                byArray[n5++] = (byte)c;
                continue;
            }
            int n6 = this.hkscs2001Converter.convert(c, byArray2, 0);
            if (n6 == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.ms950ExtConverter.convert(c, byArray2, 0) == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.big5ExtConverter.convert(c, byArray2, 0) == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.big5Converter.convert(c, byArray2, 0) == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.big52003Converter.convert(c, byArray2, 0) == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.hkscsConverter.convert(c, byArray2, 0) == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.subMode) {
                byArray[n5++] = -95;
                byArray[n5++] = 72;
                continue;
            }
            throw TbError.newSQLException(-590742, (int)c);
        }
        return n5 - n3;
    }

    public int convCharArr(int[] nArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5 = n3;
        byte[] byArray2 = new byte[2];
        for (int i = n; i < n2 && n5 < n4; ++i) {
            int n6 = nArray[i];
            if (n6 < 128) {
                byArray[n5++] = (byte)n6;
                continue;
            }
            int n7 = this.hkscs2001Converter.convert(n6, byArray2, 0);
            if (n7 == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.ms950ExtConverter.convert(n6, byArray2, 0) == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.big5ExtConverter.convert(n6, byArray2, 0) == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.big5Converter.convert(n6, byArray2, 0) == 0) {
                byArray[n5++] = byArray2[0];
                byArray[n5++] = byArray2[1];
                continue;
            }
            if (this.subMode) {
                byArray[n5++] = this.subBytes[0];
                continue;
            }
            throw TbError.newSQLException(-590742, n6);
        }
        return n5 - n3;
    }

    public int convString(String string, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.convCharArr(string.toCharArray(), n, n2, byArray, n3, n4);
    }

    public int getMaxBytesPerChar() {
        return 2;
    }
}

