/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.util.Calendar;

public class TbTime {
    static final short OFFSET_HOUR_OF_DAY = 0;
    static final short OFFSET_MINUTE = 1;
    static final short OFFSET_SECOND = 2;
    static final short OFFSET_DATE_END = 7;
    public static final char DELIMITER_TIME = ':';
    public static final char DELIMITER_BLANK = ' ';
    public static final char DELIMITER_MILLIS = '.';
    private byte[] data;

    public TbTime(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data should not be null");
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("invalid array size");
        }
        this.data = byArray;
    }

    public TbTime(int n, int n2, int n3, int n4) {
        this.data = new byte[8];
        if (n4 > 999999999 || n4 < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.data[0] = (byte)n;
        this.data[1] = (byte)n2;
        this.data[2] = (byte)n3;
        this.data[7] = 0;
        TbCommon.int2Bytes(n4, this.data, 4, 4);
    }

    public TbTime(long l) {
        this.data = new byte[8];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(0);
        int n2 = calendar.get(1);
        if (n == 0) {
            n2 *= -1;
        }
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = (int)(l % 1000L * 1000000L);
        if (n8 < 0) {
            n8 = 1000000000 + n8;
        }
        this.data[0] = (byte)n5;
        this.data[1] = (byte)n6;
        this.data[2] = (byte)n7;
        this.data[7] = 0;
        TbCommon.int2Bytes(n8, this.data, 4, 4);
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getHourOfDay() {
        int n = 0xFF & this.data[0];
        return n;
    }

    public int getMinutes() {
        int n = 0xFF & this.data[1];
        return n;
    }

    public int getSeconds() {
        int n = 0xFF & this.data[2];
        return n;
    }

    public int getNanos() {
        int n = TbCommon.bytes2Int(this.data, 4, 4);
        return n;
    }

    public String toString() {
        int n;
        char[] cArray = new char[20];
        int n2 = 0;
        n2 += TbTime.writeFormattedInt(cArray, n2, 2, this.getHourOfDay());
        cArray[n2++] = 58;
        n2 += TbTime.writeFormattedInt(cArray, n2, 2, this.getMinutes());
        cArray[n2++] = 58;
        n2 += TbTime.writeFormattedInt(cArray, n2, 2, this.getSeconds());
        int n3 = this.getNanos();
        if (n3 < 0) {
            n3 = 0;
        }
        cArray[n2++] = 46;
        String string = Integer.toString(n3);
        int n4 = string.length();
        for (n = 0; n < 9; ++n) {
            cArray[n2 + n] = 9 - n > n4 ? 48 : string.charAt(n - 9 + n4);
        }
        for (n = 4; n > 0 && cArray[n2 + n] == '0'; --n) {
        }
        return new String(cArray, 0, n2 += n + 1);
    }

    private static int writeFormattedInt(char[] cArray, int n, int n2, int n3) {
        for (int i = n + n2 - 1; i >= n; --i) {
            int n4 = n3 % 10;
            cArray[i] = (char)(48 + n4);
            n3 /= 10;
        }
        return n2;
    }
}

