/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbKeepAlive;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbMsgFactory;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TbStream {
    private Socket socket;
    private TbConnection conn;
    private InputStream input;
    private OutputStream output;
    private String host;
    private int port;
    private int tduSize = 0;
    private int msgType;
    private int msgBodySize = 0;
    private StreamBuffer readBuf;
    private StreamBuffer writeBuf;
    private TbStreamDataReader reader;
    private TbStreamDataWriter writer;
    private StreamBuffer dplBuf;
    private TbStreamDataWriter dplWriter;
    private boolean useSelfKeepAlive;
    private long selfKeepIdle;
    private long selfKeepInterval;
    private int selfKeepCount;
    private TbKeepAlive keepAlive;

    public TbStream(TbConnection tbConnection, Socket socket, DataTypeConverter dataTypeConverter, ConnectionInfo connectionInfo) throws SQLException {
        try {
            this.conn = tbConnection;
            this.initTCP(socket, dataTypeConverter, connectionInfo);
        }
        catch (ConnectException connectException) {
            throw TbError.newSQLException(-90401, connectException.getMessage());
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90400, iOException.getMessage());
        }
    }

    public TbStream(TbConnection tbConnection, String string, int n, DataTypeConverter dataTypeConverter, ConnectionInfo connectionInfo) throws SQLException {
        try {
            this.conn = tbConnection;
            this.host = string;
            this.port = n;
            if (connectionInfo.getNetworkProtocol().equalsIgnoreCase("TCPS")) {
                this.initTCPS(dataTypeConverter, connectionInfo);
            } else {
                Socket socket = new Socket();
                InetSocketAddress inetSocketAddress = this.host != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n);
                socket.connect(inetSocketAddress, connectionInfo.getLoginTimeout());
                this.initTCP(socket, dataTypeConverter, connectionInfo);
            }
        }
        catch (ConnectException connectException) {
            throw TbError.newSQLException(-90401, connectException.getMessage());
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90400, iOException.getMessage());
        }
    }

    public void abort() throws SQLException {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90409, iOException.getMessage());
        }
    }

    public void close() throws SQLException {
        try {
            this.reset();
            IOException iOException = null;
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (IOException iOException3) {
                iOException = iOException3;
            }
            try {
                if (this.socket != null && !this.conn.info.isInternal()) {
                    this.socket.close();
                }
            }
            catch (IOException iOException4) {
                iOException = iOException4;
            }
            if (iOException != null) {
                throw iOException;
            }
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90409, iOException.getMessage());
        }
    }

    public TbStreamDataWriter createDirPathWriter(int n) {
        if (this.dplBuf == null) {
            this.dplBuf = new StreamBuffer(n);
        } else if (n != this.dplBuf.getSize()) {
            this.dplBuf.resize(n);
        }
        if (this.dplWriter == null) {
            this.dplWriter = new TbStreamDataWriter(this.dplBuf);
        }
        return this.dplWriter;
    }

    public void flush() throws SQLException {
        this.flushInternal(this.writeBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(TbStreamDataWriter tbStreamDataWriter) throws SQLException {
        StreamBuffer streamBuffer = this.writeBuf;
        synchronized (streamBuffer) {
            this.flushInternal(tbStreamDataWriter.getStreamBuf());
        }
    }

    private void flushInternal(StreamBuffer streamBuffer) throws SQLException {
        block12: {
            try {
                if (streamBuffer.getCurDataSize() <= 0) break block12;
                if (this.useSelfKeepAlive) {
                    try {
                        this.keepAlive = TbKeepAlive.register(this.socket, this.selfKeepIdle, this.selfKeepInterval, this.selfKeepCount, this.conn.getMthrPid(), this.conn.toString());
                        this.output.write(streamBuffer.getRawBytes(), 0, streamBuffer.getCurDataSize());
                        this.output.flush();
                        break block12;
                    }
                    finally {
                        if (this.keepAlive != null) {
                            TbKeepAlive.unregister(this.keepAlive);
                            this.keepAlive = null;
                        }
                    }
                }
                this.output.write(streamBuffer.getRawBytes(), 0, streamBuffer.getCurDataSize());
                this.output.flush();
            }
            catch (IOException iOException) {
                SQLException sQLException = TbError.newSQLException(-90406, iOException.getMessage());
                this.conn.reconnect(this.conn.isMiddleOfFailover());
                if (this.conn.isClosed()) {
                    if (this.conn.getFOActiveRSetList() != null) {
                        for (TbResultSetBase tbResultSetBase : this.conn.getFOActiveRSetList()) {
                            tbResultSetBase.setFOECode(-90406);
                        }
                    }
                    throw sQLException;
                }
                if (this.conn.getFOActiveRSetList() != null) {
                    for (TbResultSetBase tbResultSetBase : this.conn.getFOActiveRSetList()) {
                        tbResultSetBase.setFOECode(-90700);
                    }
                }
                throw TbError.newSQLException(-90700, sQLException);
            }
        }
    }

    public int getMsgType() {
        return this.msgType;
    }

    public TbStreamDataWriter getMsgWriter() {
        return this.writer;
    }

    public StreamBuffer getReadStreamBuffer() {
        return this.readBuf;
    }

    public StreamBuffer getWriteStreamBuffer() {
        return this.writeBuf;
    }

    public void handshakeSSL() throws SQLException {
        try {
            ((SSLSocket)this.socket).setUseClientMode(true);
            ((SSLSocket)this.socket).setEnableSessionCreation(true);
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90400, iOException.getMessage());
        }
    }

    private void initTCP(Socket socket, DataTypeConverter dataTypeConverter, ConnectionInfo connectionInfo) throws IOException {
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.socket.setKeepAlive(connectionInfo.isFailoverSessionEnabled());
        this.socket.setSoTimeout(connectionInfo.getLoginTimeout());
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.tduSize = connectionInfo.getTDU();
        this.readBuf = new StreamBuffer(this.tduSize);
        this.writeBuf = new StreamBuffer(this.tduSize);
        this.reader = new TbStreamDataReader(this.readBuf, dataTypeConverter);
        this.writer = new TbStreamDataWriter(this.writeBuf, dataTypeConverter);
        this.useSelfKeepAlive = connectionInfo.useSelfKeepAlive();
        this.selfKeepIdle = connectionInfo.getSelfKeepIdle() * 1000;
        this.selfKeepInterval = connectionInfo.getSelfKeepInterval() * 1000;
        this.selfKeepCount = connectionInfo.getSelfKeepCount();
    }

    private void initTCPS(DataTypeConverter dataTypeConverter, ConnectionInfo connectionInfo) throws IOException {
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            this.port += 2;
            this.socket = sSLSocketFactory.createSocket(this.host, this.port);
            String[] stringArray = ((SSLSocket)this.socket).getSupportedProtocols();
            String[] stringArray2 = this.getNewTLSProtocols(stringArray);
            ((SSLSocket)this.socket).setEnabledProtocols(stringArray2);
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this.socket.setTcpNoDelay(true);
        this.socket.setKeepAlive(connectionInfo.isFailoverSessionEnabled());
        this.socket.setSoTimeout(connectionInfo.getLoginTimeout());
        this.input = this.socket.getInputStream();
        this.output = this.socket.getOutputStream();
        this.tduSize = connectionInfo.getTDU();
        this.readBuf = new StreamBuffer(this.tduSize);
        this.writeBuf = new StreamBuffer(this.tduSize);
        this.reader = new TbStreamDataReader(this.readBuf, dataTypeConverter);
        this.writer = new TbStreamDataWriter(this.writeBuf, dataTypeConverter);
        this.useSelfKeepAlive = connectionInfo.useSelfKeepAlive();
        this.useSelfKeepAlive = connectionInfo.useSelfKeepAlive();
        this.selfKeepIdle = connectionInfo.getSelfKeepIdle() * 1000;
        this.selfKeepInterval = connectionInfo.getSelfKeepInterval() * 1000;
        this.selfKeepCount = connectionInfo.getSelfKeepCount();
    }

    private String[] getNewTLSProtocols(String[] stringArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("TLS")) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readChunkData(byte[] byArray, int n) throws SQLException {
        StreamBuffer streamBuffer = this.readBuf;
        synchronized (streamBuffer) {
            if (this.readNBytes(byArray, 0, n) != n) {
                throw TbError.newSQLException(-590729);
            }
            this.msgBodySize = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbMsg readMsg() throws SQLException {
        TbMsg tbMsg = null;
        StreamBuffer streamBuffer = this.readBuf;
        synchronized (streamBuffer) {
            byte[] byArray = new byte[16];
            this.readNBytes(byArray, 0, 16);
            this.msgType = TbCommon.bytes2Int(byArray, 0, 4);
            this.msgBodySize = TbCommon.bytes2Int(byArray, 4, 4);
            tbMsg = TbMsgFactory.createMessage(this.msgType);
            tbMsg.setTsn(TbCommon.bytes2Long(byArray, 8, 8));
            if (this.msgBodySize <= 0) {
                return tbMsg;
            }
            this.readBuf.init(this.msgBodySize);
            if (this.readNBytes(this.readBuf.getRawBytes(), 0, this.msgBodySize) != this.msgBodySize) {
                throw TbError.newSQLException(-590729);
            }
            this.readBuf.setCurDataSize(this.msgBodySize);
            this.reader.initialize(this.readBuf);
            this.msgBodySize = 0;
            tbMsg.deserialize(this.reader);
        }
        return tbMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readNBytes(byte[] byArray, int n, int n2) throws SQLException {
        try {
            long l = 0L;
            int n3 = 0;
            if (this.conn.isActivatedTimer()) {
                l = System.currentTimeMillis();
            }
            if (this.useSelfKeepAlive) {
                int n4 = 0;
                while (n3 != n2) {
                    try {
                        this.keepAlive = TbKeepAlive.register(this.socket, this.selfKeepIdle, this.selfKeepInterval, this.selfKeepCount, this.conn.getMthrPid(), this.conn.toString());
                        n4 = this.input.read(byArray, n + n3, n2 - n3);
                    }
                    finally {
                        if (this.keepAlive != null) {
                            TbKeepAlive.unregister(this.keepAlive);
                            this.keepAlive = null;
                        }
                    }
                    if (n4 == -1) {
                        throw new IOException("End Of Stream");
                    }
                    n3 += n4;
                }
            } else {
                int n5 = 0;
                while (n3 != n2) {
                    n5 = this.input.read(byArray, n + n3, n2 - n3);
                    if (n5 == -1) {
                        throw new IOException("End Of Stream");
                    }
                    n3 += n5;
                }
            }
            if (this.conn.isActivatedTimer()) {
                this.conn.addWaitingTime(System.currentTimeMillis() - l);
            }
            return n3;
        }
        catch (IOException iOException) {
            SQLException sQLException = TbError.newSQLException(-90405, iOException.getMessage());
            this.conn.reconnect(this.conn.isMiddleOfFailover());
            if (this.conn.isClosed()) {
                if (this.conn.getFOActiveRSetList() != null) {
                    for (TbResultSetBase tbResultSetBase : this.conn.getFOActiveRSetList()) {
                        tbResultSetBase.setFOECode(-90405);
                    }
                }
                throw sQLException;
            }
            if (this.conn.getFOActiveRSetList() != null) {
                for (TbResultSetBase tbResultSetBase : this.conn.getFOActiveRSetList()) {
                    tbResultSetBase.setFOECode(-90700);
                }
            }
            throw TbError.newSQLException(-90700, sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readToken() throws SQLException {
        StreamBuffer streamBuffer = this.readBuf;
        synchronized (streamBuffer) {
            byte[] byArray = new byte[4];
            this.readNBytes(byArray, 0, 1);
            this.readNBytes(byArray, 0, 4);
            int n = TbCommon.bytes2Int(byArray, 0, 4);
            byte[] byArray2 = new byte[n];
            this.readNBytes(byArray2, 0, n);
            return byArray2;
        }
    }

    public void reset() {
        this.tduSize = 0;
        this.input = null;
        this.output = null;
        this.reader.reset();
        this.writer.reset();
    }

    public void setSoTimeout(int n) {
        try {
            this.socket.setSoTimeout(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getSoTimeout() throws SQLException {
        try {
            return this.socket.getSoTimeout();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public void setSelfKeepAliveEnabled(boolean bl) {
        this.useSelfKeepAlive = bl;
    }

    public void startWritingPacketData() {
        this.writer.initialize(this.writeBuf);
    }
}

