package com.penta.scpdb;
import java.io.*;
import java.util.*;


/**
 * SCP For DB Encryption Agent <br/> 
 * Column Ϻȣȭ 񽺸 ϴ Ŭ
 * @author nammw@pentasecurity.com
 */
public class ScpDbAgent
{
  private static final Object initBASCPSyncObj = new Object();
  public static boolean isWindows = false;  
  
  public static final int SCP_KEYINFO    = 0;
  public static final int SCP_SERVICEID  = 1;  
  
  public static final int SCP_CERT_HASH = 0;
  public static final int SCP_SHA256    = 1;
  public static final int SCP_SHA384    = 2;
  public static final int SCP_SHA512    = 3;

  static  
  {
    //System.loadLibrary("scpdb_agent_jni");

    // user.dir   ( ORACLE ORACLE_HOME ΰ  )
    String strPropValue = new String();
    Properties propsCurrent = System.getProperties();
    strPropValue = propsCurrent.getProperty("user.dir");

    String javaVersion = propsCurrent.getProperty("java.specification.version");
    // getEnv Լ 1.5 ̻  .
    if ( Float.parseFloat(javaVersion) >= 1.5 )
    {
      // ORACLE_HOME ȯ溯 
      String strEnvOracleHome = System.getenv("ORACLE_HOME");

      // ORACLE_HOME ȯ溯 ų, user.dir ٸٸ ̺귯 ε,
      // ׷ ʴٸ, ̺귯 ε .
      if ( strEnvOracleHome == null || (strEnvOracleHome.equals(strPropValue) == false ) )
      {
        System.loadLibrary("scpdb_agent_jni");
      }
    }
    else
      System.loadLibrary("scpdb_agent_jni");

    if ( "\\".equals(System.getProperty("file.separator")) )
      isWindows = true;
  }

  //public static String strIniPath_ = "";
  private static int    nInit_ = -1;  

/**
  *native method
  */
  public static native int 
  _Agent_Init( byte[] iniPath, int iniPathLen );

  /**
  *native method
  */
  public static native int 
  _Agent_ReInit( byte[] iniPath, int iniPathLen );
  
/**
  *native method
  */
  public static native int
  _Agent_Fini();
  
/**
  *native method
  */
  public static native byte[] 
  _Agent_Cipher_CreateContext( 
    byte[] agent_id, int agent_id_len,
    byte[] db_name, int db_name_len,
    byte[] db_owner, int db_owner_len,
    byte[] table_name, int table_name_len,
    byte[] column_name, int column_name_len );

/**
  *native method
  */
  public static native byte[] 
  _Agent_Cipher_CreateContextServiceID(
    byte[] serviceID, int serviceID_len,
    byte[] account, int account_len );
  
/**
  *native method
  */
  public static native byte[] 
  _Agent_Cipher_CreateContextImportFile( 
    byte[] keyPath, int keyPathLen );
        
/**
  *native method
  */    
  public static native int 
  _Agent_Cipher_DeleteContext( 
    byte[] context, int contextLen );

/**
  *native method
  */    
  public static native int 
  _Agent_Cipher_ClearAllContext();
    
/**
  *native method
  */
  public static native byte[] 
  _Agent_Cipher_Encrypt(    
    byte[] context, 
    int contextLen,
    byte[] in, 
    int    inLen );
    
/**
  *native method
  */
  public static native byte[] 
  _Agent_Cipher_Decrypt( 
    byte[] context,
    int contextLen,    
    byte[] in, 
    int    inLen );

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Encrypt_UTF8(    
    byte[] context, 
    int contextLen,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Decrypt_UTF8( 
    byte[] context,
    int contextLen,    
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Encrypt_CP_UTF8(    
    byte[] context, 
    int contextLen,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Decrypt_CP_UTF8( 
    byte[] context,
    int contextLen,    
    String in);
    
/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Encrypt_UTF8_B64(    
    byte[] context, 
    int contextLen,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Decrypt_UTF8_B64( 
    byte[] context,
    int contextLen,    
    String in);
    
/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Encrypt_EUCKR(
    byte[] context, 
    int contextLen,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Decrypt_EUCKR( 
    byte[] context,
    int contextLen,    
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Encrypt_CP_EUCKR(
    byte[] context, 
    int contextLen,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Decrypt_CP_EUCKR( 
    byte[] context,
    int contextLen,    
    String in);
    
/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Encrypt_EUCKR_B64(
    byte[] context, 
    int contextLen,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Decrypt_EUCKR_B64( 
    byte[] context,
    int contextLen,    
    String in);

/**
  *native method
  */
  public static native byte[] 
  _Agent_Cipher_Index(    
    byte[] context, 
    int contextLen,
    byte[] in, 
    int    inLen );
    
/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Index_UTF8(    
    byte[] context, 
    int contextLen,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Index_EUCKR(    
    byte[] context, 
    int contextLen,
    String in);
    
/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Encrypt_Number(    
    byte[] context, 
    int contextLen,
    String number,
    String type);
    
/**
  *native method
  */
  public static native String  
  _Agent_Cipher_Decrypt_Number( 
    byte[] context,
    int contextLen,    
    String cipher,
    String type);
  
/**
  *native method
  */
  public static native String
  _Agent_Cipher_Encrypt_Int(    
    byte[] context, 
    int contextLen,
    int number,
    String type);
    
/**
  *native method
  */
  public static native int  
  _Agent_Cipher_Decrypt_Int( 
    byte[] context,
    int contextLen,    
    String cipher, 
    String type);
    
/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Encrypt_Number_B64(    
    byte[] context, 
    int contextLen,
    String number,
    String type);
    
/**
  *native method
  */
  public static native String  
  _Agent_Cipher_Decrypt_Number_B64( 
    byte[] context,
    int contextLen,    
    String cipher,
    String type);
  
/**
  *native method
  */
  public static native String
  _Agent_Cipher_Encrypt_Int_B64(    
    byte[] context, 
    int contextLen,
    int number,
    String type);
    
/**
  *native method
  */
  public static native int  
  _Agent_Cipher_Decrypt_Int_B64( 
    byte[] context,
    int contextLen,    
    String cipher, 
    String type);
    
/**
  *native method
  */
  public static native byte[]  
  _Agent_Cipher_Encrypt_B64(    
    byte[] context, 
    int contextLen,
    byte[] in, 
    int    inLen );
    
/**
  *native method
  */
  public static native byte[] 
  _Agent_Cipher_Decrypt_B64( 
    byte[] context,
    int contextLen,    
    byte[] in, 
    int    inLen );
  
/**
  *native method
  */
  public static native byte[]  
  _Agent_Cipher_Encrypt_Raw(    
    byte[] context, 
    int contextLen,
    byte[] in, 
    int    inLen );
    
/**
  *native method
  */
  public static native byte[] 
  _Agent_Cipher_Decrypt_Raw( 
    byte[] context,
    int contextLen,    
    byte[] in, 
    int    inLen );
  
/**
  *native method
  */  
  public static native int
  _Agent_GetLastError();

/**
  *native method
  */  
  public static native int
  _Agent_Cipher_EncryptFilePath(    
    byte[] context, 
    int contextLen,
    byte[] in, 
    int    inLen,
    byte[] out, 
    int    outLen );

/**
  *native method
  */    
  public static native int
  _Agent_Cipher_DecryptFilePath( 
    byte[] context,
    int contextLen,    
    byte[] in, 
    int    inLen, 
    byte[] out, 
    int    outLen     );
    
/**
  *native method
  */
  public static native byte[]
  _Agent_Cipher_Hash_Base64(
    int hashId,
    byte[] in,
    int inLen );
    
/**
  *native method
  */
  public static native byte[]
  _Agent_Cipher_Hash(
    int hashId,
    byte[] in,
    int inLen );

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Hash_UTF8(    
    int hashId,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Hash_EUCKR(    
    int hashId,
    String in);
    
/**
  *native method
  */
  /**
  *native method
  */
  public static native byte[] 
  _SCP_Hash_Str_Byte(
    String iniFilePath,  
    int hashId,
    byte[] in);
  
/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Hash_UTF8_B64(    
    int hashId,
    String in);

/**
  *native method
  */
  public static native String 
  _Agent_Cipher_Hash_EUCKR_B64(    
    int hashId,
    String in);  


/**
  *native method
  */
  public static native byte[] 
  _SCP_Hash_B64_Byte(
  String iniFilePath,  
  int hashId,
  byte[] in);


/**
  *native method
  */
/*  
  public static native byte[]
  _Agent_Cipher_Init_Hash_Base64(
    byte[] iniPath,
    int iniPathLen,
    byte[] hashId,
    int hashIdLen,
    byte[] in,
    int inLen );    
*/

/**
  *native method
  */
  public static native byte[]
  _Agent_HexToB64(
    byte[] in,
    int inLen );    

/**
  *native method
  */
  public static native byte[]
  _Agent_B64ToHex(
    byte[] in,
    int inLen );    
    
/**
  *native method
  */
/*  
  public static native byte[]
  _Agent_Cipher_Init_CreateContextImportFile_Encrypt(
    byte[] iniPath,
    int iniPathLen,
    byte[] keyPath,
    int keyPathLen,
    byte[] plain,
    int plainLen );    
*/
/**
  *native method
  */
/*  
  public static native byte[]
  _Agent_Cipher_Init_CreateContextImportFile_Decrypt(
    byte[] iniPath,
    int iniPathLen,
    byte[] keyPath,
    int keyPathLen,
    byte[] enc,
    int encLen );    
*/ 
   
/**
  *native method
  */
  public static native String 
  _Scp_Export_Context(    
    String iniFilePath, 
    String iniKeyName);

/**
  *native method
  */
  public static native String 
  _Scp_Export_Context_ServiceID(    
    String iniFilePath, 
    String serviceID);

/**
  *native method
  */
  public static native String 
  _Scp_Export_Key(    
    String iniFilePath, 
    String iniKeyName,
    String account);
    
/**
  *native method
  */
  public static native String 
  _Scp_Export_Key_ServiceID(    
    String iniFilePath, 
    String serviceID,
    String account);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_Str_UTF8(    
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Dec_Str_UTF8( 
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_Str_EUCKR(    
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Dec_Str_EUCKR( 
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_B64_UTF8(    
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Dec_B64_UTF8( 
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_B64_EUCKR(    
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Dec_B64_EUCKR( 
    String iniFilePath, 
    String iniKeyName,
    String in);        

/**
*native method
*/
  public static native byte[]
  _Scp_Enc_Str_Byte(
  String iniFilePath,
  String iniKeyName,
  byte[] in);

  /**
  *native method
  */
  public static native byte[]
  _Scp_Dec_Str_Byte(
  String iniFilePath,
  String iniKeyName,
  byte[] in);

/**
  *native method
  */
  public static native byte[]
  _Scp_Enc_B64_Byte(
    String iniFilePath,
    String iniKeyName,
    byte[] in);

/**
  *native method
  */
  public static native byte[]
  _Scp_Dec_B64_Byte(
    String iniFilePath,
    String iniKeyName,
    byte[] in);

/**
  *native method
  */
  public static native int 
  _Scp_Enc_File(    
    String iniFilePath, 
    String iniKeyName,
    byte[] inFilePath,
    byte[] outFilePath);

/**
  *native method
  */
  public static native int
  _Scp_Dec_File( 
    String iniFilePath, 
    String iniKeyName,
    byte[] inFilePath,
    byte[] outFilePath);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_RRN_B64_UTF8(    
    String iniFilePath, 
    String iniKeyName,
    String in);  
    

/**
  *native method
  */
  public static native String 
  _Scp_Key_Hash_Str_UTF8(    
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Key_Hash_Str_EUCKR(    
    String iniFilePath, 
    String iniKeyName,
    String in);
    
    
/**
*native method
*/
  public static native byte[]
  _Scp_Key_Hash_Str_Byte(
  String iniFilePath,
  String iniKeyName,
  byte[] in);


/**
  *native method
  */
  public static native String 
  _Scp_Key_Hash_B64_UTF8(    
    String iniFilePath, 
    String iniKeyName,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Key_Hash_B64_EUCKR(    
    String iniFilePath, 
    String iniKeyName,
    String in);
    
    
/**
*native method
*/
  public static native byte[]
  _Scp_Key_Hash_B64_Byte(
  String iniFilePath,
  String iniKeyName,
  byte[] in);
  
    
/**
  *native method
  */
  public static native byte[] 
  _Scp_Enc_File_Buf(    
    String iniFilePath, 
    String iniKeyName,
    byte[] inFileData);

/**
  *native method
  */
  public static native byte[]
  _Scp_Dec_File_Buf( 
    String iniFilePath, 
    String iniKeyName,
    byte[] inFileData);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_Str_ServiceID_UTF8(    
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Dec_Str_ServiceID_UTF8( 
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_Str_ServiceID_EUCKR(    
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Dec_Str_ServiceID_EUCKR( 
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_B64_ServiceID_UTF8(    
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Dec_B64_ServiceID_UTF8( 
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Enc_B64_ServiceID_EUCKR(    
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Dec_B64_ServiceID_EUCKR( 
    String iniFilePath, 
    String serviceID,
    String in);
    
    
/**
  *native method
  */
  public static native String 
  _Scp_Key_Hash_Str_ServiceID_UTF8(    
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Key_Hash_Str_ServiceID_EUCKR(    
    String iniFilePath, 
    String serviceID,
    String in);


/**
  *native method
  */
  public static native String 
  _Scp_Key_Hash_B64_ServiceID_UTF8(    
    String iniFilePath, 
    String serviceID,
    String in);

/**
  *native method
  */
  public static native String 
  _Scp_Key_Hash_B64_ServiceID_EUCKR(    
    String iniFilePath, 
    String serviceID,
    String in);
    

/**
*native method
*/
  public static native byte[]
  _Scp_Enc_Str_ServiceID_Byte(
  String iniFilePath,
  String serviceID,
  byte[] in);

  /**
  *native method
  */
  public static native byte[]
  _Scp_Dec_Str_ServiceID_Byte(
  String iniFilePath,
  String serviceID,
  byte[] in);

/**
  *native method
  */
  public static native byte[]
  _Scp_Enc_B64_ServiceID_Byte(
    String iniFilePath,
    String serviceID,
    byte[] in);
    
/**
*native method
*/
  public static native byte[]
  _Scp_Key_Hash_Str_ServiceID_Byte(
  String iniFilePath,
  String serviceID,
  byte[] in);    
 

/**
  *native method
  */
  public static native byte[]
  _Scp_Dec_B64_ServiceID_Byte(
    String iniFilePath,
    String serviceID,
    byte[] in);
    
    
/**
*native method
*/
  public static native byte[]
  _Scp_Key_Hash_B64_ServiceID_Byte(
  String iniFilePath,
  String serviceID,
  byte[] in);    

/**
  *native method
  */
  public static native String 
  _Scp_Enc_RRN_B64_ServiceID_UTF8(    
    String iniFilePath, 
    String serviceID,
    String in);  
    
/**
  *native method
  */
  public static native int
  _Scp_Ke_Dec_FF( 
    String iniFilePath, 
    byte[] inFilePath,
    byte[] outFilePath);    


/**
  *native method
  */
  public static native byte[]
  _Scp_Ke_Dec_BB_Offset( 
    String iniFilePath, 
    byte[] inData,
    long   inDataLen,
    long   offset);
    
/**
  *native method
  */
  public static native byte[]
  _Scp_Ke_Dec_FB_Offset( 
    String iniFilePath, 
    byte[] inFilePath,
    long    inDataLen,
    long    offset);
    

/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Enc_Bin_UTF8(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native String
  _Scp_Asymm_Enc_Bin_EUCKR(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);

/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Enc_Bin_Byte(
    String iniFilePath,
    String iniKeyName,
    byte[] in,
    int    keyType );   


/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Enc_Hex_UTF8(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);
 
/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Enc_Hex_EUCKR(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Enc_Hex_Byte(
    String iniFilePath,
    String iniKeyName,
    byte[] in,
    int    keyType );     
    
    
/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Enc_B64_UTF8(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native String
  _Scp_Asymm_Enc_B64_EUCKR(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);

/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Enc_B64_Byte(
    String iniFilePath,
    String iniKeyName,
    byte[] in,
    int    keyType );  


/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Dec_Bin_UTF8(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native String
  _Scp_Asymm_Dec_Bin_EUCKR(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);

/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Dec_Bin_Byte(
    String iniFilePath,
    String iniKeyName,
    byte[] in,
    int    keyType );   


/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Dec_Hex_UTF8(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);
    
/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Dec_Hex_EUCKR(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Dec_Hex_Byte(
    String iniFilePath,
    String iniKeyName,
    byte[] in,
    int    keyType );     
    
    
/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Dec_B64_UTF8(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native String
  _Scp_Asymm_Dec_B64_EUCKR(
    String iniFilePath,
    String iniKeyName,
    String in,
    int    keyType);

/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Dec_B64_Byte(
    String iniFilePath,
    String iniKeyName,
    byte[] in,
    int    keyType );    
   


/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Sign_Bin_UTF8(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native String
  _Scp_Asymm_Sign_Bin_EUCKR(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    int    keyType);

/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Sign_Bin_Byte(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    byte[] in,
    int    keyType );   

/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Sign_Hex_UTF8(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native String
  _Scp_Asymm_Sign_Hex_EUCKR(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    int    keyType);

/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Sign_Hex_Byte(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    byte[] in,
    int    keyType );   

 
/**
  *native method
  */    
  public static native String
  _Scp_Asymm_Sign_B64_UTF8(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    int    keyType);
    
/**
  *native method
  */
  public static native String
  _Scp_Asymm_Sign_B64_EUCKR(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    int    keyType);

/**
  *native method
  */
  public static native byte[]
  _Scp_Asymm_Sign_B64_Byte(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    byte[] in,
    int    keyType );   


/**
  *native method
  */    
  public static native int
  _Scp_Asymm_Verify_Bin_UTF8(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    String sign,
    int    keyType);
    
/**
  *native method
  */
  public static native int
  _Scp_Asymm_Verify_Bin_EUCKR(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    String sign,
    int    keyType);

/**
  *native method
  */
  public static native int
  _Scp_Asymm_Verify_Bin_Byte(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    byte[] in,
    byte[] sign,
    int    keyType );   

/**
  *native method
  */    
  public static native int
  _Scp_Asymm_Verify_Hex_UTF8(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    String sign,
    int    keyType);
    
/**
  *native method
  */
  public static native int
  _Scp_Asymm_Verify_Hex_EUCKR(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    String sign,
    int    keyType);

/**
  *native method
  */
  public static native int
  _Scp_Asymm_Verify_Hex_Byte(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    byte[] in,
    byte[] sign,
    int    keyType );   

 
/**
  *native method
  */    
  public static native int
  _Scp_Asymm_Verify_B64_UTF8(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    String sign,
    int    keyType);
    
/**
  *native method
  */
  public static native int
  _Scp_Asymm_Verify_B64_EUCKR(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    String in,
    String sign,
    int    keyType);

/**
  *native method
  */
  public static native int
  _Scp_Asymm_Verify_B64_Byte(
    String iniFilePath,
    String iniKeyName,
    int    hashAlgo,
    byte[] in,
    byte[] sign,
    int    keyType );   

 
    
/**
 * ScpDbAgent ü Ѵ.  
 */
  public ScpDbAgent()
  {   
  }

/* ڸ   
  public ScpDbAgent(String iniPath)
  {   
    if(checkNull(iniPath))
    {
      throw new ScpDbAgentException("iniFilePath is null" );  
    }
    
    if( nInit_ == 0 )
    {
      strIniPath_ = iniPath;
      AgentInit( strIniPath_ );
    }
  }
*/
  
/**
 * ScpDbAgent ü Ѵ.  
 */
 
/* 
  public void finalize() 
  {  
    if( nInit_ == 1 )
    {  
      AgentFini();
    }
  }
*/
  
/**
  *check null byte
  */
  public static boolean 
  checkNull(byte bt[])
  {
    boolean flag = false;
    if(bt == null)
      flag = true;
/*      
    else if(bt.length < 1)
    flag = true;
*/    
  return flag;
/*  ϰ ʹ Ŀ ּóŭ
    String s = new String(bt);
    boolean flag = false;
    if(s == null)
      flag = true;
    else if(s.trim().equals(""))
      flag = true;
    else if(" ".equals(s))
      flag = true;
    else if(s.length() < 1)
      flag = true;
    return flag;
*/  
  }  
  
/**
  *check null String
  */
  public static boolean 
  checkNull(String s)
  {    
    boolean flag = false;
    if(s == null)
      flag = true;
/*  ȣȭ Ҽ ־ ּó  
    else if(s.trim().equals(""))
      flag = true;
    else if(" ".equals(s))
      flag = true;
*/
/*  ȣȭ Ҽ ־ ּó
    else if(s.length() < 1)
      flag = true;
*/
    return flag;
  }  
  

/**
  *ScpAgent ʱȭ<br/>
  *@param iniPath   Agent  fullpath
  *@return ڵ
  *@see com.penta.scpdb.ScpDbAgent#AgentFini()
 */
  public int 
  AgentInit( String iniPath )
  {
    int ret = 0;
    ret = AgentInitInternal(iniPath);

    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("AgentInit Error", ret);
    }

    return ret;
  }
      
  private int 
  AgentInitInternal( String iniPath )
  {
    if(checkNull(iniPath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if (nInit_ == 118)
    {
      return nInit_;
    }
    else
    {    
      synchronized (initBASCPSyncObj) 
      {
        int ret = _Agent_Init( iniPath.getBytes(), iniPath.getBytes().length );
        if(ret == 118)
        {
          nInit_ = 118; 
        }
        return ret;
      }
    }
  }
      
/**
  *ScpAgent ʱȭ<br/>
  *@param iniPath   Agent  fullpath
  *@return ڵ
  *@see com.penta.scpdb.ScpDbAgent#AgentFini()
 */
  public int 
  AgentReInit( String iniPath )
  {      
    if(checkNull(iniPath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    int ret = _Agent_ReInit( iniPath.getBytes(), iniPath.getBytes().length );
    return ret;       
  }
  
/**
  *ScpAgent <br/>  
  *@return ڵ
  *@see com.penta.scpdb.ScpDbAgent#AgentInit(String)
 */      
  public int 
  AgentFini()
  {    
    int ret = _Agent_Fini();
    if( ret == 0 ) nInit_ = -1;
    return ret;
  }

/**
  *Ϻȣȭ context 
  *@param agent_id SCP For DB Encryption Agent ID(scpdb_agent.ini  Ű   ߱޹ AgentŰ CN)
  *@param db_name Ϻȣȭ ϴ db ̸
  *@param db_owner Ϻȣȭ ϴ db 
  *@param table_name Ϻȣȭ ϴ db table ̸ 
  *@param column_name Ϻȣȭ ϴ db column ̸ 
  *@return  context
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDeleteContext(byte[])
 */
  public byte[] 
  AgentCipherCreateContext( 
    String agent_id,
    String db_name,
    String db_owner,
    String table_name,
    String column_name )
  {
    if(checkNull(agent_id))
    {
      throw new ScpDbAgentException("agent_id is null" );  
    }
    if(checkNull(db_name))
    {
      throw new ScpDbAgentException("db_name is null" );  
    }
    if(checkNull(db_owner))
    {
      throw new ScpDbAgentException("db_owner is null" );  
    }
    if(checkNull(table_name))
    {
      throw new ScpDbAgentException("table_name is null" );  
    }
    if(checkNull(column_name))
    {
      throw new ScpDbAgentException("column_name is null" );  
    }
    
    return _Agent_Cipher_CreateContext(
      agent_id.getBytes(), agent_id.getBytes().length, 
      db_name.getBytes(), db_name.getBytes().length,
      db_owner.getBytes(), db_owner.getBytes().length,
      table_name.getBytes(), table_name.getBytes().length,
      column_name.getBytes(), column_name.getBytes().length );
  }

  public byte[] 
  AgentCipherCreateContextServiceID( 
    String serviceID,
    String account )
  {
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null" );  
    }
    if(checkNull(account))
    {
      account = "";  
    }    
    return _Agent_Cipher_CreateContextServiceID(
      serviceID.getBytes(), serviceID.getBytes().length, 
      account.getBytes(), account.getBytes().length );
  }
  
/**
  *Ϻȣȭ context 
  *@param keyPath import  .scp Ű fullpath
  *@return  context
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherCreateContext(String, String, String, String, String)
 */
  public byte[] 
  AgentCipherCreateContextImportFile( String keyPath )
  {
    if(checkNull(keyPath))
    {
      throw new ScpDbAgentException("keyFilePath is null" );  
    }    
    
    return _Agent_Cipher_CreateContextImportFile(
      keyPath.getBytes(), keyPath.getBytes().length );
  }

/**
  *Ϻȣȭ context 
  *@param context AgentCipherCreateContext  context 
  *@return ڵ
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherCreateContext(String, String, String, String, String)
 */      
  public int AgentCipherDeleteContext( byte[] context )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    
    return _Agent_Cipher_DeleteContext(context, context.length);
  }
  
/**
  *Ϻȣȭ context  clear
    *@return ڵ
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDeleteContext(byte[] )
 */      
  public int AgentCipherClearAllContext()
  {
    return _Agent_Cipher_ClearAllContext();
  }
    
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecrypt(byte[], String)
 */
  public byte[] AgentCipherEncrypt( byte[] context, String plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      /*  Է  byte[] Ͻ ü ϰ   · Ѵ */
      /* new string( )  java.lang.NullPointerException  */
      /* byte[4]  ǹ̰  byte[0]  ϸ  byte[]  ڵ嵵 ϴ */
      return new byte[0]; 
    }
    
    return  _Agent_Cipher_Encrypt( context, context.length, plain.getBytes(), plain.getBytes().length );
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecrypt(byte[], byte[])
 */
  public byte[] AgentCipherEncrypt( byte[] context, byte[] plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return new byte[0];
    }
    
    return  _Agent_Cipher_Encrypt( context, context.length, plain, plain.length );
  }
    
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncrypt(byte[], String)
 */
  public byte[] AgentCipherDecrypt( byte[] context, String cipher )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );  
      return new byte[0];
    }
    
    return  _Agent_Cipher_Decrypt( context, context.length, cipher.getBytes(), cipher.getBytes().length );
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncrypt(byte[], byte[])
 */
  public byte[] AgentCipherDecrypt( byte[] context, byte[] cipher )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );
      return new byte[0];  
    }
    
    return  _Agent_Cipher_Decrypt( context, context.length, cipher, cipher.length );
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptString(byte[], String)
 */
  public String AgentCipherEncryptString( byte[] context, String plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return "";
    }   
    return  _Agent_Cipher_Encrypt_UTF8( context, context.length, plain);
  }

/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptString(byte[], String, String)
 */
  public String AgentCipherEncryptString( byte[] context, String plain, String charset)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Encrypt_UTF8( context, context.length, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Agent_Cipher_Encrypt_EUCKR( context, context.length, plain);
    }  
    else
    {
      return _Agent_Cipher_Encrypt_UTF8( context, context.length, plain);
    }
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptString(byte[], String)
 */
  public String AgentCipherDecryptString( byte[] context, String cipher )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );
      return "";  
    }    
    return  _Agent_Cipher_Decrypt_UTF8( context, context.length, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptString(byte[], String, String)
 */
  public String AgentCipherDecryptString( byte[] context, String cipher, String charset)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );  
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Decrypt_UTF8( context, context.length, cipher);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Agent_Cipher_Decrypt_EUCKR( context, context.length, cipher);
    }
    else
    {
      return _Agent_Cipher_Decrypt_UTF8( context, context.length, cipher);
    }
  }
  
  public String AgentCipherEncryptStringCP( byte[] context, String plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return "";
    }   
    return  _Agent_Cipher_Encrypt_CP_UTF8( context, context.length, plain);
  }

/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptString(byte[], String, String)
 */
  public String AgentCipherEncryptStringCP( byte[] context, String plain, String charset)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Encrypt_CP_UTF8( context, context.length, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Agent_Cipher_Encrypt_CP_EUCKR( context, context.length, plain);
    }  
    else
    {
      return _Agent_Cipher_Encrypt_CP_UTF8( context, context.length, plain);
    }
  }
  
  public String AgentCipherDecryptStringCP( byte[] context, String cipher )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );
      return "";  
    }    
    return  _Agent_Cipher_Decrypt_CP_UTF8( context, context.length, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptString(byte[], String, String)
 */
  public String AgentCipherDecryptStringCP( byte[] context, String cipher, String charset)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );  
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Decrypt_CP_UTF8( context, context.length, cipher);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Agent_Cipher_Decrypt_CP_EUCKR( context, context.length, cipher);
    }
    else
    {
      return _Agent_Cipher_Decrypt_CP_UTF8( context, context.length, cipher);
    }
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptStringB64(byte[], String)
 */
  public String AgentCipherEncryptStringB64( byte[] context, String plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return "";
    }
    return  _Agent_Cipher_Encrypt_UTF8_B64( context, context.length, plain);
  }

/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptStringB64(byte[], String, String)
 */
  public String AgentCipherEncryptStringB64( byte[] context, String plain, String charset)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Encrypt_UTF8_B64( context, context.length, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Agent_Cipher_Encrypt_EUCKR_B64( context, context.length, plain);
    }  
    else
    {
      return _Agent_Cipher_Encrypt_UTF8_B64( context, context.length, plain);
    }
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptStringB64(byte[], String)
 */
  public String AgentCipherDecryptStringB64( byte[] context, String cipher )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );
      return "";  
    }    
    return  _Agent_Cipher_Decrypt_UTF8_B64( context, context.length, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptString(byte[], String, String)
 */
  public String AgentCipherDecryptStringB64( byte[] context, String cipher, String charset)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );  
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Decrypt_UTF8_B64( context, context.length, cipher);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Agent_Cipher_Decrypt_EUCKR_B64( context, context.length, cipher);
    }
    else
    {
      return _Agent_Cipher_Decrypt_UTF8_B64( context, context.length, cipher);
    }
  }

 /**
  *DB Column ε ȣȭ
  *@param context "IX" Ǵ AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷   
 */
  public byte[] AgentCipherIndex( byte[] context, String plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return new byte[0]; 
    }
    
    return  _Agent_Cipher_Index( context, context.length, plain.getBytes(), plain.getBytes().length );
  }
  
 /**
  *DB Column ε ȣȭ
  *@param context "IX" Ǵ AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷   
 */
  public byte[] AgentCipherIndex( byte[] context, byte[] plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return new byte[0];
    }
    
    return  _Agent_Cipher_Index( context, context.length, plain, plain.length );
  }
  
 /**
  *DB Column ε ȣȭ
  *@param context "IX" Ǵ AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷   
 */
  public String AgentCipherIndexString( byte[] context, String plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return "";
    }   
    return  _Agent_Cipher_Index_UTF8( context, context.length, plain);
  }

/**
  *DB Column ε ȣȭ
  *@param context "IX" Ǵ AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷   
 */
  public String AgentCipherIndexString( byte[] context, String plain, String charset)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Index_UTF8( context, context.length, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Agent_Cipher_Index_EUCKR( context, context.length, plain);
    }  
    else
    {
      return _Agent_Cipher_Index_UTF8( context, context.length, plain);
    }
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param number ȣȭ number ÷   
  *@return ȣȭ number ÷ 
 */
  public String AgentCipherEncryptNumber( byte[] context, String number, String type )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    // checkNull
    
    return  _Agent_Cipher_Encrypt_Number( context, context.length, number, type);
  }
   
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ number ÷   
  *@return ȣȭ number ÷ 
 */
  public String AgentCipherDecryptNumber( byte[] context, String cipher, String type)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    // checkNull
    
    return  _Agent_Cipher_Decrypt_Number( context, context.length, cipher, type);
  }

/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param number ȣȭ number ÷   
  *@return ȣȭ number ÷ 
 */
  public String AgentCipherEncryptInt( byte[] context, int number, String type )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    
    return  _Agent_Cipher_Encrypt_Int( context, context.length, number, type);
  }

/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ number ÷   
  *@return ȣȭ number ÷ 
 */
  public int AgentCipherDecryptInt( byte[] context, String cipher, String type)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      throw new ScpDbAgentException("cipher is null" );        
    }
    
    return  _Agent_Cipher_Decrypt_Int( context, context.length, cipher, type);
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param number ȣȭ number ÷   
  *@return ȣȭ number ÷ 
 */
  public String AgentCipherEncryptNumberB64( byte[] context, String number, String type )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    // checkNull
    
    return  _Agent_Cipher_Encrypt_Number_B64( context, context.length, number, type);
  }
   
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ number ÷   
  *@return ȣȭ number ÷ 
 */
  public String AgentCipherDecryptNumberB64( byte[] context, String cipher, String type)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    // checkNull
    
    return  _Agent_Cipher_Decrypt_Number_B64( context, context.length, cipher, type);
  }  
  
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param number ȣȭ number ÷   
  *@return ȣȭ number ÷ 
 */
  public String AgentCipherEncryptIntB64( byte[] context, int number, String type )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    
    return  _Agent_Cipher_Encrypt_Int_B64( context, context.length, number, type);
  }

/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ number ÷   
  *@return ȣȭ number ÷ 
 */
  public int AgentCipherDecryptIntB64( byte[] context, String cipher, String type)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      throw new ScpDbAgentException("cipher is null" );        
    }
    
    return  _Agent_Cipher_Decrypt_Int_B64( context, context.length, cipher, type);
  }

  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptB64(byte[], String)
 */
  public byte[] AgentCipherEncryptB64( byte[] context, String plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
/*    
      if ( plain != null && plain.length() == 0)
      {
        byte[] bytePlain = {(byte)0x00};
        return  _Agent_Cipher_Encrypt_B64( context, context.length, bytePlain, bytePlain.length );
      }
*/      
      //throw new ScpDbAgentException("plain is null" );  
      /*  Է  byte[] Ͻ ü ϰ   · Ѵ */
      /* new string( )  java.lang.NullPointerException  */
      /* byte[4]  ǹ̰  byte[0]  ϸ  byte[]  ڵ嵵 ϴ */
      return new byte[0]; 
    }
    
    return  _Agent_Cipher_Encrypt_B64( context, context.length, plain.getBytes(), plain.getBytes().length );
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptB64(byte[], byte[])
 */
  public byte[] AgentCipherEncryptB64( byte[] context, byte[] plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
/*
      if ( plain != null && plain.length == 0)
      {
        byte[] bytePlain = {(byte)0x00};
        return  _Agent_Cipher_Encrypt_B64( context, context.length, bytePlain, bytePlain.length );
      }
*/
      //throw new ScpDbAgentException("plain is null" );  
      return new byte[0];
    }
    
    return  _Agent_Cipher_Encrypt_B64( context, context.length, plain, plain.length );
  }
    
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptB64(byte[], String)
 */
  public byte[] AgentCipherDecryptB64( byte[] context, String cipher )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );  
      return new byte[0];
    }
    
    byte[] out = _Agent_Cipher_Decrypt_B64( context, context.length, cipher.getBytes(), cipher.getBytes().length );
//    if ( out != null && out[0] == 0x00 && out.length == 1 )
//      return new byte[0];
//    else
      return out;
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptB64(byte[], byte[])
 */
  public byte[] AgentCipherDecryptB64( byte[] context, byte[] cipher )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );
      return new byte[0];  
    }
    
    byte[] out = _Agent_Cipher_Decrypt_B64( context, context.length, cipher, cipher.length );
//    if ( out != null && out[0] == 0x00 && out.length == 1 )
//      return new byte[0];
//    else
      return out;
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptRaw(byte[], byte[])
 */
  public byte[] AgentCipherEncryptRaw( byte[] context, byte[] plain )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return new byte[0];
    }    
    return  _Agent_Cipher_Encrypt_Raw( context, context.length, plain, plain.length );
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecryptRaw(byte[], byte[])
 */
  public byte[] AgentCipherEncryptRaw( byte[] context, byte[] plain, int len )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(plain))
    {
      //throw new ScpDbAgentException("plain is null" );  
      return new byte[0];
    }    
    return  _Agent_Cipher_Encrypt_Raw( context, context.length, plain, len );
  }  
    
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptRaw(byte[], String)
 */
  public byte[] AgentCipherDecryptRaw( byte[] context, byte[] cipher )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );  
      return new byte[0];
    }
    return _Agent_Cipher_Decrypt_Raw( context, context.length, cipher, cipher.length );
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncryptRaw(byte[], String)
 */
  public byte[] AgentCipherDecryptRaw( byte[] context, byte[] cipher, int len )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(cipher))
    {
      //throw new ScpDbAgentException("cipher is null" );  
      return new byte[0];
    }
    return _Agent_Cipher_Decrypt_Raw( context, context.length, cipher, len );
  }
  
/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherDecrypt(byte[], String)
 */
  public int AgentCipherEncryptFilePath( byte[] context, String inFileName, String outFileName )
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(inFileName))
    {
      return -1; 
    }
    if(checkNull(outFileName))
    {
      return -1; 
    }
    
    return  _Agent_Cipher_EncryptFilePath( context, context.length, inFileName.getBytes(), inFileName.getBytes().length, outFileName.getBytes(), outFileName.getBytes().length );
  }

/**
  *DB Column ȣȭ
  *@param context AgentCipherCreateContext  context 
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherEncrypt(byte[], String)
 */
  public int AgentCipherDecryptFilePath( byte[] context, String inFileName, String outFileName)
  {
    if(checkNull(context))
    {
      throw new ScpDbAgentException("context is null" );  
    }
    if(checkNull(inFileName))
    {
      return -1; 
    }
    if(checkNull(outFileName))
    {
      return -1; 
    }
    
    return  _Agent_Cipher_DecryptFilePath( context, context.length, inFileName.getBytes(), inFileName.getBytes().length, outFileName.getBytes(), outFileName.getBytes().length );
  }
  
  
/**
  *HASH 
  *@param hashId 
  *@param in hash   
  *@return hash 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherHashBase64(int, byte[])
 */
  public byte[] AgentCipherHashBase64( int hashId, byte[] in )
  {
/*  
    if(checkNull(hashId))
    {
      throw new ScpDbAgentException("hashId is null" );  
    }
*/    
    if(checkNull(in))
    {
      //throw new ScpDbAgentException("hash in is null" );  
      return new byte[0];
    }
    
    return  _Agent_Cipher_Hash_Base64( hashId, in, in.length );
  }
  
  public byte[] AgentCipherHashBase64( int hashId, String in )
  {
/*    
    if(checkNull(hashId))
    {
      throw new ScpDbAgentException("hashId is null" );  
    }
*/    
    if(checkNull(in))
    {
      //throw new ScpDbAgentException("hash in is null" );  
      return new byte[0];
    }
    
    return  _Agent_Cipher_Hash_Base64( hashId, in.getBytes(), in.getBytes().length );
  }

  public byte[] AgentCipherHashB64( int hashId, byte[] in )
  {
    return AgentCipherHashBase64(hashId, in);
  }

  public byte[] AgentCipherHashB64( int hashId, String in )
  {
    return AgentCipherHashBase64(hashId, in);
  }

/**
  *HASH 
  *@param hashId 
  *@param in hash   
  *@return hash 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherHash(int, byte[])
 */
  public byte[] AgentCipherHash( int hashId, byte[] in )
  {
/*  
    if(checkNull(hashId))
    {
      throw new ScpDbAgentException("hashId is null" );  
    }
*/    
    if(checkNull(in))
    {
      //throw new ScpDbAgentException("hash in is null" );  
      return new byte[0];
    }
    
    return  _Agent_Cipher_Hash( hashId, in, in.length );
  }
  
  public byte[] AgentCipherHash( int hashId, String in )
  {
/*    
    if(checkNull(hashId))
    {
      throw new ScpDbAgentException("hashId is null" );  
    }
*/    
    if(checkNull(in))
    {
      //throw new ScpDbAgentException("hash in is null" );  
      return new byte[0];
    }
    
    return  _Agent_Cipher_Hash( hashId, in.getBytes(), in.getBytes().length );
  }
  
  public String AgentCipherHashString( int hashId, String in )
  {
    if(checkNull(in))
    {      
      return "";
    }   
    return  _Agent_Cipher_Hash_UTF8( hashId, in);
  }

  public String AgentCipherHashString( int hashId, String in, String charset)
  {
    if(checkNull(in))
    {
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Hash_UTF8( hashId, in);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Agent_Cipher_Hash_EUCKR( hashId, in);
    }  
    else
    {
      return _Agent_Cipher_Hash_UTF8( hashId, in);
    }
  }
  
  public String AgentCipherHashStringB64( int hashId, String in )
  {
    if(checkNull(in))
    {      
      return "";
    }   
    return  _Agent_Cipher_Hash_UTF8_B64( hashId, in);
  }

  public String AgentCipherHashStringB64( int hashId, String in, String charset)
  {
    if(checkNull(in))
    {
      return "";
    }       
    if(checkNull(charset))
    {
      return _Agent_Cipher_Hash_UTF8_B64( hashId, in);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Agent_Cipher_Hash_EUCKR_B64( hashId, in);
    }  
    else
    {
      return _Agent_Cipher_Hash_UTF8_B64( hashId, in);
    }
  }
  
  
  public String ScpHashB64( String iniFilePath, int hashId, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpHashB64 AgentInit Error", ret);
    }
    
    return  AgentCipherHashStringB64( hashId, plain);
  }
  
  public String ScpHashB64( String iniFilePath, int hashId, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }    
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpHashB64 AgentInit Error", ret);
    }   
    
    return  AgentCipherHashStringB64( hashId, plain, charset);
  }
  
  public byte[] ScpHashB64( String iniFilePath, int hashId, byte[] plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }    
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpHashB64 AgentInit Error", ret);
    }

    if(checkNull(plain))
    {
      return new byte[0];
    }      
    
    return  _SCP_Hash_B64_Byte( iniFilePath, hashId, plain);
  }
  
    
/**
  *HexToB64 
  *@param Hexa String  
  *@return Base64Encode 
  *@see com.penta.scpdb.ScpDbAgent#AgentHexToB64(byte[])
 */
  public byte[] AgentHexToB64( byte[] in )
  {
    if(checkNull(in))
    {
      //throw new ScpDbAgentException("hash in is null" );  
      return new byte[0];
    }
    
    return  _Agent_HexToB64( in, in.length );
  }
  
/**
  *HexToB64 
  *@param Hexa String  
  *@return Base64Encode 
  *@see com.penta.scpdb.ScpDbAgent#AgentHexToB64(String)
 */
  public byte[] AgentHexToB64( String in )
  {
    if(checkNull(in))
    {
      //throw new ScpDbAgentException("hash in is null" );  
      return new byte[0];
    }
    
    return  _Agent_HexToB64( in.getBytes(), in.getBytes().length );
  }
  
/**
  *B64ToHex 
  *@param Base64Encode 
  *@return Hexa String  
  *@see com.penta.scpdb.ScpDbAgent#AgentB64ToHex(byte[])
 */
  public byte[] AgentB64ToHex( byte[] in )
  {
    if(checkNull(in))
    {
      //throw new ScpDbAgentException("hash in is null" );  
      return new byte[0];
    }
    
    return  _Agent_B64ToHex( in, in.length );
  }
  
/**
  *B64ToHex 
  *@param Base64Encode 
  *@return Hexa String  
  *@see com.penta.scpdb.ScpDbAgent#AgentB64ToHex(String)
 */
  public byte[] AgentB64ToHex( String in )
  {
    if(checkNull(in))
    {
      //throw new ScpDbAgentException("hash in is null" );  
      return new byte[0];
    }
    
    return  _Agent_B64ToHex( in.getBytes(), in.getBytes().length );
  }
  
/**
  *INIT+HASH 
  
  *@param iniPath Agent  fullpath 
  *@param hashId
  *@param hash   
  *@return hash 
  *@see com.penta.scpdb.ScpDbAgent#AgentCipherHashBase64(int, byte[])
 */
 /*
  public static byte[] AgentCipherInitHashBase64( String iniPath, String hashId, String in)
  {
    if(checkNull(iniPath))
    {
      throw new ScpDbAgentException("iniFilePath is null" );  
    }
    if(checkNull(hashId))
    {
      throw new ScpDbAgentException("hashId is null" );  
    }
    if(checkNull(in))
    {
      return new byte[0]; 
    }  
    
    return _Agent_Cipher_Init_Hash_Base64(iniPath.getBytes(), 
      iniPath.getBytes().length,
      hashId.getBytes(),
      hashId.getBytes().length,
      in.getBytes(),
      in.getBytes().length);
  }
 */   
/**
  *INIT+CREATE+ENCRYPT 
  
  *@param iniPath Agent  fullpath 
  *@param keyPath import key  fullpath
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
 */
/* 
  public static byte[] AgentCipherInitCreateContextImportFileEncrypt( String iniPath, String keyPath, String plain)
  {
    if(checkNull(iniPath))
    {
      throw new ScpDbAgentException("iniFilePath is null" );  
    }
    if(checkNull(keyPath))
    {
      throw new ScpDbAgentException("keyPath is null" );  
    }
    if(checkNull(plain))
    {
      return new byte[0]; 
    }  
      
    return _Agent_Cipher_Init_CreateContextImportFile_Encrypt(iniPath.getBytes(), 
      iniPath.getBytes().length,
      keyPath.getBytes(),
      keyPath.getBytes().length,
      plain.getBytes(),
      plain.getBytes().length);
  }
*/       
/**
  *INIT+CREATE+DECRYPT 
  
  *@param iniPath Agent  fullpath 
  *@param keyPath import key  fullpath
  *@param enc ȣȭ ÷   
  *@return ȣȭ ÷ 
 */
/* 
  public static byte[] AgentCipherInitCreateContextImportFileDecrypt( String iniPath, String keyPath, String enc)
  {
    if(checkNull(iniPath))
    {
      throw new ScpDbAgentException("iniFilePath is null" );  
    }
    if(checkNull(keyPath))
    {
      throw new ScpDbAgentException("keyPath is null" );  
    }
    if(checkNull(enc))
    {
      return new byte[0]; 
    }
    
    return _Agent_Cipher_Init_CreateContextImportFile_Decrypt(iniPath.getBytes(), 
      iniPath.getBytes().length,
      keyPath.getBytes(),
      keyPath.getBytes().length,
      enc.getBytes(),
      enc.getBytes().length);
  }
*/

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@return ȣȭ context  
 */
  public String ScpExportContext( String iniFilePath, String iniKeyName)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpExportContext AgentInit Error", ret);
    }
  
    return  _Scp_Export_Context( iniFilePath, iniKeyName);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@return ȣȭ context  
 */
  public String ScpExportContextServiceID( String iniFilePath, String serviceID)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpExportContextServiceID AgentInit Error", ret);
    }
  
    return  _Scp_Export_Context_ServiceID( iniFilePath, serviceID);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@return ȣȭ context  
 */
  public String ScpExportKey( String iniFilePath, String iniKeyName, String account)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }
    if(checkNull(account))
    {
      account = "";  
    } 
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpExportKey AgentInit Error", ret);
    }
  
    return  _Scp_Export_Key( iniFilePath, iniKeyName, account);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@return ȣȭ Ǵ Ű HexaString   
 */
  public String ScpExportKeyServiceID( String iniFilePath, String serviceID, String account)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }
    if(checkNull(account))
    {
      account = "";  
    } 
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpExportKeyServiceID AgentInit Error", ret);
    }
  
    return  _Scp_Export_Key_ServiceID( iniFilePath, serviceID, account);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String)
 */
  public String ScpEncStr( String iniFilePath, String iniKeyName, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncStr AgentInit Error", ret);
    }
  
    return  _Scp_Enc_Str_UTF8( iniFilePath, iniKeyName, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String, String)
 */
  public String ScpEncStr( String iniFilePath, String iniKeyName, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncStr AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Enc_Str_UTF8( iniFilePath, iniKeyName, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Enc_Str_EUCKR( iniFilePath, iniKeyName, plain);
    }  
    else
    {
      return _Scp_Enc_Str_UTF8( iniFilePath, iniKeyName, plain);
    }
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncStr(String, String, String)
 */  
  public String ScpDecStr( String iniFilePath, String iniKeyName, String cipher)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(cipher))
    {
      return "";
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecStr AgentInit Error", ret);
    }
  
    return  _Scp_Dec_Str_UTF8( iniFilePath, iniKeyName, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncStr(String, String, String, String)
 */ 
  public String ScpDecStr( String iniFilePath, String iniKeyName, String cipher, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(cipher))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecStr AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Dec_Str_UTF8( iniFilePath, iniKeyName, cipher);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Scp_Dec_Str_EUCKR( iniFilePath, iniKeyName, cipher);    
    }
    else
    {
      return _Scp_Dec_Str_UTF8( iniFilePath, iniKeyName, cipher);
    }
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecB64(String, String, String)
 */
  public String ScpEncB64( String iniFilePath, String iniKeyName, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncB64 AgentInit Error", ret);
    }
  
    return  _Scp_Enc_B64_UTF8( iniFilePath, iniKeyName, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecB64(String, String, String, String)
 */
  public String ScpEncB64( String iniFilePath, String iniKeyName, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncB64 AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Enc_B64_UTF8( iniFilePath, iniKeyName, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Enc_B64_EUCKR( iniFilePath, iniKeyName, plain);
    }  
    else
    {
      return _Scp_Enc_B64_UTF8( iniFilePath, iniKeyName, plain);
    }
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncB64(String, String, String)
 */  
  public String ScpDecB64( String iniFilePath, String iniKeyName, String cipher)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(cipher))
    {
      return "";
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecB64 AgentInit Error", ret);
    }
  
    return  _Scp_Dec_B64_UTF8( iniFilePath, iniKeyName, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncB64(String, String, String, String)
 */ 
  public String ScpDecB64( String iniFilePath, String iniKeyName, String cipher, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(cipher))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecB64 AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Dec_B64_UTF8( iniFilePath, iniKeyName, cipher);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Scp_Dec_B64_EUCKR( iniFilePath, iniKeyName, cipher);    
    }
    else
    {
      return _Scp_Dec_B64_UTF8( iniFilePath, iniKeyName, cipher);
    }
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param inFilePath ȣȭ ϸ
  *@param outFilePath ȣȭ ϸ  
  *@return ڵ  
 */
  public int ScpEncFile( String iniFilePath, String iniKeyName, String inFilePath, String outFilePath)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }
    if(checkNull(inFilePath))
    {
      throw new ScpDbAgentException("inFilePath is null");  
    }  
    if(checkNull(outFilePath))
    {
      throw new ScpDbAgentException("outFilePath is null");  
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncFile AgentInit Error", ret);
    }
  
    if ( isWindows )
    {
      try
      {
        return _Scp_Enc_File(iniFilePath, iniKeyName, inFilePath.getBytes("UTF-16LE"), outFilePath.getBytes("UTF-16LE"));
      }
      catch (UnsupportedEncodingException e1)
      {
        throw new ScpDbAgentException("getBytes(UTF-16LE) is fail");  
      }
    }
  
    return _Scp_Enc_File(iniFilePath, iniKeyName, inFilePath.getBytes(), outFilePath.getBytes());
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param inFilePath ȣȭ ϸ
  *@param outFilePath ȣȭ ϸ 
  *@return ڵ
 */  
  public int ScpDecFile( String iniFilePath, String iniKeyName, String inFilePath, String outFilePath)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(inFilePath))
    {
      throw new ScpDbAgentException("inFilePath is null");  
    }  
    if(checkNull(outFilePath))
    {
      throw new ScpDbAgentException("outFilePath is null");  
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecFile AgentInit Error", ret);
    }
  
    if ( isWindows )
    {
      try
      {
        return  _Scp_Dec_File( iniFilePath, iniKeyName, inFilePath.getBytes("UTF-16LE"), outFilePath.getBytes("UTF-16LE"));
      }
      catch (UnsupportedEncodingException e1)
      {
        throw new ScpDbAgentException("getBytes(UTF-16LE) is fail ");  
      }
    }

    return  _Scp_Dec_File( iniFilePath, iniKeyName, inFilePath.getBytes(), outFilePath.getBytes());
  }
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param inFilePath ȣȭ ϸ
  *@param outFilePath ȣȭ ϸ  
  *@return ڵ  
 */
  public int ScpEncFile( String iniFilePath, String iniKeyName, byte[] inFilePath, byte[] outFilePath)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }
    if(checkNull(inFilePath))
    {
      throw new ScpDbAgentException("inFilePath is null");  
    }  
    if(checkNull(outFilePath))
    {
      throw new ScpDbAgentException("outFilePath is null");  
    }

  return _Scp_Enc_File(iniFilePath, iniKeyName, inFilePath, outFilePath);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param inFilePath ȣȭ ϸ
  *@param outFilePath ȣȭ ϸ 
  *@return ڵ
 */  
  public int ScpDecFile( String iniFilePath, String iniKeyName, byte[] inFilePath, byte[] outFilePath)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(inFilePath))
    {
      throw new ScpDbAgentException("inFilePath is null");  
    }  
    if(checkNull(outFilePath))
    {
      throw new ScpDbAgentException("outFilePath is null");  
    }
    
    return  _Scp_Dec_File( iniFilePath, iniKeyName, inFilePath, outFilePath);
  }

  /**
   *DB Column ȣȭ
   *@param iniFilePath Agent  fullpath 
   *@param iniKeyName Agent Ͽ ϴ keyName  
   *@param plain ȣȭ ÷   
   *@return ȣȭ ÷ 
   *@see com.penta.scpdb.ScpDbAgent#ScpDecB64(String, String, String)
  */
  public String ScpEncRRNB64( String iniFilePath, String iniKeyName, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    } 
    if(checkNull(plain))
    {
      return "";
    }
   
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncRRNB64 AgentInit Error", ret);
    }
  
    return _Scp_Enc_RRN_B64_UTF8( iniFilePath, iniKeyName, plain);
  }
   
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecB64(String, String, String, String)
 */
  public String ScpEncRRNB64( String iniFilePath, String iniKeyName, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncRRNB64 AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Enc_RRN_B64_UTF8( iniFilePath, iniKeyName, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Enc_RRN_B64_UTF8( iniFilePath, iniKeyName, plain);
    }  
    else
    {
      return _Scp_Enc_RRN_B64_UTF8( iniFilePath, iniKeyName, plain);
    }
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, byte[])
 */
  public byte[] ScpEncStr(String iniFilePath, String iniKeyName, byte[] plain)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncStr AgentInit Error", ret);
    }
  
    return _Scp_Enc_Str_Byte(iniFilePath, iniKeyName, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, byte[])
 */  
  public byte[] ScpDecStr(String iniFilePath, String iniKeyName, byte[] cipher)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(cipher))
    {
      return new byte[0];
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecStr AgentInit Error", ret);
    }
  
    return _Scp_Dec_Str_Byte(iniFilePath, iniKeyName, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecB64(String, String, byte[])
 */  
  public byte[] ScpEncB64(String iniFilePath, String iniKeyName, byte[] plain)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncB64 AgentInit Error", ret);
    }
  
    return _Scp_Enc_B64_Byte(iniFilePath, iniKeyName, plain);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncB64(String, String, byte[])
 */  
  public byte[] ScpDecB64(String iniFilePath, String iniKeyName, byte[] cipher)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(cipher))
    {
      return new byte[0];
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecB64 AgentInit Error", ret);
    }
  
    return _Scp_Dec_B64_Byte(iniFilePath, iniKeyName, cipher);
  }
  
  public String ScpHashStr( String iniFilePath, int hashId, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpHashStr AgentInit Error", ret);
    }
    
    return  AgentCipherHashString( hashId, plain);
  }
  
  public String ScpHashStr( String iniFilePath, int hashId, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }    
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpHashStr AgentInit Error", ret);
    }   
    
    return  AgentCipherHashString( hashId, plain, charset);
  }
  
  public byte[] ScpHashStr( String iniFilePath, int hashId, byte[] plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }    
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpHashStr AgentInit Error", ret);
    }

    if(checkNull(plain))
    {
      return new byte[0];
    }      
    
    return  _SCP_Hash_Str_Byte( iniFilePath, hashId, plain);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String)
 */
  public String ScpKeyHashStr( String iniFilePath, String iniKeyName, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
      
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
    
    if(checkNull(plain))
    {
      return "";
    }
  
    return  _Scp_Key_Hash_Str_UTF8( iniFilePath, iniKeyName, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷ 
  *@param charset ȣȭ   ĳͼ  
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String, String)
 */
  public String ScpKeyHashStr( String iniFilePath, String iniKeyName, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
    
    if(checkNull(plain))
    {
      return "";
    }
  
    if(checkNull(charset))
    {
      return _Scp_Key_Hash_Str_UTF8( iniFilePath, iniKeyName, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Key_Hash_Str_EUCKR( iniFilePath, iniKeyName, plain);
    }  
    else
    {
      return _Scp_Key_Hash_Str_UTF8( iniFilePath, iniKeyName, plain);
    }
  }
  
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, byte[])
 */
  public byte[] ScpKeyHashStr(String iniFilePath, String iniKeyName, byte[] plain)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }    

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
    
    if (checkNull(plain))
    {
      return new byte[0];
    }
  
    return _Scp_Key_Hash_Str_Byte(iniFilePath, iniKeyName, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param inFilePath ȣȭ  Ÿ
  *@return ȣȭ  
 */
  public byte[] ScpEncFileBuf( String iniFilePath, String iniKeyName, byte[] inFileData)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }
    if(checkNull(inFileData))
    {
      throw new ScpDbAgentException("inFileData is null");  
    }  

  return _Scp_Enc_File_Buf(iniFilePath, iniKeyName, inFileData);
  }
  
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String)
 */
  public String ScpKeyHashB64( String iniFilePath, String iniKeyName, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }      
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
    
    if(checkNull(plain))
    {
      return "";
    }
  
    return  _Scp_Key_Hash_B64_UTF8( iniFilePath, iniKeyName, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String, String)
 */
  public String ScpKeyHashB64( String iniFilePath, String iniKeyName, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
      
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
    
    if(checkNull(plain))
    {
      return "";
    }
  
    if(checkNull(charset))
    {
      return _Scp_Key_Hash_B64_UTF8( iniFilePath, iniKeyName, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Key_Hash_B64_EUCKR( iniFilePath, iniKeyName, plain);
    }  
    else
    {
      return _Scp_Key_Hash_B64_UTF8( iniFilePath, iniKeyName, plain);
    }
  }
  
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, byte[])
 */
   public byte[] ScpKeyHashB64(String iniFilePath, String iniKeyName, byte[] plain)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
    
    if (checkNull(plain))
    {
      return new byte[0];
    }
  
    return _Scp_Key_Hash_B64_Byte(iniFilePath, iniKeyName, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param iniKeyName Agent Ͽ ϴ keyName  
  *@param inFilePath ȣȭ  
  *@return ȣȭ  
 */  
  public byte[] ScpDecFileBuf( String iniFilePath, String iniKeyName, byte[] inFileData)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");  
    }  
    if(checkNull(inFileData))
    {
      throw new ScpDbAgentException("inFileData is null");  
    }  
    
    return  _Scp_Dec_File_Buf( iniFilePath, iniKeyName, inFileData);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncStrServiceID(String, String, String)
 */
  public String ScpEncStrServiceID( String iniFilePath, String serviceID, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncStrServiceID AgentInit Error", ret);
    }
  
    return  _Scp_Enc_Str_ServiceID_UTF8( iniFilePath, serviceID, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncStrServiceID(String, String, String, String)
 */
  public String ScpEncStrServiceID( String iniFilePath, String serviceID, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncStrServiceID AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Enc_Str_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Enc_Str_ServiceID_EUCKR( iniFilePath, serviceID, plain);
    }  
    else
    {
      return _Scp_Enc_Str_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStrServiceID(String, String, String)
 */  
  public String ScpDecStrServiceID( String iniFilePath, String serviceID, String cipher)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(cipher))
    {
      return "";
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecStrServiceID AgentInit Error", ret);
    }
  
    return  _Scp_Dec_Str_ServiceID_UTF8( iniFilePath, serviceID, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStrServiceID(String, String, String, String)
 */ 
  public String ScpDecStrServiceID( String iniFilePath, String serviceID, String cipher, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(cipher))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecStrServiceID AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Dec_Str_ServiceID_UTF8( iniFilePath, serviceID, cipher);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Scp_Dec_Str_ServiceID_EUCKR( iniFilePath, serviceID, cipher);    
    }
    else
    {
      return _Scp_Dec_Str_ServiceID_UTF8( iniFilePath, serviceID, cipher);
    }
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncB64ServiceID(String, String, String)
 */
  public String ScpEncB64ServiceID( String iniFilePath, String serviceID, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncB64ServiceID AgentInit Error", ret);
    }
  
    return  _Scp_Enc_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncB64ServiceID(String, String, String, String)
 */
  public String ScpEncB64ServiceID( String iniFilePath, String serviceID, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncB64ServiceID AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Enc_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Enc_B64_ServiceID_EUCKR( iniFilePath, serviceID, plain);
    }  
    else
    {
      return _Scp_Enc_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecB64ServiceID(String, String, String)
 */  
  public String ScpDecB64ServiceID( String iniFilePath, String serviceID, String cipher)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(cipher))
    {
      return "";
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecB64ServiceID AgentInit Error", ret);
    }
  
    return  _Scp_Dec_B64_ServiceID_UTF8( iniFilePath, serviceID, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecB64ServiceID(String, String, String, String)
 */ 
  public String ScpDecB64ServiceID( String iniFilePath, String serviceID, String cipher, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(cipher))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecB64ServiceID AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Dec_B64_ServiceID_UTF8( iniFilePath, serviceID, cipher);
    }
    
    if("EUC-KR".equals(charset))
    {
      return  _Scp_Dec_B64_ServiceID_EUCKR( iniFilePath, serviceID, cipher);    
    }
    else
    {
      return _Scp_Dec_B64_ServiceID_UTF8( iniFilePath, serviceID, cipher);
    }
  }

  /**
   *DB Column ȣȭ
   *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
   *@param plain ȣȭ ÷   
   *@return ȣȭ ÷ 
   *@see com.penta.scpdb.ScpDbAgent#ScpEncRRNB64ServiceID(String, String, String)
  */
  public String ScpEncRRNB64ServiceID( String iniFilePath, String serviceID, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    } 
    if(checkNull(plain))
    {
      return "";
    }
   
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncRRNB64ServiceID AgentInit Error", ret);
    }
  
    return _Scp_Enc_RRN_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
  }
   
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncRRNB64ServiceID(String, String, String, String)
 */
  public String ScpEncRRNB64ServiceID( String iniFilePath, String serviceID, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncRRNB64ServiceID AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Enc_RRN_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Enc_RRN_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }  
    else
    {
      return _Scp_Enc_RRN_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }
  }
  
  
  /**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String)
 */
  public String ScpKeyHashStrServiceID( String iniFilePath, String serviceID, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashB64ServiceID AgentInit Error", ret);
    }
  
    return  _Scp_Key_Hash_Str_ServiceID_UTF8( iniFilePath, serviceID, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String, String)
 */
  public String ScpKeyHashStrServiceID( String iniFilePath, String serviceID, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Key_Hash_B64_UTF8( iniFilePath, serviceID, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Key_Hash_Str_ServiceID_EUCKR( iniFilePath, serviceID, plain);
    }  
    else
    {
      return _Scp_Key_Hash_Str_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }
  }
  
  
  
  /**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String)
 */
  public String ScpKeyHashB64ServiceID( String iniFilePath, String serviceID, String plain)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashB64ServiceID AgentInit Error", ret);
    }
  
    return  _Scp_Key_Hash_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, String, String)
 */
  public String ScpKeyHashB64ServiceID( String iniFilePath, String serviceID, String plain, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    }
    if(checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");  
    }  
    if(checkNull(plain))
    {
      return "";
    }
  
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
  
    if(checkNull(charset))
    {
      return _Scp_Key_Hash_B64_UTF8( iniFilePath, serviceID, plain);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Key_Hash_B64_ServiceID_EUCKR( iniFilePath, serviceID, plain);
    }  
    else
    {
      return _Scp_Key_Hash_B64_ServiceID_UTF8( iniFilePath, serviceID, plain);
    }
  }
  

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncStrServiceID(String, String, byte[])
 */
   public byte[] ScpEncStrServiceID(String iniFilePath, String serviceID, byte[] plain)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncStrServiceID AgentInit Error", ret);
    }
  
    return _Scp_Enc_Str_ServiceID_Byte(iniFilePath, serviceID, plain);
  }

/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStrServiceID(String, String, byte[])
 */  
  public byte[] ScpDecStrServiceID(String iniFilePath, String serviceID, byte[] cipher)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");
    }
    if (checkNull(cipher))
    {
      return new byte[0];
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecStrServiceID AgentInit Error", ret);
    }
  
    return _Scp_Dec_Str_ServiceID_Byte(iniFilePath, serviceID, cipher);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpEncB64ServiceID(String, String, byte[])
 */  
  public byte[] ScpEncB64ServiceID(String iniFilePath, String serviceID, byte[] plain)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpEncB64ServiceID AgentInit Error", ret);
    }
  
    return _Scp_Enc_B64_ServiceID_Byte(iniFilePath, serviceID, plain);
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param cipher ȣȭ ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecB64ServiceID(String, String, byte[])
 */  
  public byte[] ScpDecB64ServiceID(String iniFilePath, String serviceID, byte[] cipher)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");
    }
    if (checkNull(cipher))
    {
      return new byte[0];
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecB64ServiceID AgentInit Error", ret);
    }
  
    return _Scp_Dec_B64_ServiceID_Byte(iniFilePath, serviceID, cipher);
  }
  
  /**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, byte[])
 */
   public byte[] ScpKeyHashStrServiceID(String iniFilePath, String serviceID, byte[] plain)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
  
    return _Scp_Key_Hash_Str_ServiceID_Byte(iniFilePath, serviceID, plain);
  }
  
  /**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param serviceID KMS ϴ ServiceID  
  *@param plain ȣȭ ÷   
  *@return ȣȭ ÷ 
  *@see com.penta.scpdb.ScpDbAgent#ScpDecStr(String, String, byte[])
 */
   public byte[] ScpKeyHashB64ServiceID(String iniFilePath, String serviceID, byte[] plain)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(serviceID))
    {
      throw new ScpDbAgentException("serviceID is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }

    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeyHashStr AgentInit Error", ret);
    }
  
    return _Scp_Key_Hash_B64_ServiceID_Byte(iniFilePath, serviceID, plain);
  }



/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param inFilePath ȣȭ ϸ
  *@param outFilePath ȣȭ ϸ 
  *@return ڵ
 */  
  public int ScpKeDecFF( String iniFilePath, String inFilePath, String outFilePath)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    } 
    if(checkNull(inFilePath))
    {
      throw new ScpDbAgentException("inFilePath is null");  
    }  
    if(checkNull(outFilePath))
    {
      throw new ScpDbAgentException("outFilePath is null");  
    }
    
    int ret = AgentInitInternal(iniFilePath); 
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecFile AgentInit Error", ret);
    }
  
    if ( isWindows )
    {
      try
      {
        return  _Scp_Ke_Dec_FF( iniFilePath, inFilePath.getBytes("UTF-16LE"), outFilePath.getBytes("UTF-16LE"));
      }
      catch (UnsupportedEncodingException e1)
      {
        throw new ScpDbAgentException("getBytes(UTF-16LE) is fail ");  
      }
    }

    return  _Scp_Ke_Dec_FF( iniFilePath, inFilePath.getBytes(), outFilePath.getBytes());
  }
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param inFilePath ȣȭ ϸ
  *@param outFilePath ȣȭ ϸ 
  *@return ڵ
 */  
  public int ScpKeDecFF( String iniFilePath, byte[] inFilePath, byte[] outFilePath)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    } 
    if(checkNull(inFilePath))
    {
      throw new ScpDbAgentException("inFilePath is null");  
    }  
    if(checkNull(outFilePath))
    {
      throw new ScpDbAgentException("outFilePath is null");  
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecFile AgentInit Error", ret);
    }
    
    return  _Scp_Ke_Dec_FF( iniFilePath, inFilePath, outFilePath);
  }  

  /**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param inData ȣȭ  
  *@param offset Ͽ ȣȭ  ġ
  *@return ȣȭ  
 */  
  public byte[] ScpKeDecBB_Offset( String iniFilePath, byte[] inData, long offset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    } 
    if(checkNull(inData))
    {
      throw new ScpDbAgentException("inData is null");  
    }  
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeDecBB_Offset AgentInit Error", ret);
    }
    
    return  _Scp_Ke_Dec_BB_Offset( iniFilePath, inData, inData.length, offset);
  }
  
  /**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param inFilePath ȣȭ ϸ
  *@param inDatLen   ȣȭ   
  *@param offset     Ǿ˿ ȣȭ  
  *@return ڵ
 */  
  public byte[] ScpKeDecFB_Offset( String iniFilePath, String inFilePath, long inDataLen, long offset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    } 
    if(checkNull(inFilePath))
    {
      throw new ScpDbAgentException("inFilePath is null");  
    }
    if(inDataLen <= 0)
    {
      throw new ScpDbAgentException("inDataLen is invalid");
    }
    if(offset < 0 )
    {
      throw new ScpDbAgentException("offset is invalid");
    }      

    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpDecFile AgentInit Error", ret);
    }
  
    if ( isWindows )
    {
      try
      {
        return  _Scp_Ke_Dec_FB_Offset( iniFilePath, inFilePath.getBytes("UTF-16LE"), inDataLen, offset);
      }
      catch (UnsupportedEncodingException e1)
      {
        throw new ScpDbAgentException("getBytes(UTF-16LE) is fail ");  
      }
    }

    return  _Scp_Ke_Dec_FB_Offset( iniFilePath, inFilePath.getBytes(), inDataLen, offset);
  }
  
  
/**
  *DB Column ȣȭ
  *@param iniFilePath Agent  fullpath 
  *@param inFilePath ȣȭ ϸ
  *@param inDatLen   ȣȭ   
  *@param offset     Ǿ˿ ȣȭ  
  *@return ڵ
 */  
  public byte[] ScpKeDecFB_Offset( String iniFilePath, byte[] inFilePath, long inDataLen, long offset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");  
    } 
    if(checkNull(inFilePath))
    {
      throw new ScpDbAgentException("inFilePath is null");  
    }
    if(inDataLen <= 0)
    {
      throw new ScpDbAgentException("inDataLen is invalid");
    }
    if(offset < 0 )
    {
      throw new ScpDbAgentException("offset is invalid");
    }      
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118)
    {
      throw new ScpDbAgentException("ScpKeDecFB_Offset AgentInit Error", ret);
    }
    
    return  _Scp_Ke_Dec_FB_Offset( iniFilePath, inFilePath, inDataLen, offset);
  }
  
  
  public String ScpAsymmEncBin( String iniFilePath, String iniKeyName, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncBin AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Enc_Bin_UTF8( iniFilePath, iniKeyName, plain, keyType );
  }
  
  public String ScpAsymmEncBin( String iniFilePath, String iniKeyName, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncBin AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Enc_Bin_UTF8(iniFilePath, iniKeyName, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Enc_Bin_EUCKR( iniFilePath, iniKeyName, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Enc_Bin_UTF8( iniFilePath, iniKeyName, plain, keyType );
    }    
  }

  
  public byte[] ScpAsymmEncBin(String iniFilePath, String iniKeyName, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncBin AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Enc_Bin_Byte(iniFilePath, iniKeyName, plain, keyType);
  }
  
  public String ScpAsymmEncHex( String iniFilePath, String iniKeyName, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Enc_Hex_UTF8( iniFilePath, iniKeyName, plain, keyType );
  }
  
  public String ScpAsymmEncHex( String iniFilePath, String iniKeyName, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncHex AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Enc_Hex_UTF8(iniFilePath, iniKeyName, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Enc_Hex_EUCKR( iniFilePath, iniKeyName, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Enc_Hex_UTF8( iniFilePath, iniKeyName, plain, keyType );
    }    
  }
  
  
  public byte[] ScpAsymmEncHex(String iniFilePath, String iniKeyName, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Enc_Hex_Byte(iniFilePath, iniKeyName, plain, keyType);
  }
  
  
  public String ScpAsymmEncB64( String iniFilePath, String iniKeyName, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncB64 AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Enc_B64_UTF8( iniFilePath, iniKeyName, plain, keyType );
  }
  
  
  public String ScpAsymmEncB64( String iniFilePath, String iniKeyName, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncB64 AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Enc_B64_UTF8(iniFilePath, iniKeyName, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Enc_B64_EUCKR( iniFilePath, iniKeyName, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Enc_B64_UTF8( iniFilePath, iniKeyName, plain, keyType );
    }    
  }
  
  
  
  public byte[] ScpAsymmEncB64(String iniFilePath, String iniKeyName, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmEncB64 AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Enc_B64_Byte(iniFilePath, iniKeyName, plain, keyType);
  }
  
  
    public String ScpAsymmDecBin( String iniFilePath, String iniKeyName, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecBin AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Dec_Bin_UTF8( iniFilePath, iniKeyName, plain, keyType );
  }
  
  public String ScpAsymmDecBin( String iniFilePath, String iniKeyName, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecBin AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Dec_Hex_UTF8(iniFilePath, iniKeyName, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Dec_Bin_EUCKR( iniFilePath, iniKeyName, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Dec_Bin_UTF8( iniFilePath, iniKeyName, plain, keyType );
    }    
  }

  
  public byte[] ScpAsymmDecBin(String iniFilePath, String iniKeyName, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecBin AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Dec_Bin_Byte(iniFilePath, iniKeyName, plain, keyType);
  }
  
  public String ScpAsymmDecHex( String iniFilePath, String iniKeyName, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Dec_Hex_UTF8( iniFilePath, iniKeyName, plain, keyType );
  }
  
  public String ScpAsymmDecHex( String iniFilePath, String iniKeyName, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecHex AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Dec_Hex_UTF8(iniFilePath, iniKeyName, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Dec_Hex_EUCKR( iniFilePath, iniKeyName, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Dec_Hex_UTF8( iniFilePath, iniKeyName, plain, keyType );
    }    
  }
  
  
  public byte[] ScpAsymmDecHex(String iniFilePath, String iniKeyName, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Dec_Hex_Byte(iniFilePath, iniKeyName, plain, keyType);
  }
  
  
  public String ScpAsymmDecB64( String iniFilePath, String iniKeyName, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecB64 AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Dec_B64_UTF8( iniFilePath, iniKeyName, plain, keyType );
  }
  
  
  public String ScpAsymmDecB64( String iniFilePath, String iniKeyName, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecB64 AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Dec_B64_UTF8(iniFilePath, iniKeyName, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Dec_B64_EUCKR( iniFilePath, iniKeyName, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Dec_B64_UTF8( iniFilePath, iniKeyName, plain, keyType );
    }    
  }
  
  
  
  public byte[] ScpAsymmDecB64(String iniFilePath, String iniKeyName, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmDecB64 AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Dec_B64_Byte(iniFilePath, iniKeyName, plain, keyType);
  }
  
  
  
  public String ScpAsymmSignBin( String iniFilePath, String iniKeyName, int hashAlgo, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignBin AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Sign_Bin_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
  }
  
  public String ScpAsymmSignBin( String iniFilePath, String iniKeyName, int hashAlgo, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != 0 && keyType != 1 )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignBin AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Sign_Bin_UTF8(iniFilePath, iniKeyName, hashAlgo, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Sign_Bin_EUCKR( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Sign_Bin_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
    }    
  }

  
  public byte[] ScpAsymmSignBin(String iniFilePath, String iniKeyName, int hashAlgo, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignBin AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Sign_Bin_Byte(iniFilePath, iniKeyName, hashAlgo, plain, keyType);
  }
  
  public String ScpAsymmSignHex( String iniFilePath, String iniKeyName, int hashAlgo, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Sign_Hex_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
  }
  
  public String ScpAsymmSignHex( String iniFilePath, String iniKeyName, int hashAlgo, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignHex AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Sign_Hex_UTF8(iniFilePath, iniKeyName, hashAlgo, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Sign_Hex_EUCKR( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Sign_Hex_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
    }    
  }

  
  public byte[] ScpAsymmSignHex(String iniFilePath, String iniKeyName, int hashAlgo, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Sign_Hex_Byte(iniFilePath, iniKeyName, hashAlgo, plain, keyType);
  }
  
    public String ScpAsymmSignB64( String iniFilePath, String iniKeyName, int hashAlgo, String plain, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignB64 AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Sign_B64_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
  }
  
  public String ScpAsymmSignB64( String iniFilePath, String iniKeyName, int hashAlgo, String plain, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      return "";
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignB64 AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Sign_B64_UTF8(iniFilePath, iniKeyName, hashAlgo, plain, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Sign_B64_EUCKR( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
    }
    else
    {
      return _Scp_Asymm_Sign_B64_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, keyType );
    }    
  }

  
  public byte[] ScpAsymmSignB64(String iniFilePath, String iniKeyName, int hashAlgo, byte[] plain, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if (checkNull(plain))
    {
      return new byte[0];
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmSignB64 AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Sign_B64_Byte(iniFilePath, iniKeyName, hashAlgo, plain, keyType);
  }
  
  
  public int ScpAsymmVerifyBin( String iniFilePath, String iniKeyName, int hashAlgo, String plain, String signedData, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyBin AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Verify_Bin_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
  }
  
  public int ScpAsymmVerifyBin( String iniFilePath, String iniKeyName, int hashAlgo, String plain, String signedData, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyBin AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Verify_Bin_UTF8(iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Verify_Bin_EUCKR( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
    }
    else
    {
      return _Scp_Asymm_Verify_Bin_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
    }    
  }

  
  public int ScpAsymmVerifyBin(String iniFilePath, String iniKeyName, int hashAlgo, byte[] plain, byte[] signedData, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyBin AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Verify_Bin_Byte(iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType);
  }
  
    public int ScpAsymmVerifyHex( String iniFilePath, String iniKeyName, int hashAlgo, String plain, String signedData, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Verify_Hex_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
  }
  
  public int ScpAsymmVerifyHex( String iniFilePath, String iniKeyName, int hashAlgo, String plain, String signedData, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyHex AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Verify_Hex_UTF8(iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Verify_Hex_EUCKR( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
    }
    else
    {
      return _Scp_Asymm_Verify_Hex_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
    }    
  }

  
  public int ScpAsymmVerifyHex(String iniFilePath, String iniKeyName, int hashAlgo, byte[] plain, byte[] signedData, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Verify_Hex_Byte(iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType);
  }
 
    public int ScpAsymmVerifyB64( String iniFilePath, String iniKeyName, int hashAlgo, String plain, String signedData, int keyType)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyHex AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Verify_B64_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
  }
  
  public int ScpAsymmVerifyB64( String iniFilePath, String iniKeyName, int hashAlgo, String plain, String signedData, int keyType, String charset)
  {
    if(checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if(checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyB64 AgentInit Error", ret);
    }
    
    if(checkNull(charset))
    {
      return _Scp_Asymm_Verify_B64_UTF8(iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType);
    }
    
    if("EUC-KR".equals(charset))
    {
      return _Scp_Asymm_Verify_B64_EUCKR( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
    }
    else
    {
      return _Scp_Asymm_Verify_B64_UTF8( iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType );
    }    
  }

  
  public int ScpAsymmVerifyB64(String iniFilePath, String iniKeyName, int hashAlgo, byte[] plain, byte[] signedData, int keyType)
  {
    if (checkNull(iniFilePath))
    {
      throw new ScpDbAgentException("iniFilePath is null");
    }
    if (checkNull(iniKeyName))
    {
      throw new ScpDbAgentException("iniKeyName is null");
    }
    if(checkNull(plain))
    {
      throw new ScpDbAgentException("plain is null");
    }
    if(checkNull(signedData))
    {
      throw new ScpDbAgentException("signedData is null");
    }
    if( keyType != ScpDbAgent.SCP_SERVICEID && keyType != ScpDbAgent.SCP_KEYINFO )
    {
      throw new ScpDbAgentException("keyType is invalid value.");
    }
    
    int ret = AgentInitInternal(iniFilePath);
    if ( ret != 0 && ret != 118 )
    {
      throw new ScpDbAgentException("ScpAsymmVerifyB64 AgentInit Error", ret);
    }
    
    return _Scp_Asymm_Verify_B64_Byte(iniFilePath, iniKeyName, hashAlgo, plain, signedData, keyType);
  }
 
  
  
  
  /**
  * ڵ 
  *@return ڵ
  *@see 
 */
  public int Agent_GetLastError()
  {
    return _Agent_GetLastError();
  }
 }
