/*
 * Decompiled with CFR 0.152.
 */
package com.sci.v2.pcc.secu.seed;

import com.sci.v2.pcc.secu.seed.Seed;
import java.security.SecureRandom;

public class SeedCBC {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    protected byte[] amalgam = null;
    protected byte[] ciphertext = null;
    protected byte[] iv = null;
    protected int blockSize = 16;
    protected final int MaximunPaddedCipherText = 256;
    private byte[] tempBlock = null;
    protected byte[] bufferedData = null;
    protected int bufferedLength = 0;
    Seed seed = new Seed();
    public static final int NoPadding = 0;
    public static final int PKCS5Padding = 1;
    protected static final int TLSPadding = 2;
    protected int padding = 1;
    protected int tlsPaddingLength = 0;
    protected int cipherMode;
    protected SecureRandom random;

    public SeedCBC() {
        this.amalgam = new byte[this.blockSize];
        this.ciphertext = new byte[this.blockSize];
        this.tempBlock = new byte[512];
        this.bufferedData = new byte[256 + this.blockSize];
    }

    protected int addToBufferedData(byte[] input, int offset, int length) {
        if (input != null && length != 0) {
            System.arraycopy(input, offset, this.bufferedData, this.bufferedLength, length);
        }
        return this.bufferedLength += length;
    }

    protected void getBufferedData(byte[] output, int offset) {
        System.arraycopy(this.bufferedData, 0, output, offset, this.bufferedLength);
        this.bufferedLength = 0;
    }

    protected int engineGetOutputSize(int inputLength) {
        int totalInputSize = inputLength + this.bufferedLength;
        int lastblockSize = totalInputSize % this.blockSize;
        int minPaddingSize = this.blockSize - lastblockSize;
        switch (this.padding) {
            case 2: {
                return 256 + inputLength + this.blockSize;
            }
            case 1: {
                if (lastblockSize == 0) {
                    return totalInputSize + this.blockSize;
                }
                return totalInputSize + minPaddingSize;
            }
            case 0: {
                return inputLength;
            }
        }
        return 0;
    }

    protected int engineTransformBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        if (this.cipherMode == 1) {
            int ret = this.encryptBlock(input, inputOffset, inputLength, output, outputOffset);
            return ret;
        }
        if (this.cipherMode == 2) {
            int ret = this.decryptBlock(input, inputOffset, inputLength, output, outputOffset);
            return ret;
        }
        return 0;
    }

    public void engineInit(int opmode, byte[] key, byte[] iv, int padding) throws Exception {
        this.cipherMode = opmode;
        this.padding = padding;
        this.seed.setKey(key);
        this.iv = (byte[])iv.clone();
        this.amalgam = new byte[this.blockSize];
        this.ciphertext = new byte[this.blockSize];
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLength) {
        int length = 0;
        byte[] out = new byte[this.engineGetOutputSize(inputLength)];
        length = this.engineUpdate(input, inputOffset, inputLength, out, 0);
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        int sBufferLength = this.bufferedLength;
        int totalInputSize = inputLength + sBufferLength;
        int safeOutputLength = totalInputSize - 256;
        if (safeOutputLength <= 0) {
            if (input != null) {
                this.addToBufferedData(input, inputOffset, inputLength);
            }
            return 0;
        }
        int outputLength = 0;
        int transformedLength = 0;
        if (sBufferLength <= safeOutputLength) {
            int moreInputLength;
            int glitch_bt;
            if (sBufferLength >= this.blockSize) {
                transformedLength = 0;
                while (transformedLength < sBufferLength - this.blockSize) {
                    outputLength += this.engineTransformBlock(this.bufferedData, transformedLength, this.blockSize, output, outputOffset + outputLength);
                    transformedLength += this.blockSize;
                }
            }
            if (this.blockSize - (glitch_bt = sBufferLength - transformedLength) <= (moreInputLength = safeOutputLength - sBufferLength)) {
                System.arraycopy(this.bufferedData, transformedLength, this.tempBlock, 0, glitch_bt);
                System.arraycopy(input, inputOffset, this.tempBlock, glitch_bt, this.blockSize - glitch_bt);
                outputLength += this.engineTransformBlock(this.tempBlock, 0, this.blockSize, output, outputOffset + outputLength);
                transformedLength = inputOffset + (this.blockSize - glitch_bt);
                while (transformedLength < moreInputLength + inputOffset) {
                    outputLength += this.engineTransformBlock(input, transformedLength, this.blockSize, output, outputOffset + outputLength);
                    transformedLength += this.blockSize;
                }
                this.bufferedLength = 0;
                this.addToBufferedData(input, transformedLength, inputLength - (transformedLength - inputOffset));
            } else {
                int destBuffLen = this.bufferedLength;
                this.bufferedLength = 0;
                this.addToBufferedData(this.bufferedData, destBuffLen - glitch_bt, glitch_bt);
                this.addToBufferedData(input, 0, inputLength);
            }
        } else if (safeOutputLength >= this.blockSize) {
            transformedLength = 0;
            while (transformedLength < safeOutputLength) {
                outputLength += this.engineTransformBlock(this.bufferedData, transformedLength, this.blockSize, output, outputOffset + outputLength);
                transformedLength += this.blockSize;
            }
            int lastBufferLength = this.bufferedLength;
            this.bufferedLength = 0;
            if (transformedLength < lastBufferLength) {
                this.addToBufferedData(this.bufferedData, transformedLength, lastBufferLength - transformedLength);
            }
            this.addToBufferedData(input, inputOffset, inputLength);
        } else {
            this.addToBufferedData(input, inputOffset, inputLength);
        }
        return outputLength;
    }

    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLength) throws Exception {
        int length = 0;
        byte[] out = new byte[this.engineGetOutputSize(inputLength)];
        length = this.engineDoFinal(input, inputOffset, inputLength, out, 0);
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws Exception {
        int outputLength = 0;
        outputLength += this.engineUpdate(input, inputOffset, inputLength, output, outputOffset);
        switch (this.cipherMode) {
            case 2: {
                int i = 0;
                while (i < this.bufferedLength) {
                    outputLength += this.engineTransformBlock(this.bufferedData, i, this.blockSize, output, outputOffset + outputLength);
                    i += this.blockSize;
                }
                this.bufferedLength = 0;
                if (this.padding != 0) {
                    int paddingLength = output[outputOffset + outputLength - 1] & 0xFF;
                    if (paddingLength < 0 || paddingLength > 255) {
                        throw new Exception("PKCS5 or TLS: " + paddingLength);
                    }
                    if (outputLength - paddingLength < 0) {
                        throw new Exception("minus padding: " + (outputLength - paddingLength) + " < 0, padding length = " + paddingLength);
                    }
                    i = 2;
                    while (i <= paddingLength) {
                        if ((output[outputOffset + outputLength - paddingLength] & 0xFF) != paddingLength) {
                            throw new Exception("Padding does not match");
                        }
                        ++i;
                    }
                    return outputLength - paddingLength;
                }
                return outputLength;
            }
            case 1: {
                int paddingLength = this.getPaddingLength(this.bufferedLength % this.blockSize);
                int oldBufferLength = this.bufferedLength;
                this.getBufferedData(this.tempBlock, 0);
                this.getPadded(paddingLength, this.tempBlock, oldBufferLength);
                int i = 0;
                while (i < paddingLength + oldBufferLength) {
                    outputLength += this.engineTransformBlock(this.tempBlock, i, this.blockSize, output, outputOffset + outputLength);
                    i += this.blockSize;
                }
                return outputLength;
            }
        }
        return 0;
    }

    protected int getPaddingLength(int lastBytesLeft) {
        int minPaddingSize = this.blockSize - lastBytesLeft;
        switch (this.padding) {
            case 0: {
                if (lastBytesLeft == 0) {
                    return lastBytesLeft;
                }
            }
            case 1: {
                if (minPaddingSize == 0) {
                    return this.blockSize;
                }
                return minPaddingSize;
            }
            case 2: {
                if (this.tlsPaddingLength == 0) {
                    int nPaddingBlocks;
                    if (this.random == null) {
                        this.random = new SecureRandom();
                    }
                    if ((nPaddingBlocks = this.random.nextInt() % (256 / this.blockSize - 1)) < 0) {
                        nPaddingBlocks = -nPaddingBlocks;
                    }
                    this.tlsPaddingLength = nPaddingBlocks * this.blockSize + minPaddingSize;
                    return this.tlsPaddingLength;
                }
                return this.tlsPaddingLength;
            }
        }
        return 0;
    }

    protected void getPadded(int paddingLength, byte[] in, int inOff) {
        switch (this.padding) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                int i = inOff;
                while (i < inOff + paddingLength) {
                    in[i] = (byte)paddingLength;
                    ++i;
                }
                break;
            }
        }
    }

    public byte[] decrypt(byte[] plainText, byte[] encKey, byte[] initialVector) {
        int length = 0;
        byte[] out = new byte[this.engineGetOutputSize(plainText.length)];
        length = this.decryptBlock(plainText, 0, plainText.length, out, 0, encKey, initialVector);
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    public byte[] encrypt(byte[] cripherText, byte[] encKey, byte[] initialVector) {
        int length = 0;
        byte[] planData = new byte[1024];
        System.arraycopy(cripherText, 0, planData, 0, cripherText.length);
        byte[] out = new byte[this.engineGetOutputSize(planData.length)];
        length = this.encryptBlock(planData, 0, cripherText.length, out, 0, encKey, initialVector);
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    protected int decryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff, byte[] key, byte[] iv) {
        this.iv = iv;
        outputLength = 0;
        off = inOff;
        end = inOff + inLen;
        try {
            this.seed.setKey(key);
            if (true) ** GOTO lbl15
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        do {
            outputLength += this.decryptBlock(in, off, this.blockSize, out, outOff);
            off += this.blockSize;
            outOff += this.blockSize;
lbl15:
            // 2 sources

        } while (off < end);
        return outputLength;
    }

    /*
     * Unable to fully structure code
     */
    protected int encryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff, byte[] key, byte[] iv) {
        this.iv = iv;
        outputLength = 0;
        off = inOff;
        end = inOff + inLen;
        try {
            this.seed.setKey(key);
            if (true) ** GOTO lbl15
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        do {
            outputLength += this.encryptBlock(in, off, this.blockSize, out, outOff);
            off += this.blockSize;
            outOff += this.blockSize;
lbl15:
            // 2 sources

        } while (off < end);
        return outputLength;
    }

    protected int encryptBlock(byte[] input, int inOff, int len, byte[] output, int outOff) {
        int i = 0;
        while (i < this.blockSize) {
            this.amalgam[i] = (byte)(input[inOff + i] ^ this.iv[i]);
            ++i;
        }
        this.seed.encryptBlock(this.amalgam, 0, this.blockSize, this.ciphertext, 0);
        System.arraycopy(this.ciphertext, 0, output, outOff, this.blockSize);
        System.arraycopy(this.ciphertext, 0, this.iv, 0, this.blockSize);
        return this.blockSize;
    }

    protected int decryptBlock(byte[] input, int inOff, int len, byte[] output, int outOff) {
        System.arraycopy(input, inOff, this.ciphertext, 0, this.blockSize);
        this.seed.decryptBlock(this.ciphertext, 0, this.blockSize, this.amalgam, 0);
        int i = 0;
        while (i < this.blockSize) {
            output[outOff + i] = (byte)(this.amalgam[i] ^ this.iv[i]);
            ++i;
        }
        System.arraycopy(this.ciphertext, 0, this.iv, 0, this.blockSize);
        return this.blockSize;
    }
}

