/*
 * Decompiled with CFR 0.152.
 */
package com.sci.v2.ipinv2.secu.hmac;

import com.sci.v2.ipinv2.secu.SciSecuManager;
import java.security.MessageDigest;

public class SciHmac {
    private static String[] _hexPseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static int[] state = new int[5];
    private static long count;
    public static byte[] digestBits;
    private static boolean digestValid;
    private static int[] block;
    private static int blockIndex;
    static int[] dd;

    static {
        block = new int[16];
        dd = new int[5];
    }

    public SciHmac() {
        state = new int[5];
        count = 0L;
        if (block == null) {
            block = new int[16];
        }
        digestBits = new byte[20];
        digestValid = false;
    }

    static final int rol(int value, int bits) {
        int q = value << bits | value >>> 32 - bits;
        return q;
    }

    static final int blk0(int i) {
        SciHmac.block[i] = SciHmac.rol(block[i], 24) & 0xFF00FF00 | SciHmac.rol(block[i], 8) & 0xFF00FF;
        return block[i];
    }

    static final int blk(int i) {
        SciHmac.block[i & 0xF] = SciHmac.rol(block[i + 13 & 0xF] ^ block[i + 8 & 0xF] ^ block[i + 2 & 0xF] ^ block[i & 0xF], 1);
        return block[i & 0xF];
    }

    static final void R0(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] & (data[x] ^ data[y]) ^ data[y]) + SciHmac.blk0(i) + 1518500249 + SciHmac.rol(data[v], 5));
        data[w] = SciHmac.rol(data[w], 30);
    }

    static final void R1(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] & (data[x] ^ data[y]) ^ data[y]) + SciHmac.blk(i) + 1518500249 + SciHmac.rol(data[v], 5));
        data[w] = SciHmac.rol(data[w], 30);
    }

    static final void R2(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] ^ data[x] ^ data[y]) + SciHmac.blk(i) + 1859775393 + SciHmac.rol(data[v], 5));
        data[w] = SciHmac.rol(data[w], 30);
    }

    static final void R3(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + (((data[w] | data[x]) & data[y] | data[w] & data[x]) + SciHmac.blk(i) + -1894007588 + SciHmac.rol(data[v], 5));
        data[w] = SciHmac.rol(data[w], 30);
    }

    static final void R4(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] ^ data[x] ^ data[y]) + SciHmac.blk(i) + -899497514 + SciHmac.rol(data[v], 5));
        data[w] = SciHmac.rol(data[w], 30);
    }

    static void transform() {
        SciHmac.dd[0] = state[0];
        SciHmac.dd[1] = state[1];
        SciHmac.dd[2] = state[2];
        SciHmac.dd[3] = state[3];
        SciHmac.dd[4] = state[4];
        SciHmac.R0(dd, 0, 1, 2, 3, 4, 0);
        SciHmac.R0(dd, 4, 0, 1, 2, 3, 1);
        SciHmac.R0(dd, 3, 4, 0, 1, 2, 2);
        SciHmac.R0(dd, 2, 3, 4, 0, 1, 3);
        SciHmac.R0(dd, 1, 2, 3, 4, 0, 4);
        SciHmac.R0(dd, 0, 1, 2, 3, 4, 5);
        SciHmac.R0(dd, 4, 0, 1, 2, 3, 6);
        SciHmac.R0(dd, 3, 4, 0, 1, 2, 7);
        SciHmac.R0(dd, 2, 3, 4, 0, 1, 8);
        SciHmac.R0(dd, 1, 2, 3, 4, 0, 9);
        SciHmac.R0(dd, 0, 1, 2, 3, 4, 10);
        SciHmac.R0(dd, 4, 0, 1, 2, 3, 11);
        SciHmac.R0(dd, 3, 4, 0, 1, 2, 12);
        SciHmac.R0(dd, 2, 3, 4, 0, 1, 13);
        SciHmac.R0(dd, 1, 2, 3, 4, 0, 14);
        SciHmac.R0(dd, 0, 1, 2, 3, 4, 15);
        SciHmac.R1(dd, 4, 0, 1, 2, 3, 16);
        SciHmac.R1(dd, 3, 4, 0, 1, 2, 17);
        SciHmac.R1(dd, 2, 3, 4, 0, 1, 18);
        SciHmac.R1(dd, 1, 2, 3, 4, 0, 19);
        SciHmac.R2(dd, 0, 1, 2, 3, 4, 20);
        SciHmac.R2(dd, 4, 0, 1, 2, 3, 21);
        SciHmac.R2(dd, 3, 4, 0, 1, 2, 22);
        SciHmac.R2(dd, 2, 3, 4, 0, 1, 23);
        SciHmac.R2(dd, 1, 2, 3, 4, 0, 24);
        SciHmac.R2(dd, 0, 1, 2, 3, 4, 25);
        SciHmac.R2(dd, 4, 0, 1, 2, 3, 26);
        SciHmac.R2(dd, 3, 4, 0, 1, 2, 27);
        SciHmac.R2(dd, 2, 3, 4, 0, 1, 28);
        SciHmac.R2(dd, 1, 2, 3, 4, 0, 29);
        SciHmac.R2(dd, 0, 1, 2, 3, 4, 30);
        SciHmac.R2(dd, 4, 0, 1, 2, 3, 31);
        SciHmac.R2(dd, 3, 4, 0, 1, 2, 32);
        SciHmac.R2(dd, 2, 3, 4, 0, 1, 33);
        SciHmac.R2(dd, 1, 2, 3, 4, 0, 34);
        SciHmac.R2(dd, 0, 1, 2, 3, 4, 35);
        SciHmac.R2(dd, 4, 0, 1, 2, 3, 36);
        SciHmac.R2(dd, 3, 4, 0, 1, 2, 37);
        SciHmac.R2(dd, 2, 3, 4, 0, 1, 38);
        SciHmac.R2(dd, 1, 2, 3, 4, 0, 39);
        SciHmac.R3(dd, 0, 1, 2, 3, 4, 40);
        SciHmac.R3(dd, 4, 0, 1, 2, 3, 41);
        SciHmac.R3(dd, 3, 4, 0, 1, 2, 42);
        SciHmac.R3(dd, 2, 3, 4, 0, 1, 43);
        SciHmac.R3(dd, 1, 2, 3, 4, 0, 44);
        SciHmac.R3(dd, 0, 1, 2, 3, 4, 45);
        SciHmac.R3(dd, 4, 0, 1, 2, 3, 46);
        SciHmac.R3(dd, 3, 4, 0, 1, 2, 47);
        SciHmac.R3(dd, 2, 3, 4, 0, 1, 48);
        SciHmac.R3(dd, 1, 2, 3, 4, 0, 49);
        SciHmac.R3(dd, 0, 1, 2, 3, 4, 50);
        SciHmac.R3(dd, 4, 0, 1, 2, 3, 51);
        SciHmac.R3(dd, 3, 4, 0, 1, 2, 52);
        SciHmac.R3(dd, 2, 3, 4, 0, 1, 53);
        SciHmac.R3(dd, 1, 2, 3, 4, 0, 54);
        SciHmac.R3(dd, 0, 1, 2, 3, 4, 55);
        SciHmac.R3(dd, 4, 0, 1, 2, 3, 56);
        SciHmac.R3(dd, 3, 4, 0, 1, 2, 57);
        SciHmac.R3(dd, 2, 3, 4, 0, 1, 58);
        SciHmac.R3(dd, 1, 2, 3, 4, 0, 59);
        SciHmac.R4(dd, 0, 1, 2, 3, 4, 60);
        SciHmac.R4(dd, 4, 0, 1, 2, 3, 61);
        SciHmac.R4(dd, 3, 4, 0, 1, 2, 62);
        SciHmac.R4(dd, 2, 3, 4, 0, 1, 63);
        SciHmac.R4(dd, 1, 2, 3, 4, 0, 64);
        SciHmac.R4(dd, 0, 1, 2, 3, 4, 65);
        SciHmac.R4(dd, 4, 0, 1, 2, 3, 66);
        SciHmac.R4(dd, 3, 4, 0, 1, 2, 67);
        SciHmac.R4(dd, 2, 3, 4, 0, 1, 68);
        SciHmac.R4(dd, 1, 2, 3, 4, 0, 69);
        SciHmac.R4(dd, 0, 1, 2, 3, 4, 70);
        SciHmac.R4(dd, 4, 0, 1, 2, 3, 71);
        SciHmac.R4(dd, 3, 4, 0, 1, 2, 72);
        SciHmac.R4(dd, 2, 3, 4, 0, 1, 73);
        SciHmac.R4(dd, 1, 2, 3, 4, 0, 74);
        SciHmac.R4(dd, 0, 1, 2, 3, 4, 75);
        SciHmac.R4(dd, 4, 0, 1, 2, 3, 76);
        SciHmac.R4(dd, 3, 4, 0, 1, 2, 77);
        SciHmac.R4(dd, 2, 3, 4, 0, 1, 78);
        SciHmac.R4(dd, 1, 2, 3, 4, 0, 79);
        state[0] = state[0] + dd[0];
        state[1] = state[1] + dd[1];
        state[2] = state[2] + dd[2];
        state[3] = state[3] + dd[3];
        state[4] = state[4] + dd[4];
    }

    public static void init() {
        SciHmac.state[0] = 1732584193;
        SciHmac.state[1] = -271733879;
        SciHmac.state[2] = -1732584194;
        SciHmac.state[3] = 271733878;
        SciHmac.state[4] = -1009589776;
        count = 0L;
        digestBits = new byte[20];
        digestValid = false;
        blockIndex = 0;
    }

    public static synchronized void update(byte b) {
        int mask = 8 * (blockIndex & 3);
        count += 8L;
        int n = blockIndex >> 2;
        block[n] = block[n] & ~(255 << mask);
        int n2 = blockIndex >> 2;
        block[n2] = block[n2] | (b & 0xFF) << mask;
        if (++blockIndex == 64) {
            SciHmac.transform();
            blockIndex = 0;
        }
    }

    public static void update(byte[] abyte0) {
        int j = abyte0.length;
        int i = 0;
        while (i < j) {
            SciHmac.update(abyte0[i]);
            ++i;
        }
    }

    public static void finish() {
        byte[] bits = new byte[8];
        int i = 0;
        while (i < 8) {
            bits[i] = (byte)(count >>> (7 - i) * 8 & 0xFFL);
            ++i;
        }
        SciHmac.update((byte)-128);
        while (blockIndex != 56) {
            SciHmac.update((byte)0);
        }
        SciHmac.update(bits);
        i = 0;
        while (i < 20) {
            SciHmac.digestBits[i] = (byte)(state[i >> 2] >> (3 - (i & 3)) * 8 & 0xFF);
            ++i;
        }
        digestValid = true;
    }

    public static String HMacEncript(StringBuffer data) {
        SciSecuManager manager = new SciSecuManager();
        String macKey = manager.getSecuKey();
        byte[] keybuf = macKey.getBytes();
        byte[] databuf = data.toString().getBytes();
        SciHmac.init();
        SciHmac.update(keybuf);
        SciHmac.update(databuf);
        SciHmac.finish();
        byte[] dataout = digestBits;
        return SciHmac.dumpBytes(dataout);
    }

    public static String HMacEncript(String data) {
        SciSecuManager manager = new SciSecuManager();
        String macKey = manager.getSecuKey();
        System.out.println("JAR_HMAC_macKey : " + macKey);
        byte[] keybuf = macKey.getBytes();
        byte[] databuf = data.getBytes();
        SciHmac.init();
        SciHmac.update(keybuf);
        SciHmac.update(databuf);
        SciHmac.finish();
        byte[] dataout = digestBits;
        return SciHmac.dumpBytes(dataout);
    }

    public static String HMacEncriptPublic(String data) {
        SciSecuManager manager = new SciSecuManager();
        String macKey = manager.getSecuKeyPublic();
        byte[] keybuf = macKey.getBytes();
        byte[] databuf = data.getBytes();
        SciHmac.init();
        SciHmac.update(keybuf);
        SciHmac.update(databuf);
        SciHmac.finish();
        byte[] dataout = digestBits;
        return SciHmac.dumpBytes(dataout);
    }

    public static String HMacEncript(String data, String key) {
        byte[] keybuf = key.getBytes();
        byte[] databuf = data.getBytes();
        SciHmac.init();
        SciHmac.update(keybuf);
        SciHmac.update(databuf);
        SciHmac.finish();
        byte[] dataout = digestBits;
        return SciHmac.dumpBytes(dataout);
    }

    public static String dumpBytes(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String s;
            if (i % 32 == 0 && i != 0) {
                sb.append("\n");
            }
            if ((s = Integer.toHexString(bytes[i])).length() < 2) {
                s = "0" + s;
            }
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static int HMacCompare(String hexData, StringBuffer data) {
        String encData = SciHmac.HMacEncript(data);
        if (hexData.equals(encData)) {
            return 1;
        }
        return 0;
    }

    public static int HMacCompare(String hexData, String data) {
        String encData = SciHmac.HMacEncript(data);
        if (hexData.equals(encData)) {
            return 1;
        }
        return 0;
    }

    public static byte[] beforeMac(String resid_no, String site_info) {
        try {
            byte[] resigerNumger = resid_no.getBytes();
            byte[] siteInfo = site_info.getBytes();
            byte[] BeforeMac = new byte[6 + resigerNumger.length + siteInfo.length];
            BeforeMac[0] = 48;
            BeforeMac[1] = (byte)(BeforeMac.length - 2);
            BeforeMac[2] = 19;
            BeforeMac[3] = (byte)resigerNumger.length;
            System.arraycopy(resigerNumger, 0, BeforeMac, 4, resigerNumger.length);
            BeforeMac[resigerNumger.length + 4] = 19;
            BeforeMac[resigerNumger.length + 5] = (byte)siteInfo.length;
            System.arraycopy(siteInfo, 0, BeforeMac, 6 + resigerNumger.length, siteInfo.length);
            byte[] mac = SciHmac.getHashedByte("SHA-256", BeforeMac);
            return mac;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] getHashedByte(String algorithmName, byte[] plainBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithmName);
            md.update(plainBytes);
            byte[] bytHashedData = md.digest();
            return bytHashedData;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] TemphashValue(byte[] mac) {
        try {
            byte[] TemphashValue = new byte[16 + mac.length];
            TemphashValue[0] = 48;
            TemphashValue[1] = 46;
            TemphashValue[2] = 6;
            TemphashValue[3] = 9;
            TemphashValue[4] = 96;
            TemphashValue[5] = -122;
            TemphashValue[6] = 72;
            TemphashValue[7] = 1;
            TemphashValue[8] = 101;
            TemphashValue[9] = 3;
            TemphashValue[10] = 4;
            TemphashValue[11] = 2;
            TemphashValue[12] = 1;
            TemphashValue[13] = 3;
            TemphashValue[14] = 33;
            TemphashValue[15] = 0;
            System.arraycopy(mac, 0, TemphashValue, 16, mac.length);
            return TemphashValue;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String convertByteArrayToHexString(byte[] sourceBytes) {
        byte ch = 0;
        int nIndex = 0;
        if (sourceBytes == null || sourceBytes.length <= 0) {
            return "";
        }
        StringBuffer sbOut = new StringBuffer(sourceBytes.length * 2);
        while (nIndex < sourceBytes.length) {
            ch = (byte)(sourceBytes[nIndex] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            sbOut.append(_hexPseudo[ch]);
            ch = (byte)(sourceBytes[nIndex] & 0xF);
            sbOut.append(_hexPseudo[ch]);
            ++nIndex;
        }
        return sbOut.toString();
    }

    public static String strFill(String str) {
        String returnValue = "";
        if (str.length() != 12) {
            String sss = "S";
            sss = String.valueOf(sss) + str;
            int nMax = 12;
            int i = str.length() + 1;
            int sp = nMax - i;
            int j = 0;
            while (j < sp) {
                sss = String.valueOf(sss) + "0";
                ++j;
            }
            returnValue = sss;
        } else {
            returnValue = str;
        }
        return returnValue;
    }
}

