/*
 * Decompiled with CFR 0.152.
 */
package core.log.triggers;

import core.log.exception.InternalException;
import core.log.exception.ServiceException;
import core.log.util.ApacheCommonLangStringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

public class TriggerRegister {
    HashMap map = new HashMap();
    private static TriggerRegister triggerRegister;
    private static boolean useTriggering;

    private TriggerRegister() {
    }

    public static TriggerRegister getInstance() {
        if (triggerRegister == null) {
            triggerRegister = new TriggerRegister();
            return triggerRegister;
        }
        return triggerRegister;
    }

    public void setUseTriggering(boolean useTrigger) {
        useTriggering = useTrigger;
    }

    public boolean getUseTriggering() {
        return useTriggering;
    }

    public boolean check(Object tableName) throws ServiceException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.map.containsKey(tableName)) {
            if (this.map.get(tableName) instanceof Boolean) {
                return (Boolean)this.map.get(tableName);
            }
            if (this.map.get(tableName) instanceof Method) {
                Method method = (Method)this.map.get(tableName);
                method.invoke(method.getClass().newInstance(), (Object[])this.map.get(method));
                return true;
            }
            throw new ServiceException("You Should Putting Value is not Boolean Type!");
        }
        return false;
    }

    public void put(Object tableName, Class clazz, String methodName, Object[] params) throws ServiceException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.inputClassValidation(clazz);
        Class[] classes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            classes[i] = params[i].getClass();
        }
        Method method = clazz.getMethod(methodName, classes);
        if (tableName instanceof List) {
            for (int i = 0; i < ((List)tableName).size(); ++i) {
                this.map.put((String)((List)tableName).get(i), method);
            }
            this.map.put(method, params);
        } else if (tableName instanceof String) {
            this.map.put(tableName, method);
        } else {
            throw new ServiceException("Table Name Type Must Be List Or String!");
        }
    }

    public void put(Object tableName) throws ServiceException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (tableName instanceof List) {
            for (int i = 0; i < ((List)tableName).size(); ++i) {
                this.map.put((String)((List)tableName).get(i), new Boolean(false));
            }
        } else if (tableName instanceof String) {
            this.map.put(tableName, new Boolean(false));
        } else {
            throw new ServiceException("Table Name Type Must Be List Or String!");
        }
    }

    public void unload(Object tableName) throws ServiceException {
        if (tableName instanceof List) {
            for (int i = 0; i < ((List)tableName).size(); ++i) {
                this.map.remove((String)((List)tableName).get(i));
            }
        } else if (tableName instanceof String) {
            this.map.remove(tableName);
        } else {
            throw new ServiceException("Table Name Type Must Be List Or String!");
        }
    }

    private void inputClassValidation(Class key) throws ServiceException {
        boolean hasDefaultContructor = false;
        Constructor<?>[] constructors = key.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            hasDefaultContructor = true;
        }
        if (!hasDefaultContructor) {
            throw new ServiceException(key.getName() + " Class Must Have DefaultConstructor!");
        }
    }

    public static synchronized String changeNotify(String sql) throws InternalException {
        String dummySql = null;
        String[] args = null;
        String tableName = null;
        String whatCud = "";
        dummySql = sql.replaceAll("\n", "").replaceAll("\t", " ").replaceAll("[ ]", "^").replaceAll("[iI][nN][tT][oO]", "into").replaceAll("[fF][rR][oO][mM]", "from").replaceAll("[iI][nN][sS][eE][rR][tT]", "insert").replaceAll("[uU][pP][dD][aA][tT][eE]", "update").replaceAll("[dD][eE][lL][eE][Tt][eE]", "delete");
        try {
            args = ApacheCommonLangStringUtils.split(dummySql, "^");
            if (args[0].equalsIgnoreCase("INSERT")) {
                tableName = args[2];
                whatCud = "INSERT";
            } else if (args[0].equalsIgnoreCase("UPDATE")) {
                tableName = args[1];
                whatCud = "UPDATE";
            } else if (args[0].equalsIgnoreCase("DELETE")) {
                tableName = args[1].equalsIgnoreCase("FROM") ? args[2] : args[1];
                whatCud = "DELETE";
            }
        }
        catch (Throwable t) {
            throw new InternalException("TriggerRegister Error!", t);
        }
        return whatCud;
    }
}

