/*
 * Decompiled with CFR 0.152.
 */
package kwic.seed.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import kwic.seed.encrypt.CryptoSDKv20;
import kwic.seed.util.SecurityUtil;

public class Crypto {
    private int ENC_TYPE = 2;
    private String ENC_KEY = "kwic5539";
    private String MD_KEY = "kwic5539";

    public String encodeData(String strplain) throws Exception {
        return this.encodeData(strplain, this.ENC_KEY);
    }

    public String encodeData(String strplain, String encKey) throws Exception {
        byte[] cipher;
        String strResult = null;
        byte[] plain = strplain.getBytes();
        int rtnCode = CryptoSDKv20.MemEncryptV20(plain, 0, plain.length, cipher = new byte[2 * (plain.length + 100)], 0, encKey, this.ENC_TYPE);
        if (rtnCode <= 0) {
            switch (rtnCode) {
                case 0: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: \ud3c9\ubb38\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
                }
                case -1: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: \uc554\ud638\ud654 algorithm is not supported.");
                }
                case -2: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: \uc554\ud638\ud654\ubb38\uc774 \uc801\ud569\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                }
            }
            throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: " + rtnCode);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(cipher);
        strResult = baos.toString("8859_1");
        if (strResult == null || strResult.trim().equals("")) {
            return "";
        }
        strResult = strResult.trim();
        return strResult;
    }

    public byte[] encodeData(byte[] plain, String encKey) throws Exception {
        String strResult = null;
        byte[] cipher = new byte[2 * (plain.length + 100)];
        int rtnCode = CryptoSDKv20.MemEncryptV20(plain, 0, plain.length, cipher, 0, encKey, this.ENC_TYPE);
        if (rtnCode <= 0) {
            switch (rtnCode) {
                case 0: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: \ud3c9\ubb38\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
                }
                case -1: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: \uc554\ud638\ud654 algorithm is not supported.");
                }
                case -2: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: \uc554\ud638\ud654\ubb38\uc774 \uc801\ud569\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                }
            }
            throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: " + rtnCode);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(cipher);
        strResult = baos.toString("8859_1");
        if (strResult == null || strResult.trim().equals("")) {
            return plain;
        }
        strResult = strResult.trim();
        return strResult.getBytes("8859_1");
    }

    public void encodeFile(String strplain, String enFile) throws Exception {
        this.encodeFile(strplain, this.ENC_KEY, enFile);
    }

    public void encodeFile(String strplain, String encKey, String enFile) throws Exception {
        byte[] plain = strplain.getBytes();
        int rtnCode = CryptoSDKv20.Mem2FileEncryptV20(plain, 0, plain.length, enFile, encKey, this.ENC_TYPE);
        if (rtnCode <= 0) {
            switch (rtnCode) {
                case 0: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: \ud3c9\ubb38\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
                }
                case -1: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: " + enFile + " already exists or cannot be created.");
                }
                case -2: {
                    throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: algorithm is not supported ");
                }
            }
            throw new Exception("\uc554\ud638\ud654 \uc5d0\ub7ec: " + rtnCode);
        }
    }

    public String decodeData(String strCiper) throws Exception {
        return this.decodeData(strCiper, this.ENC_KEY);
    }

    public String decodeData(String strCiper, String enckey) throws Exception {
        byte[] plain;
        String rtn = null;
        byte[] cipher = null;
        cipher = strCiper.trim().getBytes("8859_1");
        int rtnCode = CryptoSDKv20.MemDecryptV20(cipher, 0, cipher.length, plain = new byte[cipher.length], 0, enckey);
        if (rtnCode <= 0) {
            switch (rtnCode) {
                case 0: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: \ubcf5\ud638\ud654\ud560 \uc218 \uc5c6\ub294 \ub0b4\uc6a9\uc785\ub2c8\ub2e4.");
                }
                case -1: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: plain \ubd80\ubd84\uc758 \ubc84\ud37c \uc0ac\uc774\uc988\uac00 \ubd80\uc871\ud569\ub2c8\ub2e4.");
                }
                case -2: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: \uc554\ud638\ud0a4\uac00 \ud2c0\ub838\uc2b5\ub2c8\ub2e4.");
                }
            }
            throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: " + rtnCode);
        }
        rtn = new String(plain, 0, rtnCode);
        if (rtn == null || rtn.trim().equals("")) {
            return strCiper;
        }
        rtn = rtn.trim();
        return rtn;
    }

    public byte[] decodeData(byte[] cipher, String enckey) throws Exception {
        byte[] plain = new byte[cipher.length];
        int rtnCode = CryptoSDKv20.MemDecryptV20(cipher, 0, cipher.length, plain, 0, enckey);
        if (rtnCode <= 0) {
            switch (rtnCode) {
                case 0: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: \ubcf5\ud638\ud654\ud560 \uc218 \uc5c6\ub294 \ub0b4\uc6a9\uc785\ub2c8\ub2e4.");
                }
                case -1: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: plain \ubd80\ubd84\uc758 \ubc84\ud37c \uc0ac\uc774\uc988\uac00 \ubd80\uc871\ud569\ub2c8\ub2e4.");
                }
                case -2: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: \uc554\ud638\ud0a4\uac00 \ud2c0\ub838\uc2b5\ub2c8\ub2e4!");
                }
            }
            throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: " + rtnCode);
        }
        byte[] rtnByte = new byte[rtnCode];
        System.arraycopy(plain, 0, rtnByte, 0, rtnCode);
        return rtnByte;
    }

    public String decodeFile(String enFile) throws Exception {
        return this.decodeFile(enFile, this.ENC_KEY);
    }

    public String decodeFile(String enFile, String enckey) throws Exception {
        File input = null;
        try {
            input = new File(enFile);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(enFile) + " Exception");
            throw new Exception(String.valueOf(enFile) + " \uc0dd\uc131\uc2dc Exception \ubc1c\uc0dd");
        }
        byte[] plain = new byte[(int)input.length() + 100];
        int rtnCode = CryptoSDKv20.File2MemDecryptV20(enFile, plain, 0, enckey);
        if (rtnCode <= 0) {
            switch (rtnCode) {
                case 0: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: " + enFile + "\uc740 \ubcf5\ud638\ud654\ud560 \uc218 \uc5c6\ub294 \ud30c\uc77c\uc785\ub2c8\ub2e4.");
                }
                case -1: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: " + enFile + "\uc744 \uc77d\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                case -2: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: plain \ubd80\ubd84\uc758 \ubc84\ud37c \uc0ac\uc774\uc988\uac00 \ubd80\uc871\ud569\ub2c8\ub2e4.");
                }
                case -3: {
                    throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: \uc554\ud638\ud0a4\uac00 \ud2c0\ub838\uc2b5\ub2c8\ub2e4.");
                }
            }
            throw new Exception("\ubcf5\ud638\ud654 \uc5d0\ub7ec: " + rtnCode);
        }
        return new String(plain).trim();
    }

    public String getFileData(String file) throws Exception {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String line = null;
                int linecnt = 0;
                while ((line = br.readLine()) != null) {
                    if (linecnt > 0) {
                        sb.append(System.getProperty("line.separator"));
                    }
                    sb.append(line);
                    ++linecnt;
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                throw new Exception("FileNotFoundException \ubc1c\uc0dd: " + fnfe.getMessage());
            }
            catch (IOException ioe) {
                throw new Exception("IOException \ubc1c\uc0dd: " + ioe.getMessage());
            }
            catch (Exception e) {
                throw new Exception("Exception \ubc1c\uc0dd: " + e.getMessage());
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                br = null;
            }
        }
        return sb.toString();
    }

    public void saveFileData(String endData, String file) throws Exception {
        try {
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));
            bout.write(endData.getBytes());
            bout.flush();
            bout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(String.valueOf(file) + " \ud30c\uc77c \uc800\uc7a5 \uc624\ub958: " + e.getMessage());
        }
    }

    public boolean makeFileErpData(String oriFile, String enFile) {
        String encodeStr;
        String secureKey;
        block11: {
            String encKey = this.ENC_KEY;
            secureKey = "";
            try {
                secureKey = SecurityUtil.getCryptoMD5String(this.MD_KEY);
            }
            catch (Exception e) {
                System.err.println("MD5 \uc218\ud589\uc2dc Exception \ubc1c\uc0dd[" + e.getMessage() + "]");
                return false;
            }
            if (oriFile == null || oriFile.trim().length() < 1) {
                System.err.println("\uc554\ud638\ud654\ud560 \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
                return false;
            }
            String originalStr = "";
            try {
                originalStr = this.getFileData(oriFile);
                if (encKey == null || encKey.trim().length() < 1) {
                    System.err.println("\uc554\ud638\ud654\ud0a4\ub97c \uc785\ub825\ud558\uc138\uc694.");
                    return false;
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return false;
            }
            encodeStr = "";
            try {
                encodeStr = this.encodeData(originalStr, encKey);
            }
            catch (Exception e) {
                System.err.println("encode Exception\ubc1c\uc0dd[" + e.getMessage() + "]");
                return false;
            }
            try {
                if (enFile != null && enFile.trim().length() >= 1) break block11;
                System.err.println("\uc800\uc7a5\ud560 \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
                return false;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return false;
            }
        }
        this.saveFileData(String.valueOf(secureKey) + encodeStr, enFile);
        return true;
    }

    public boolean unmakeFileErpData(String enFile) {
        boolean result = true;
        if (enFile == null || enFile.trim().length() < 1) {
            System.err.println("\ubcf5\ud638\ud654\ud560 \ud30c\uc77c\uc744 \uc120\ud0dd\ud558\uc138\uc694.");
            return false;
        }
        String encodedStr = this.getMDKey(enFile);
        String decodedStr = null;
        BufferedReader decodeBR = null;
        if (encodedStr != null) {
            decodedStr = this.makeDecode(encodedStr);
            if (decodedStr == null) {
                return false;
            }
            decodeBR = new BufferedReader(new StringReader(decodedStr));
        }
        try {
            BufferedReader br = null;
            if (encodedStr != null) {
                br = decodeBR;
            } else {
                br = new BufferedReader(new FileReader(enFile));
                System.err.println("\uc77d\uc740\ud30c\uc77c\uc740 MD5\ud0a4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                result = false;
            }
            String in = null;
            while ((in = br.readLine()) != null) {
                System.out.println("data_0[" + in + "]");
            }
            if (decodedStr != null) {
                br = new BufferedReader(new StringReader(decodedStr));
                while ((in = br.readLine()) != null) {
                    System.out.println("data_1[" + in + "]");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return false;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMDKey(String file) {
        try {
            String secureKey = "";
            try {
                secureKey = SecurityUtil.getCryptoMD5String(this.MD_KEY);
            }
            catch (Exception e) {
                return null;
            }
            BufferedReader br = new BufferedReader(new FileReader(file));
            String strRow = "";
            StringBuffer sb = new StringBuffer();
            strRow = br.readLine();
            if (strRow != null) {
                if (!strRow.startsWith(secureKey)) {
                    return null;
                }
                sb.append(strRow.substring(secureKey.getBytes().length));
            }
            while (true) {
                if ((strRow = br.readLine()) == null) {
                    if (br == null) break;
                    br.close();
                    return sb.toString();
                }
                sb.append(System.getProperty("line.separator"));
                sb.append(strRow);
            }
            return sb.toString();
        }
        catch (Exception e) {
            System.out.println("getMDKey() Exception: " + e.getMessage());
            return null;
        }
    }

    public String makeDecode(String encodedStr) {
        String encKey = this.ENC_KEY;
        if (encKey == null || encKey.trim().length() < 1) {
            System.err.println("\ubcf5\ud638\ud654\ud0a4\ub97c \uc785\ub825\ud558\uc138\uc694.");
            return null;
        }
        try {
            return this.decodeData(encodedStr, encKey);
        }
        catch (Exception e) {
            System.err.println("decode Exception\ubc1c\uc0dd[" + e.getMessage() + "]");
            return null;
        }
    }
}

