/*
 * Decompiled with CFR 0.152.
 */
package mup.mcash.module.common.McashCipher;

import mup.mcash.module.common.McashCipher.McashSeed;

public class McashCipher {
    private static String padding = "123456789123456789";
    private String tradeid;
    private byte[] hashKey = null;

    public McashCipher(String tradeid) {
        this.tradeid = tradeid;
        String tmpKey = tradeid;
        int keyLength = tradeid.length();
        tmpKey = keyLength < 16 ? String.valueOf(tmpKey) + padding.substring(0, 16 - keyLength) : tmpKey.substring(tmpKey.length() - 16, tmpKey.length());
        byte[] tmp = tmpKey.getBytes();
        int i = 0;
        while (i < 16) {
            tmp[i] = (byte)(tmp[i] ^ i + 1);
            ++i;
        }
        this.hashKey = tmp;
    }

    public String encodeString(String plainValue) {
        return McashSeed.encodeString(plainValue, this.hashKey);
    }

    public String decodeString(String cipherValue) {
        return McashSeed.decodeString(cipherValue, this.hashKey).trim();
    }

    public static byte[] getKey(String hashKey) {
        String tmpKey = hashKey;
        int keyLength = hashKey.length();
        tmpKey = keyLength < 16 ? String.valueOf(tmpKey) + padding.substring(0, 16 - keyLength) : tmpKey.substring(tmpKey.length() - 16, tmpKey.length());
        byte[] tmp = tmpKey.getBytes();
        int i = 0;
        while (i < 16) {
            tmp[i] = (byte)(tmp[i] ^ i + 1);
            ++i;
        }
        return tmp;
    }

    public static String encodeString(String plainValue, String hashKey) {
        return McashSeed.encodeString(plainValue, McashCipher.getKey(hashKey));
    }

    public static String decodeString(String cipherValue, String hashKey) {
        return McashSeed.decodeString(cipherValue, McashCipher.getKey(hashKey)).trim();
    }

    public static void main(String[] args) {
        String tradeid = "13424427496561354564564645646";
        String plainText = "\uc6d0\ubcf8\ud14d\uc2a4\ud2b8\uc785\ub2c8\ub2e4";
        String encodeText = McashCipher.encodeString(plainText, tradeid);
        String decodeText = McashCipher.decodeString(encodeText, tradeid).trim();
        System.out.println("\uc6d0\ubcf8:" + plainText);
        System.out.println("\uc554\ud638\ud654:" + encodeText);
        System.out.println("\ubcf5\ud638\ud654:" + decodeText);
        System.out.println("====================================================================");
        System.out.println(" \uac00\ub9f9\uc810\uce21 \uacb0\uc81c\uc815\ubcf4  \uc554\ud638\ud654 \uc804\ub2ec\uac12  ");
        System.out.println("====================================================================");
        tradeid = "20120706123456789";
        String Okurl = "www.daum.net";
        String Prdtprice = "55000";
        String Cryptstring = String.valueOf(Prdtprice) + Okurl;
        String cOkurl = McashCipher.encodeString(Okurl, tradeid);
        String cPrdtprice = McashCipher.encodeString(Prdtprice, tradeid);
        String cCryptstring = McashCipher.encodeString(Cryptstring, tradeid);
        System.out.println("Okurl=" + cOkurl);
        System.out.println("Prdtprice=" + cPrdtprice);
        System.out.println("Cryptstring=" + cCryptstring);
        System.out.println("====================================================================");
        System.out.println(" \ubaa8\ube4c\ub9ac\uc5b8\uc2a4  \uc804\ub2ec\uac12  \ubcf5\ud638\ud654 ");
        System.out.println("====================================================================");
        System.out.println("Okurl=" + McashCipher.decodeString(cOkurl, tradeid));
        System.out.println("Prdtprice=" + McashCipher.decodeString(cPrdtprice, tradeid));
        System.out.println("Cryptstring=" + McashCipher.decodeString(cCryptstring, tradeid));
        System.out.println("\uc554\ud638\ud654\uc804\ub2ec\uac12\uccb4\ud06c =" + McashCipher.decodeString(cCryptstring, tradeid).equals(String.valueOf(McashCipher.decodeString(cPrdtprice, tradeid)) + McashCipher.decodeString(cOkurl, tradeid)));
    }
}

